#include <OI/oi.H>
#include <stdlib.h>

/*
 *	Hex Entry Field
 *	
 *	This program provides a simple subclassing example.
 *	This program demonstrates how to create a hex entry
 *	field subclass from the OI_entry_field base class.
 *
 *	Under normal situations, the class definitions would be 
 *	defined in a separate include file, but they have been
 *	incorporated into this file for completeness.
 *
 *	The reader should refer back to the README file for
 *	more extensive subclassing examples.
 *
 *	The reader should refer to the OI documentation for
 *	information on the following member functions.
 *	- OIIntro
 *		OI_init()
 *		OI_begin_interaction()
 *	- OI_d_tech
 *		layout_associated_object()
 *		set_associated_object()
 *		set_layout()
 *	- OI_app_window
 *		oi_create_app_window()
 *	- OI_entry_field
 *		set_char_chk()
 *			OI_EF_CHAR_CHK_BAD
 *			OI_EF_CHAR_CHK_INSERT
 */


/*
 *	Define the HexEntryField class, derived from the
 *	OI_entry_field base class.
 *
 *	The class definition contains two member functions:
 *		- char_chk
 *			this member function is used as the default
 *			character check function, and is called every
 *			time a character is typed to validate the
 *			character.
 *		- HexEntryField
 *			object constructor
 */
class	HexEntryField : public OI_entry_field {
 private:
	OI_ef_char_chk_status	char_chk(OI_entry_field*,void*,OI_number,char) ;
 public:
				HexEntryField(char*,OI_number,char* =NULL,char* ="0") ;
				~HexEntryField();
} ;
HexEntryField::~HexEntryField() { } /* declared out-of-line for the compiler */

/*
 *	HexEntryField::HexEntryField
 *
 *	The HexEntryField object constructor.  The HexEntryField
 *	constructor requires the following arguments:
 *		1. object name, 
 *		2. number of characters displayed in the entry field
 *		3. default entry field label,
 *		4. default value to display.
 *	The base class (OI_entry_field) uses these arguments along with
 *	a fifth argument (maximum number of characters).  In this example
 *	we will default the maximum number of characters to equal the
 *	number of characters displayed.
 *
 *	When invoked, the HexEntryField constructor first invokes the
 *	base class (OI_entry_field) constructor with appropriate arguments.
 *	If the base class constructor was successful, we set the char_chk
 *	function to HexEntryField::char_chk.
 */	
HexEntryField::HexEntryField (
	char		*usr_namp,	/* object name */
	OI_number	len,		/* # chars displayed in entry field */
	char		*labp,		/* ptr to label for field */
	char		*defp)		/* ptr to default string */
	: OI_entry_field(usr_namp,len,labp,defp,len)
{
	if (OI_status >= 0) {
		set_char_chk(this,(OI_ef_char_chk_memfnp)&HexEntryField::char_chk) ;
	}
}

/*
 *	HexEntryField::char_chk
 *
 *	This member function validates each character as typed.
 *	If the character is not a valid hexadecimal character
 *		[0-9, a-f, A-F]
 *	then an error (OI_EF_CHAR_CHK_BAD) is returned, otherwise
 *	success (OI_EF_CHAR_CHK_INSERT) is returned.
 *
 */
OI_ef_char_chk_status
HexEntryField::char_chk (OI_entry_field*, void*, OI_number, char c)
{
	OI_ef_char_chk_status	ok ;

	ok = OI_EF_CHAR_CHK_BAD ;
	if ((c != '\0') && isxdigit(c))
		ok = OI_EF_CHAR_CHK_INSERT ;
	return(ok) ;
}


/*
 *	Main
 *
 *	This procedure demonstrates the basic concepts of creating an
 *	OI application:
 *		1. initialize OI
 *		2. create the application window, and specify the layout mode.
 *		3. create a HexEntryField
 *		4. layout the HexEntryField within the application window.
 *		5. associate the application window with it's root.
 *		6. begin interaction.
 */
void
main (int argc, char **argv)
{
	OI_connection	*conp ;
	OI_app_window	*wp ;
	HexEntryField	*hex_efp ;

	
	/*
	 * Open a connection.
	 */
	if (conp = OI_init(&argc,argv,"OITest")) {

		/*
		 * Create the hexef main window.  Make it row layout.
		 */
		wp = oi_create_app_window("main",10,10,"Hex Entry Field") ;
		wp->set_layout(OI_layout_row) ;

		/*
		 * Create the HexEntry Field object.  Layout this object
		 * into row 10, column 10 of the main window.
		 */
		hex_efp = new HexEntryField("hexef",8,"Address: ") ;
		hex_efp->layout_associated_object(wp,10,10,OI_ACTIVE) ;

		/*
		 * OK, display main window.
		 */
		wp->set_associated_object(wp->root(),OI_DEF_LOC,OI_DEF_LOC,OI_ACTIVE) ;
		OI_begin_interaction() ;

		/*
		 * Cleanup.  Make sure that we cleanup the library.
		 */
		OI_fini();
	}
}
