#include <OI/oi.H>
#include <string.h>

/*
 *	Hierarchy
 *
 *	This program demonstrates dynamically creating a menu.  It also
 *	provides both a menu and printed form of the OI class hierarchy.
 *
 *	The reader should refer to the OI documentation for
 *	information on the following member functions.
 *		- OIIntro
 *			OI_init()
 *			OI_begin_interaction()
 *			OI_fini()
 *		- OI_d_tech
 *			del()
 *			layout_associated_object()
 *			set_associated_object()
 *		- OI_app_window
 *			oi_create_app_window()
 *		- OI_excl_check_menu
 *			oi_excl_check_menu()
 *		- OI_menu
 *			add_cell()
 *		- OI_menu_cell
 *			oi_create_menu_cell()
 */



/*
 *	define the command line arguments
 */
static OI_bool	print_tree	= OI_NO ;
static XrmOptionDescRec opTable[] = {
	{"-print",	"*print",	XrmoptionIsArg, (caddr_t)NULL },
} ;


/*
 *	tab control
 *
 *	The following three routines control tabbing for printing the object
 *	hierarchy.  We are making an assumption that the hierarchical tree is
 *	less than 512 levels deep.  
 *	print_sibling : prints the current tab level and the object name.
 *	print_derived : adds one level of tabbing, then prints the object.
 *	remove_tab_level : removes one level of tabbing.
 */
static char	tabs[ 512 ] = { '\0' };
static void	print_sibling( char * name )
{
	if (print_tree)
		fprintf( stderr, "%s%s\n", tabs, name );
};
static void	print_derived( char * name )
{
	int	n = strlen( tabs );
	tabs[ n ] = '\t';
	tabs[ n+1 ] = '\0';
	print_sibling( name );
}
static void	remove_tab_level()
{
	int	n = strlen( tabs );
	if (n)
		tabs[ --n ] = '\0';
}


/*
 *	sibling	**recursive function**
 *
 *	This routine adds the sibling object as a cell within it's parent.
 *	If the object contains derived objects, walk them (add as pull right menus to this menu).
 *	If the object contains sibling objects, walk them (add as cells within this menu).
 *
 */
static void	derived( OI_d_tech * objp, OI_class * drvp ) ;
static void
sibling( OI_d_tech * objp, OI_class * drvp )
{
	char		buf[ 1024 ];
	OI_menu		*menu = (OI_menu *)objp ;

	if (strcmp( "OI_mdl", drvp->name()) != 0 && strcmp("OI_layout_method", drvp->name()) != 0) {
		print_sibling( drvp->name() );
		sprintf( buf, "sibling_%s", drvp->name() );
		if ((objp = oi_create_menu_cell( buf, drvp->name() ) ))
			menu->add_cell( (OI_menu_cell *) objp, menu->num_cells() + 1 );

		if (drvp->derived())
			derived( objp, drvp->derived() );
	}
	if (drvp->sibling())
		//sibling( cellp->parent(), drvp->sibling() );
		sibling( menu, drvp->sibling() );
}


/*
 *	derived  **recursive function**
 *
 *	The internal OI structure contains three leaves: OI_mdl, OI_d_tech, and OI_layout_method.
 *	For demo purposes, we are supressing the OI_mdl (model dependent) structure.
 *
 *	This routine adds the derived object as a pull right off of its parent.
 *	If the object contains derived objects, walk them (add as pull right menus to this menu).
 *	If the object contains sibling objects, walk them (add as cells within this menu).
 *	
 */
static void
derived( OI_d_tech * objp, OI_class * drvp )
{
	OI_menu		*menu ;
	OI_menu_cell	*cellp ;
	char		buf[ 1024 ];

	if (strcmp( "OI_mdl", drvp->name()) != 0 && strcmp("OI_layout_method", drvp->name()) != 0) {
		print_derived( drvp->name() );

		sprintf( buf, "sibling_%s", drvp->name() );
		if ((cellp = oi_create_menu_cell( buf, drvp->name() ) )) {
			sprintf( buf, "node_%s", drvp->name() );
			menu = oi_excl_check_menu( buf, 1, &cellp, OI_VERTICAL, NULL );
			menu->set_associated_object( objp, OI_def_loc, OI_def_loc, OI_ACTIVE_NOT_DISPLAYED );
			objp = cellp ;
		}

		if (drvp->derived())
			derived( objp, drvp->derived() );
	}
	if (drvp->sibling())
		sibling( objp->parent(), drvp->sibling() );
	remove_tab_level();
}

/*
 *	derive the oi class tree
 *
 *	This routine
 *		- creates a base menu, with one cell.
 *		- calls derived() to build the hierarchical structure into the base menu.
 *		- removes the seed cell.
 *		- places the menu onto the root window.
 */
static void
derive_oi_class_tree( OI_d_tech * wp )
{
	OI_menu		*menu ;
	OI_menu_cell	*cellp ;

	cellp = oi_create_menu_cell( "seed", "seed" ) ;
	menu = oi_excl_check_menu( "OI_hierarchy", 1, &cellp, OI_VERTICAL, "OI_hierarchy" );
	derived( cellp, OI_class_tree() );
	//sibling( cellp, OI_class_tree() );
	cellp->del();
	menu->layout_associated_object( wp, 1, 1, OI_ACTIVE );
}


void
main (int argc, char**argv)
{
	OI_connection	*conp ;
	OI_app_window	*wp ;

	
	/*
	 *	Open a connection.
	 */
	if (conp = OI_init(&argc, argv, "HelloWorld", NULL, opTable, OI_count( opTable ) )) {
		/*
		 *	get command line arguments
		 */
		if (conp->get_resource( "print", "Print" ))
			print_tree = OI_YES ;

		/*
		 *	create the application window.
		 */
		wp = oi_create_app_window("main",200,100,"Complete OI Hierarchy") ;
		wp->set_layout( OI_layout_row );

		/*
		 *	If the OI_class_tree exists, chass the tree and build a
		 *	hierarchical menu of OI objects.
		 */
		derive_oi_class_tree( wp ) ;

		/*
		 *	display the application, 
		 *	then begin interaction
		 */
		wp->set_associated_object(wp->root(), OI_DEF_LOC, OI_DEF_LOC, OI_ACTIVE) ;
		OI_begin_interaction() ;
	}

	/*
	 *	Cleanup.  Make sure that we cleanup the library.
	 */
	OI_fini() ;
}
