/*
 ******************************************************************************
 *
 *	ParcPlace Systems, Inc.
 *	Copyright (c) 1990, ParcPlace Systems, Inc. USA   All rights reserved.
 *
 ****************************************************************************
 *
 *	File:	savrst.H
 *
 *	Functions(s):
 *
 *	Description:
 *		Header for functions used for sav/restore of an application
 *		in the format used by the prototyper
 *
 *	RCSid = "$Id: savrst.H,v 4.6.1.2 1993/08/12 15:37:58 toml Exp $"
 *
 ****************************************************************************
 */

#ifndef OI_savrst_H
#define OI_savrst_H

#ifndef OI_cvt_H
#include <OI/cvt.H>
#endif

#ifndef OI_d_tech_H
#include <OI/d_tech.H>
#endif

		class	OI_save_stack {				// attributes common to saving objects
			//==> general variables
			char		*separator ;
			//==> path storage
			int		max_path_len ;			// malloc'd string length
			char		*object_path ;			// malloc'd string for object path.
			//==> object stack pointer storage
			int		max_stack_depth ;		// size of malloc'd stack pointers
			char		**stck ;			// pointer into current stack
			int		sp ;				// index into stack pointer array
		private:
		const	char		*identify_root_children( OI_number, OI_d_tech**, OI_bool = OI_NO );
		public:
					OI_save_stack(const char *appname, int szStr, int szStack) ;
					~OI_save_stack(void) ;
			void		save_topLevel( FILE*, XrmDatabase, OI_number, OI_d_tech**);
			void		save_baseClass( FILE*, XrmDatabase, OI_number, OI_d_tech**);
			void		save_resource(FILE*, XrmDatabase, const char*, const char*, OI_resource* =NULL) ;
			void		push(const char *objname) ;
			void		pop(void);
			void		modify_separator(char *c)	{separator = c;}
		} ;

		class	OI_forward_ref_info {
			OI_d_tech		*dtp ;		/* this object of interest */
			OI_alpha_callback	*alpha_cbp ;	/* pointer to binding spec */
			OI_cb_class		*cb_clsp ;	/* class object for callback to resolve */
		public:
						OI_forward_ref_info(OI_d_tech*, OI_alpha_callback*, OI_cb_class*) ;
						~OI_forward_ref_info() ;
			OI_alpha_callback	*alpha_callback()	{ return(alpha_cbp); }
			OI_cb_class		*class_object()		{ return(cb_clsp); }
			OI_d_tech		*object()		{ return(dtp); }
		};

	typedef	void			(OI_uib_bind_fn)(OI_cb_inf*) ;		/* post callback binding function */
	typedef	void			(OI_uib_var_fn)(const char*, const char*) ;	/* post user variable */

 /* functions used during binding process */
		void			OI_obj_save(const char*, XrmDatabase db, OI_number, OI_d_tech**, char* hdr=NULL,
					OI_uib_bind_fn* =NULL, OI_uib_var_fn* =NULL, OI_bool=OI_no, OI_bool=OI_yes);
		OI_alpha_callback	*OI_get_alpha_callback(const char*) ;			/* get alpha callback spec */

 /* should be private to OI */
		void			OI_post_bind(OI_cb_inf*) ;				/* post name of binding object */
		void			OI_post_var(const char*,const char*) ;			/* post name of external variable for OI object */

#endif /* OI_savrst_H */
