/*
 ******************************************************************************
 *
 *	ParcPlace Systems, Inc.
 *	Copyright (c) 1990, ParcPlace Systems, Inc. USA   All rights reserved.
 *
 ****************************************************************************
 *
 *	File:	pixmap.H
 *
 *	Functions(s):
 *
 *	Description:
 *		OI_pixmap class header
 *
 *	RCSid = "$Id: pixmap.H,v 4.1.1.1 1993/06/01 22:56:00 mth Exp $"
 *
 ****************************************************************************
 */

#ifndef OI_pixmap_H
#define OI_pixmap_H

		class	OI_pixmap	{		/* cached pixmap info */
			OI_pixmap	*nxt;		/* ptr to next pixmap in list */
			OI_pixmap	*prv;		/* ptr to previous pixmap in list */
			Pixmap		pmap;		/* the X pixmap */
			OI_number	wid;		/* width of the pixmap */
			OI_number	ht;		/* height of the pixmap */
			OI_number	dpth;		/* depth of the pixmap */
			OI_number	xh;		/* X hotspot */
			OI_number	yh;		/* Y hotspot */
			XrmQuark	namq;		/* quarkified name */
			OI_number	ref_cnt ;	/* reference count for font */
			OI_bool		del;		/* should the pixmap be destroyed */
		public:
					OI_pixmap(class OI_connection*, Pixmap,char*, OI_bool,
						OI_number= -1, OI_number= -1, OI_number= -1, OI_number= -1, OI_number=- 1) ;
			OI_number	ref_count()		{ return (ref_cnt); }
			OI_pixmap	*next()			{ return(nxt); }
			OI_pixmap	*prev()			{ return(prv); }
			XrmQuark	nameq()			{ return(namq); }
			OI_bool		destroy()		{ return(del); }
			Pixmap		pixmap()		{ return(pmap); }
			OI_number	width()			{ return(wid); }
			OI_number	height()		{ return(ht); }
			OI_number	x_hot()			{ return (xh); }
			OI_number	y_hot()			{ return (yh); }
			OI_number	depth()			{ return(dpth); }
			char		*name() ;
			void		ref()			{ ref_cnt++; }
			OI_bool		deref(class OI_connection*) ;
			void		set_next(OI_pixmap *p)	{ nxt=p; }
			void		set_prev(OI_pixmap *p)	{ prv=p; }
			void		set_destroy(OI_bool d)	{ del=d; }
		} ;

#endif /* OI_pixmap_H */
