/* Mouse interface for svgalib. */
/* Can be used independently. */

#ifndef MOUSE_H
#define MOUSE_H

#ifdef __cplusplus
extern "C" {
#endif

#define	MOUSE_MICROSOFT 0
#define MOUSE_MOUSESYSTEMS 1
#define MOUSE_MMSERIES 2
#define MOUSE_LOGITECH 3
#define MOUSE_BUSMOUSE 4
#define MOUSE_PS2 5

#define MOUSE_LEFTBUTTON 4
#define MOUSE_MIDDLEBUTTON 2
#define MOUSE_RIGHTBUTTON 1

#define MOUSE_DEFAULTSAMPLERATE 150

/* Initialize mouse device. Returns 0 if succesful. */
/* (Get the svgalib configured type with vga_getmousetype()). */
int mouse_init( char *dev, int type, int samplerate );
/* Set event handler invoked by mouse_update(). */
void mouse_seteventhandler( void (*handler)( int button, int dx, int dy ) );
/* Close mouse device. */
void mouse_close();
/* Read mouse and handle events. Returns 0 if no event. */
int mouse_update();
/* Similar to mouse_update, but wait for an event to happen. */
void mouse_waitforupdate();

/* mouse_init sets default event handler that keeps track of absolute */
/* coordinates: */

#define MOUSE_NOWRAP 0
#define MOUSE_WRAPX 1
#define MOUSE_WRAPY 2
#define MOUSE_WRAP 3

/* Revert to default handler. */
void mouse_setdefaulteventhandler();
/* Set position of mouse. */
void mouse_setposition( int x, int y );
/* Set horizontal range of mouse to [x1, x2] incl. */
void mouse_setxrange( int x1, int x2 );
/* Set vertical range of mouse to [y1, y2] incl. */
void mouse_setyrange( int y1, int y2 );
/* Set scale factor by which raw mouse coordinates are divided. */
void mouse_setscale( int s );
/* Enable/disable wrapping of mouse in horizontal and/or vertical range. */
void mouse_setwrap( int w );

/* Get current mouse x-coordinate. */
int mouse_getx();
/* Get current mouse y-coordinate. */
int mouse_gety();
/* Get current mouse button status. */
int mouse_getbutton();

#ifdef __cplusplus
}
#endif

#endif
