/* 'new' config.h:
 *	A configuration file designed to make best use of the abilities
 *	of ircII, and trying to make things more intuitively understandable.
 *
 * Done by Carl v. Loesch <lynx@dm.unirm1.it>
 * Based on the 'classic' config.h by Michael Sandrof.
 * Copyright(c) 1991 - See the COPYRIGHT file, or do a HELP IRCII COPYRIGHT 
 *
 * Warning!  You will most likely have to make changes to your .ircrc file to
 * use this version of IRCII!  Please read the INSTALL and New2.2 files
 * supplied with the distribution for details!
 */

#ifndef _CONFIG_H_
#define _CONFIG_H_

/*
 * Set your favorite default server list here.  This list should be a
 * whitespace separated hostname:portnum:password list (with portnums and
 * passwords optional).  This IS NOT an optional definition. Please set this
 * to your nearest servers.  However if you use a seperate 'ircII.servers'
 * file and the ircII can find it, this setting is overridden.
 */
#define DEFAULT_SERVER	"ra.oc.com"

/*
 * Uncomment the following if the gecos field of your /etc/passwd has other
 * information in it that you don't want as the user name (such as office
 * locations, phone numbers, etc).  The default delimiter is a comma, change
 * it if you need to. If commented out, the entire gecos field is used. 
 */
#define GECOS_DELIMITER ',' 

/*
 * Set the following to 1 if you wish for IRCII not to disturb the tty's flow
 * control characters as the default.  Normally, these are ^Q and ^S.  You
 * may have to rebind them in IRCII.  Set it to 0 for IRCII to take over the
 * tty's flow control.
 */
#define USE_FLOW_CONTROL 0

/*
 * Below you can set what type of mail your system uses and the path to the
 * appropriate mail file/directory.  Only one may be selected. 
 * You may also undefine both if you think mail checking in irc clients is
 * silly.
 */
/* AMS_MAIL is the Andrew Mail System mail format. */
#undef AMS_MAIL

/* UNIX_MAIL is the normal unix mail format.  */
#undef UNIX_MAIL "/usr/spool/mail"

#ifdef AMS_MAIL
# define AMS_MAIL "Mailbox"
#endif /* AMS_MAIL */

/*
 * MAIL_DELIMITER specifies the unique text that separates one mail message
 * from another in the mail spool file when using UNIX_MAIL.
 */
#define MAIL_DELIMITER "From "

/* Thanks to Allanon a very useful feature, when this is defined, ircII will
 * be able to read help files in compressed format (it will recognize the .Z)
 * If you undefine this you will spare some code, though, so better only
 * set if you are sure you are going to keep your help-files compressed.
 */
/* Also now works for /LOADed files */
#define ZCAT "/afs/iastate.edu/public/compression/bin/dec/gzcat"
#define ZSUFFIX ".gz"

/* Make ^Z stop the irc process by default,
 * if undefined, ^Z will self-insert by default
 */
#define ALLOW_STOP_IRC

/* define this if you like to use the old highlight characters */
/*   OLD                NEW
 *   ^B                 ^V      Reverse
 *   ^_                 ^B      Bold
 *   ^V                 ^_      Underline
 */
#define OLD_HIGHLIGHT_CHARS

/* And here is the port number for default client connections.  */
#define IRC_PORT 6667

/*
 * With this version IRCII help services are being regionalised, so you
 * will need to set that to your nearest help service (see below).
 * DEFAULT_HELP_SERVICE should never be commented out.
 */

/*
 * Help services are now regionalised.  Set DEFAULT_HELP_SERVICE to
 * one of the following, or to NULL, if you wish no have no default.
 *
 *  NOTE: it is important to leave the double quotes (") in here.
 *
 *	"IrcIIhelp"
 *	"help_AU"
 *	"help_US"
 *	"help_EU"
 *	"help_UK"
 */

#define	DEFAULT_HELP_SERVICE "IrcIIhelp"

/*
 * If you want to have a file containing the list of irc servers to 
 * use, define SERVERS_FILE to be that filename.  Put the file in the 
 * ircII library directory.  This file should be whitespace seperated
 * hostname:portnum:password (with the portnum and password being
 * optional).  This server list will supercede the DEFAULT_SERVER
 */
#define SERVERS_FILE "/usr/local/lib/irc/ircII.servers"

/* Uncomment the following if you want ircII to display the file
 * ircII.motd in the ircII library at startup.
 */
#undef MOTD_FILE
#undef PAUSE_AFTER_MOTD 1

/*
 * define this if you want your irc client to exit after an 
 * operator kill.
 */
#undef QUIT_ON_OPERATOR_KILL

/* 
 * Define this if you dont want/dont use DCC TALK and SUMMON
 */
#define NO_DCC_TALK

/*
 * Define this if you want to have the option of C_LIKE_PARSING
 * THIS DOES NOT MAKE C_LIKE_PARSING THE DEFAULT
 */
#define C_LIKE_PARSING

/*
 * Below are the IRCII variable defaults.  For boolean variables, use 1 for
 * ON and 0 for OFF.  You may set string variable to NULL if you wish them to
 * have no value.  None of these are optional.  You may *not* comment out or
 * remove them.  They are default values for variables and are required for
 * proper compilation.
 */
#define DEFAULT_TERM_COMPRESS 1
#define DEFAULT_TERM_PRIORITY 0
#define DEFAULT_ALWAYS_SPLIT_BIGGEST 1
#define DEFAULT_AUTO_RECONNECT 1
#define DEFAULT_AUTO_REJOIN 1
#define DEFAULT_AUTO_UNMARK_AWAY 1
#define DEFAULT_AUTO_WHOWAS 1
#define DEFAULT_BEEP 1
#define DEFAULT_BEEP_MAX 2
#define DEFAULT_BEEP_ON_MSG "NONE"
#define DEFAULT_BEEP_WHEN_AWAY 0
#define	DEFAULT_BOLD_VIDEO 1
#define DEFAULT_CHANNEL_NAME_WIDTH 10
#define DEFAULT_CLOCK 1
#define DEFAULT_CLOCK_24HOUR 0
#define DEFAULT_CLOCK_ALARM NULL
#define DEFAULT_CMDCHARS "/"
#define DEFAULT_COMMAND_MODE 0
#define DEFAULT_CONTINUED_LINE "+"
#define	DEFAULT_DCC_BLOCK_SIZE 512
#define DEFAULT_DISPLAY 1
#define DEFAULT_EIGHT_BIT_CHARACTERS 0
#define DEFAULT_ENCRYPT_PROGRAM NULL
#define DEFAULT_EXEC_PROTECTION 0
#define DEFAULT_FLOOD_AFTER 3
#define DEFAULT_FLOOD_RATE 3
#define DEFAULT_FLOOD_USERS 3
#define DEFAULT_FLOOD_WARNING 0
#define DEFAULT_FULL_STATUS_LINE 1
#define DEFAULT_HELP_PAGER 1
#define DEFAULT_HELP_PROMPT 1
#define DEFAULT_HELP_WINDOW 0
#define DEFAULT_HIDE_PRIVATE_CHANNELS 0
#define DEFAULT_HIGHLIGHT_CHAR "INVERSE"
#define DEFAULT_HISTORY 50
#define DEFAULT_HISTORY_FILE NULL
#define DEFAULT_HOLD_MODE 0
#define DEFAULT_HOLD_MODE_MAX 0
#define DEFAULT_INDENT 0
#define DEFAULT_INPUT_ALIASES 0
#define DEFAULT_INPUT_PROMPT "> "
#define DEFAULT_INPUT_PROTECTION 1
#define DEFAULT_INSERT_MODE 1
#define DEFAULT_INVERSE_VIDEO 1
#define DEFAULT_LASTLOG 75
#define DEFAULT_LASTLOG_LEVEL "ALL DCC -CRAP"
#define DEFAULT_LOG 0
#define DEFAULT_LOGFILE "irc.log"
#define DEFAULT_MAIL 1
#define DEFAULT_MAX_RECURSIONS 25
#define DEFAULT_MINIMUM_SERVERS 0
#define DEFAULT_MINIMUM_USERS 0
#define DEFAULT_MODE_STRIPPER 0
#define DEFAULT_NO_CTCP_FLOOD 1
#define DEFAULT_NOTIFY_HANDLER "O"
#define DEFAULT_NOTIFY_LEVEL "ALL DCC"
#define DEFAULT_NOTIFY_ON_TERMINATION 0
#define DEFAULT_SCROLL 1
#define DEFAULT_SCROLL_LINES 1
#define DEFAULT_SEND_IGNORE_MSG 0
#define DEFAULT_SHELL "/bin/bash"
#define DEFAULT_SHELL_FLAGS "-c"
#define DEFAULT_SHELL_LIMIT 0
#define DEFAULT_SHOW_AWAY_ONCE 1
#define DEFAULT_SHOW_CHANNEL_NAMES 1
#define DEFAULT_SHOW_END_OF_MSGS 1
#define DEFAULT_SHOW_NUMERICS 0
#define	DEFAULT_SHOW_STATUS_ALL 1
#define DEFAULT_SHOW_WHO_HOPCOUNT 0
#define DEFAULT_STATUS_AWAY " (Gone)"
#define DEFAULT_STATUS_CHANNEL " on %C"
#define DEFAULT_STATUS_CHANOP "@"
#define DEFAULT_STATUS_CLOCK " %T"
#define DEFAULT_STATUS_FORMAT "%T [%R] %*%@%N%#%S%H%B%Q%A%C%+%I%O%M%F%U %W"
#define DEFAULT_STATUS_HOLD " --- more ---"
#define DEFAULT_STATUS_HOLD_LINES " (%B)"
#define DEFAULT_STATUS_INSERT ""
#define DEFAULT_STATUS_MODE " (+%+)"
#define DEFAULT_STATUS_MAIL " [Mail: %M]"
#define DEFAULT_STATUS_NO_REPEAT 0
#define	DEFAULT_STATUS_NOTIFY " [Activity: %F]"
#define DEFAULT_STATUS_OPER "*"
#define DEFAULT_STATUS_OVERWRITE " (overtype)"
#define DEFAULT_STATUS_QUERY " [Query: %Q]"
#define DEFAULT_STATUS_SERVER " via %S"
#define DEFAULT_STATUS_UMODE " (+%#)"
#define DEFAULT_STATUS_USER " * -IrcII2.3.17+tv- type /help for help"
#define DEFAULT_STATUS_USER1 ""
#define DEFAULT_STATUS_USER2 ""
#define DEFAULT_STATUS_USER3 ""
#define DEFAULT_STATUS_WINDOW "^^^^^^^^"
#define DEFAULT_SUPPRESS_SERVER_MOTD 1
#define DEFAULT_SUPPRESS_FROM_REMOTE_SERVER 0
#define DEFAULT_TAB 1
#define	DEFAULT_TAB_MAX 8
#define DEFAULT_UNDERLINE_VIDEO 1
#define DEFAULT_USE_OLD_MSG 0
#define DEFAULT_USERINFO "ircII2.3.17+10.3+term+voice -My clients better than yours is."
#define	DEFAULT_USER_WALLOPS 1
#define DEFAULT_VERBOSE_CTCP 0
#define DEFAULT_WARN_OF_IGNORES 1
#define DEFAULT_XTERM_OPTIONS NULL

/* define these if you want them included */
#define COMMAND_LINE_B               /* Allows for bots */
#define COMMAND_LINE_L               /* Allows for other .ircrcs to be loaded */
#define ON_KICK                      /* Self Explanitory */
#undef  ENFORCE_STRICTER_PROTOCOL    /* Disallow things that are not
                                        technically illegal */
#endif /* _CONFIG_H_ */
