------------------------------------------------------------------------------
--                                                                          --
--                         GNAT COMPILER COMPONENTS                         --
--                                                                          --
--                                U S A G E                                 --
--                                                                          --
--                                B o d y                                   --
--                                                                          --
--                            $Revision: 1.33 $                             --
--                                                                          --
--           Copyright (c) 1992,1993,1994 NYU, All Rights Reserved          --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. --
--                                                                          --
------------------------------------------------------------------------------

with Osint;  use Osint;
with Output; use Output;

procedure Usage is

   procedure Write_Switch_Character is
   begin
      if MS_DOS then
         Write_Char ('/');
      else
         Write_Char ('-');
      end if;
   end Write_Switch_Character;

begin

   --  Usage line

   Write_Str ("Usage: ");
   Write_Program_Name;
   Write_Char (' ');
   Write_Str ("switches sfile");
   Write_Eol;
   Write_Eol;

   --  Line for -a switch

   Write_Str ("  ");
   Write_Switch_Character;
   Write_Str ("a      Assertions enabled. Pragma Ass");
   Write_Str ("ert and pragma Debug to be activated");
   Write_Eol;

   --  Line for -b switch

   Write_Str ("  ");
   Write_Switch_Character;
   Write_Str ("b      Generate brief messages to std");
   Write_Str ("err even if verbose mode set");
   Write_Eol;

   --  Line for -c switch

   Write_Str ("  ");
   Write_Switch_Character;
   Write_Str ("c      Check syntax and semantics onl");
   Write_Str ("y (no code generation attempted)");
   Write_Eol;

   --  Line for -e switch

   Write_Str ("  ");
   Write_Switch_Character;
   Write_Str ("e      Error messages generated immed");
   Write_Str ("iately, not saved up till end");
   Write_Eol;

   --  Line for -f switch

   Write_Str ("  ");
   Write_Switch_Character;
   Write_Str ("f      Full errors. Normally only fir");
   Write_Str ("st error on each line is reported.");
   Write_Eol;

   --  Line for -g switch

   Write_Str ("  ");
   Write_Switch_Character;
   Write_Str ("g      GNAT style checks enabled");
   Write_Eol;

   --  Line for -i switch

   Write_Str ("  ");
   Write_Switch_Character;
   Write_Str ("i?     Identifier char set (?=1/2/3/4/p");
   Write_Str ("/f/n/w) default = i1 (Latin-1)");
   Write_Eol;

   --  Line for -k switch

   Write_Str ("  ");
   Write_Switch_Character;
   Write_Str ("knnn   Limit file names to nnn characters (k = krunch)");
   Write_Eol;

   --  Line for -l switch

   Write_Str ("  ");
   Write_Switch_Character;
   Write_Str ("l      Output full source listing wi");
   Write_Str ("th embedded error messages");
   Write_Eol;

   --  Line for -m switch

   Write_Str ("  ");
   Write_Switch_Character;
   Write_Str ("mnnn   Limit number of detected error");
   Write_Str ("s to nnn (1-999)");
   Write_Eol;

   --  Line for -n switch

   Write_Str ("  ");
   Write_Switch_Character;
   Write_Str ("n      No inlining of subprograms (");
   Write_Str ("ignore pragma Inline)");
   Write_Eol;

   --  Line for -p switch

   Write_Str ("  ");
   Write_Switch_Character;
   Write_Str ("p      Suppress all checks");
   Write_Eol;

   --  Line for -r switch

   Write_Str ("  ");
   Write_Switch_Character;
   Write_Str ("r      Reference manual column layout");
   Write_Str (" required");
   Write_Eol;

   --  Lines for -s switch

   Write_Str ("  ");
   Write_Switch_Character;
   Write_Str ("s      Syntax check only");
   Write_Eol;

   --  Lines for -t switch

   Write_Str ("  ");
   Write_Switch_Character;
   Write_Str ("t      Try semantics, even if parse errors");
   Write_Eol;

   --  Line for -u switch

   Write_Str ("  ");
   Write_Switch_Character;
   Write_Str ("u      List units for this compilation");
   Write_Eol;

   --  Line for -v switch

   Write_Str ("  ");
   Write_Switch_Character;
   Write_Str ("v      Verbose mode. Full error outp");
   Write_Str ("ut with source lines to stdout");
   Write_Eol;

   --  Lines for -w switch

   Write_Str ("  ");
   Write_Switch_Character;
   Write_Str ("w?     Warning mode. (?=s/e for supp");
   Write_Str ("ress/treat as error)");
   Write_Eol;

   --  Lines for -x switch

   Write_Str ("  ");
   Write_Switch_Character;
   Write_Str ("x?     Cross-reference level and switches");
   Write_Str (" (?=1/2/3/4/b/s)");
   Write_Eol;

   --  Line for -83 switch

   Write_Str ("  ");
   Write_Switch_Character;
   Write_Str ("83     Enforce Ada 83 restrictions");
   Write_Eol;

   --  Line for sfile

   Write_Str ("  sfile   Source file names");

   if MS_DOS then
      Write_Str (" (wild cards allowed for multiple files)");
   end if;

   Write_Eol;

end Usage;
