------------------------------------------------------------------------------
--                                                                          --
--                 GNU ADA RUNTIME LIBRARY (GNARL) COMPONENTS               --
--                                                                          --
--                    S Y S T E M . P O S I X _ T i m e r s                 --
--                                                                          --
--                                  S p e c                                 --
--                                                                          --
--                             $Revision: 1.2 $                             --
--                                                                          --
--           Copyright (c) 1991,1992,1993, FSU, All Rights Reserved         --
--                                                                          --
--  GNARL is free software; you can redistribute it and/or modify it  under --
--  terms  of  the  GNU  Library General Public License as published by the --
--  Free Software Foundation; either version 2,  or (at  your  option)  any --
--  later  version.   GNARL is distributed in the hope that it will be use- --
--  ful, but but WITHOUT ANY WARRANTY; without even the implied warranty of --
--  MERCHANTABILITY  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Gen- --
--  eral Library Public License for more details.  You should have received --
--  a  copy of the GNU Library General Public License along with GNARL; see --
--  file COPYING. If not, write to the Free Software Foundation,  675  Mass --
--  Ave, Cambridge, MA 02139, USA.                                          --
--                                                                          --
------------------------------------------------------------------------------

package System.POSIX_Timers is

   subtype time_t is Integer range 0 .. Integer'Last;

   type Nanoseconds is new Integer;

   subtype Fractional_Second is Nanoseconds range 0 .. 10#1#E9 - 1;
   --  This is dependent on the stdtypes.h header file.

   type timespec is record
      tv_sec : time_t;
      tv_nsec : Fractional_Second;
   end record;

   timespec_First : constant timespec :=
     timespec' (time_t'First, Fractional_Second'First);

   timespec_Last : constant timespec :=
     timespec' (time_t'Last, Fractional_Second'Last);

   timespec_Zero : constant timespec :=
     timespec' (time_t'First, Fractional_Second'First);

   timespec_Unit : constant timespec :=
     timespec' (time_t'First, Fractional_Second'First + 1);
   --  This is dependent on the POSIX.4 implementation; the draft standard
   --  only says that fields of these names and types (with Integer for long)
   --  will be in the record.  There may be other fields, and these do not have
   --  to be in the indicated position.  This should really be done by
   --  getting the sizes and offsets using get_POSIX_Constants and building
   --  the record to match using representation clauses.

   --  temporarily, should really only be for 1
   type clock_id_t is private;

   CLOCK_REALTIME : constant clock_id_t;

   procedure clock_gettime
     (ID     : clock_id_t;
      CT     : out timespec;
      Result : out Integer);
   --  clock_gettime gets POSIX time
   --  (use Return_Code in pthreads)

private

   type clock_id_t is new Integer;
   --  This clock_id_t is defined as an integer in POSIX

   CLOCK_REALTIME : constant clock_id_t := 0;
   --  We currently implement only Realtime clock.

end System.POSIX_Timers;
