------------------------------------------------------------------------------
--                                                                          --
--                         GNAT RUNTIME COMPONENTS                          --
--                                                                          --
--                     A D A . S T R I N G S . M A P S                       --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.7 $                              --
--                                                                          --
--           Copyright (c) 1992,1993,1994 NYU, All Rights Reserved          --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. --
--                                                                          --
------------------------------------------------------------------------------


package Ada.Strings.Maps is
   pragma Pure;

   --------------------------------
   -- Character Set Declarations --
   --------------------------------

   type Character_Set is array (Character range <>) of Boolean;
   pragma Pack (Character_Set);
   --  Representation for a set of character values:

   Null_Set : constant Character_Set ('b' .. 'a') := (others => False);
   --  Note that the null set can have any range, with the element values
   --  being False, but we choose to make it a null range since this is
   --  more efficient. The particular choice of null range is arbitrary.

   subtype Character_Sequence is String;
   --  Alternative representation for a set of character values:

   ----------------------------------
   -- Operations on Character Sets --
   ----------------------------------

   function "="   (Left, Right : Character_Set) return Boolean;

   function "not" (Right : Character_Set)       return Character_Set;
   function "and" (Left, Right : Character_Set) return Character_Set;
   function "or"  (Left, Right : Character_Set) return Character_Set;
   function "xor" (Left, Right : Character_Set) return Character_Set;

   function Is_In
     (Element : Character; Set : Character_Set) return Boolean;

   function Is_Subset
     (Elements : Character_Set; Set : Character_Set) return Boolean;

   function "<="
     (Left  : Character_Set; Right : Character_Set) return Boolean
     renames Is_Subset;

   function To_Set (Sequence : Character_Sequence) return Character_Set;

   function To_Set (Singleton : Character) return Character_Set;

   function To_Sequence (Set : Character_Set) return Character_Sequence;

   ------------------------------------
   -- Character Mapping Declarations --
   ------------------------------------

   type Character_Mapping is array (Character range <>) of Character;
   pragma Pack (Character_Mapping);
   --  Representation for a character to character mapping:

   ----------------------------
   -- Operations on Mappings --
   ----------------------------

   function To_Mapping
     (From, To : Character_Sequence) return Character_Mapping;

   ----------------------
   -- Identity Mapping --
   ----------------------

   Identity : constant Character_Mapping ('1' .. '0') := (others => ' ');
   --  ??? Identity should be a deffered constant. But it blows up the
   --  compiler right now

private
   pragma Inline (Is_In);

   --   Identity : constant Character_Mapping ('1' .. '0') := (others => ' ');
   --  Note that any null range would do. We want to use a null range,
   --  rather than a filled in identity mapping so that the test for
   --  an identity mapping in routines like Count is rapid.

end Ada.Strings.Maps;
