/* first.S  -  LILO first stage boot loader */

/* Written 1992,1993 by Werner Almesberger */


#include <linux/config.h>

#define LILO_ASM
#include "lilo.h"


	.text

	.globl	_main

	.org	0

_main:	jmp	start

	.org	2

! Boot device parameters. They are set by the installer.

	.ascii	"LILO"
	.word	STAGE_FIRST
	.word	VERSION

timeout:.word	0		! input timeout
delay:	.word	0		! boot delay
port:	.byte	0		! COM port (0 = unused, 1 = COM1, etc.)
sparam:	.byte	0		! serial port parameters (0 = unused)

d1_cx:	.word	0		! first descriptor sector address
d1_dx:	.word	0
d1_al:	.byte	0		! (unused)

d2_cx:	.word	0		! second descriptor sector address
d2_dx:	.word	0
d2_al:	.byte	0		! (unused)

dc_cx:	.word	0		! default command-line sector address
dc_dx:	.word	0
dc_al:	.byte	0		! (unused)

grumble:.byte	0		! alignment byte

ms_len:	.word	0		! initial greeting message
ms_cx:	.word	0
ms_dx:	.word	0
ms_al:	.byte	0		! (unused)

d_addr:				! second stage sector addresses

	.org	CODE_START_1

ext_si:	.word	0		! external interface
ext_es:	.word	0
ext_bx:	.word	0
ext_dl:	.byte	0

start:	mov	ax,#BOOTSEG	! set DS
	mov	ds,ax
	mov	ext_es,es	! copy possible external parameters
	mov	ext_si,si
	mov	ext_bx,bx
	mov	ext_dl,dl
	mov	ax,#FIRSTSEG	! beam us up ...
	mov	es,ax
	mov	cx,#256
	sub	si,si
	sub	di,di
	cld
	rep
	movsw
	jmpi	go,FIRSTSEG

go:	cli			! no interrupts
	mov	ds,ax		! AX is already set
	mov	es,ax		! (ES may be wrong when restarting)
	mov	sp,#STACK	! set the stack
	mov	ax,#STACKSEG
	mov	ss,ax
	sti			! now it is safe

	mov	al,#0x0d	! gimme a CR ...
	call	display
	mov	al,#0x0a	! ... an LF ...
	call	display
	mov	al,#0x4c	! ... an 'L' ...
	call	display

lagain:	mov	si,#d_addr	! ready to load the second stage loader
	mov	bx,#SECOND
	cld
sload:	lodsw			! get CX
	mov	cx,ax
	lodsw			! get DX
	mov	dx,ax
	or	ax,cx		! at EOF ?
	jz	done		! yes -> start it
	inc	si		! skip the length byte
	mov	al,#1	 	! load the sector
	call	cread
	jc	error		! error -> start over again
	add	bx,#512		! next sector
	jmp	sload
error:
#ifndef LCF_NO1STDIAG
	mov	al,ah		! display error code
	call	bout
#endif
	xor	ax,ax		! reset the FDC
	mov	dl,al
	int	0x13
	jmp	lagain		! redo from start
done:	mov	al,#0x49	! display an 'I'
	call	display
	jmpi	0,SECONDSEG	! start the second stage loader

#ifndef LCF_NO1STDIAG
bout:	push	ax		! display one byte
	shr	al,#4
	call	nout
	pop	ax
nout:	and	al,#15		! display one nibble
	add	al,#48
	cmp	al,#58
	jb	nokay
	add	al,#7
nokay:				! fall through
#endif

#define FIRST_STAGE
#include "shared.S"

/* Here are at least 64 bytes of free space. This is reserved for the
   partition table. */
