#include <stdio.h>
#include <X11/Intrinsic.h>
#include <Xm/Xm.h>
#include <Xm/MainW.h>
#include <Xm/List.h>
#include <Xm/Form.h>
#include <Xm/PushB.h>
#include <Xm/DrawingA.h>
#include <Xm/Separator.h>
#include <Xm/DialogS.h>
#include <Xm/MessageB.h>
#include <X11/cursorfont.h>
#include "callbacks.h"
#include "draw.h"


/* initialized in main */
static Cursor watch_cursor;

#ifdef _NO_PROTO
void SetWatchCursor(w)
Widget w;
#else /* _NO_PROTO */
void SetWatchCursor(Widget w)
#endif /* _NO_PROTO */
{
    XDefineCursor(XtDisplay(w), XtWindow(w),  watch_cursor);
    XFlush(XtDisplay(w));
};



#ifdef _NO_PROTO
void UnsetWatchCursor(w)
Widget w;
#else /* _NO_PROTO */
void UnsetWatchCursor(Widget w)
#endif /* _NO_PROTO */
{
    XUndefineCursor(XtDisplay(w), XtWindow(w));
};



Widget toplevel;  
Widget mainWindow;
Widget fList;
Widget form;
Widget separator;
Widget quitButton;
Widget draw;
Window drawingWindow;
unsigned char on_root = FALSE;



void Usage()
{
    fprintf(stderr, "Usage: xpmview [-root] [X-options] file1, file2,...\n");
    exit(1);
}


#ifdef _NO_PROTO
void ScanArgs(argc, argv)
unsigned int argc; 
char **argv;
#else /* _NO_PROTO */
void ScanArgs(int argc,char ** argv)
#endif /* _NO_PROTO */
{
    int arg = 1;
    while(arg < argc) {
	/* use <-root> to display pixmaps on the root window */
	if((!strcmp(argv[arg], "-root"))) {
	    arg += 1;
	    on_root = TRUE;
	}
	else {
	    if(argv[arg][0] == '-') {
		fprintf(stderr, "Unknown option (ignored): %s\n", argv[arg]); 
	    };
	    arg += 1;
	};
    }
}



#ifdef _NO_PROTO
main(argc, argv)
unsigned int argc; 
char **argv;
#else
main(unsigned int argc, char **argv)
#endif
{

    XtAppContext app_context;
    Arg args[10];
    register int n;
    int i;
    XmString string;
    
    toplevel=XtAppInitialize(&app_context, "XPmview", NULL, 0, &argc, argv,
			     NULL, NULL, 0);
    if(argc <= 1) Usage();
    ScanArgs(argc, argv);
    
    watch_cursor = XCreateFontCursor(XtDisplay(toplevel), XC_watch);
    /* creating form */
    n=0; 
    form = XtCreateManagedWidget("form", xmFormWidgetClass, toplevel, 
				       args, n);

    /* creating main window */
    n=0; 
    mainWindow = XtCreateManagedWidget("mainWindow", xmMainWindowWidgetClass,
				       form, args, n);


    n=0;
    XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
    XtSetArg(args[n], XmNtopWidget, mainWindow); n++;
    separator = XtCreateManagedWidget("separator", xmSeparatorWidgetClass, 
				      form, args,n);

    n=0;
    quitButton = XtCreateManagedWidget("quitButton", xmPushButtonWidgetClass,
				       form, args,n);
    XtAddCallback(quitButton, XmNactivateCallback, QuitCB, NULL);

    
    /* creating lists */
    n=0;
    XtSetArg(args[n], XmNselectionPolicy, XmSINGLE_SELECT); n++;
    fList = XmCreateScrolledList(mainWindow, "fList", args, n);
    XtAddCallback(fList, XmNsingleSelectionCallback , SingleSelectionCB,NULL);
    
    XtManageChild(fList); 
    


    if (! on_root) {
	/* creating drawing area as another toplevel */
	n = 0;
	XtSetArg(args[n], XmNwidth, 20); n++;
	XtSetArg(args[n], XmNheight, 20); n++;
	
	XtSetArg(args[n], XmNmappedWhenManaged, False); n++;
	
	XtSetArg(args[n], XmNresizable, False); n++;
	draw = XtAppCreateShell("view", "XPmview", 
				applicationShellWidgetClass,
				XtDisplay(toplevel), args, n);
    }
    
    for(i=1; i< argc; i++) {
	XmString string;
	/* discard any -option */
	if(argv[i][0] != '-') {
	    string = XmStringCreateLtoR(argv[i], XmSTRING_DEFAULT_CHARSET);
	    XmListAddItem(fList, string, 0);
	    XmStringFree(string);
	};
    };

    XtRealizeWidget(toplevel);
    if(on_root) {
	drawingWindow = DefaultRootWindow(XtDisplay(toplevel));
    } 
    else {
	XtRealizeWidget(draw);
	drawingWindow = XtWindow(draw);
    }

    XtAppMainLoop(app_context);
    
}
