static char rcsid[]="$Id:";
#include <X11/Intrinsic.h>
#include <X11/extensions/shape.h>
#include <xpm.h>
#include "main.h"
#include "select.h"

ErrorMessage(ErrorStatus, tag)
    int ErrorStatus;
    char *tag;
{
    char *error = NULL;
    char *warning = NULL;

    switch (ErrorStatus) {
    case XpmSuccess:
        return;
    case XpmColorError:
        warning = "Could not parse or alloc requested color";
        break;
    case XpmOpenFailed:
        error = "Cannot open file";
        break;
    case XpmFileInvalid:
        error = "Invalid XPM file";
        break;
    case XpmNoMemory:
        error = "Not enough memory";
        break;
    case XpmColorFailed:
        error = "Failed to parse or alloc some color";
        break;
    }

    if (warning)
        printf("%s Xpm Warning: %s.\n", tag, warning);

    if (error) {
        printf("%s Xpm Error: %s.\n", tag, error);
    }
}


#ifdef _NO_PROTO
void DrawPixmap(dpy, window, pFile)
Display *dpy;
Window window;
char *pFile;
#else /* _NO_PROTO */
void DrawPixmap(Display *dpy, Window window, char *pFile)
#endif /* _NO_PROTO */
{
    static Pixmap pix = 0, mask = 0;
    static XpmAttributes att;
    int ErrorStatus;
    SetSelection(toplevel, pFile);

    /* here, we free the old pixmap if needed */
    if(pix) {
	XUnmapWindow(dpy, window);
	XFreePixmap(dpy, pix);
	XFreeColors(dpy, 
		    DefaultColormap(dpy, 0),
		    att.pixels, att.npixels, 0);
	XpmFreeAttributes(&att);
	pix = 0;
    };
    if (mask) {
	XShapeCombineMask(dpy, window,
			  ShapeBounding, 0, 0, 0, ShapeSet);
	XFreePixmap(dpy, mask);
	mask = 0;
    }

    att.valuemask = XpmReturnPixels;
    SetWatchCursor(toplevel);
    ErrorStatus = XpmReadFileToPixmap(dpy, window,
				      pFile, &pix, &mask, &att);
    if(ErrorStatus == XpmSuccess) {
	if(!on_root) {
	    XResizeWindow(dpy, window, att.width, att.height);
	}
	XSetWindowBackgroundPixmap(dpy, window, pix);
	if (mask)
	    XShapeCombineMask(dpy, window,
			      ShapeBounding, 0, 0, mask, ShapeSet);
    }
    else {
	ErrorMessage(ErrorStatus, "DrawPixmap");
    };
    XClearWindow(dpy, window);
    XRaiseWindow(dpy, window);
    XMapWindow(dpy, window);
    UnsetWatchCursor(toplevel);
};
