/*
 ******************************************************************************
 *
 *	ParcPlace Systems, Inc.
 *	Copyright (c) 1990, ParcPlace Systems, Inc. USA   All rights reserved.
 *
 ****************************************************************************
 *
 *	File:	scrlmnu.H
 *
 *	Functions(s):
 *
 *	Description:
 *		OI_scroll_menu class header
 *
 *	RCSid = "$Id: scrlmnu.H,v 4.28.1.1 1993/06/01 22:56:36 mth Exp $"
 *
 ****************************************************************************
 */

#ifndef OI_scrlmnu_H
#define OI_scrlmnu_H

#ifndef OI_mnu_H
#include <OI/mnu.H>
#endif /* OI_mnu_H */

#ifndef OI_btnmnu_H
#include <OI/btnmnu.H>
#endif /* OI_btnmnu_H */

#ifndef OI_exchkmnu_H
#include <OI/exchkmnu.H>
#endif /* OI_exchkmnu_H */

#ifndef OI_exrctmnu_H
#include <OI/exrctmnu.H>
#endif /* OI_exrctmnu_H */

#ifndef OI_pychkmnu_H
#include <OI/pychkmnu.H>
#endif /* OI_pychkmnu_H */

#ifndef OI_pyrctmnu_H
#include <OI/pyrctmnu.H>
#endif /* OI_pyrctmnu_H */

	// class forward reference declarations
	class	OI_basic_menu;
	class	OI_box;
	class	OI_excl_rect_menu;
	class	OI_panner;
	class	OI_poly_rect_menu;
	class	OI_scroll_bar;
	class	OI_static_text;
	class	OI_mdl_scroll_menu;
	class	OI_scroll_box;

	enum OI_scroll_dir {		/* Don't scroll or scroll to the begining or end */
		OI_scroll_dir_none,
		OI_SCROLL_DIR_NONE	= OI_scroll_dir_none,
		OI_scroll_dir_begin,
		OI_SCROLL_DIR_BEGIN	= OI_scroll_dir_begin,
		OI_scroll_dir_end,
		OI_SCROLL_DIR_END	= OI_scroll_dir_end
	};

#define		OI_SCROLL_MENU_TIMEOUT		400	/* milisec. timer. */

 /* ctl_bits private bits */
#define		OI_SCROLL_MENU_CTLR_VIS		0x1	/* 1 => auto controller visibility on */
#define		OI_SCROLL_MENU_IN_CONSTRUCTOR	0x2	/* 1 => in constructor for this object, not ancestor classes */
#define		OI_SCROLL_MENU_COLLAPSE		0x4	/* 1 => collapse when controllers go invisible */
#define		OI_SCROLL_TIMER_SET		0x8	/* 1 => timer to srcoll the menu is set. */
#define		OI_SCROLL_MENU_IN_CHG_MNU	0x10	/* 1 => in change_menu call */
#define		OI_SCROLL_MENU_NEED_MNU_RESIZE	0x20	/* 1 => need to do menu_resize() when abs_resume_layout */
#define		OI_SCROLL_MENU_IN_MNU_RESIZE	0x40	/* 1 => in menu_resize callback */
#define		OI_SCROLL_MENU_MIN_SIZ		0x80	/* 1 => in use minimum viewport size */
#define		OI_SCROLL_MENU_TRACK_CELLS	0x100	/* 1 => if vertical, track cell width */
#define		OI_SCROLL_MENU_IN_COMPUTE_UNITS	0x200	/* 1 => in compute_units */

	class OI_scroll_menu : public OI_menu {	/* scrollable menu in a box */
			OI_mdl_scroll_menu	*mdl_dep ;		/* ptr to model dependent object */
			unsigned long		ctl_bits ;		/* object specific control bits */
			OI_scroll_box		*sb;			/* pointer to underlying scroll box */
			OI_basic_menu		*mnu ;			/* ptr to underlying menu object */
			OI_static_text		*scrl_ttl ;		/* ptr to scroll menu title object */
	 public:
		static	OI_class		*clsp ;			/* ptr to class record */
	 private:
		virtual	OI_menu_cell		*abbr_cell() ;
		virtual	void			cell_paint(OI_menu_cell*) ;
		virtual	OI_menu_cell		*cell_to_fire(OI_menu_cell*,OI_bool=OI_NO) ;
			void			clear_in_change_menu()	{ ctl_bits &= ~OI_SCROLL_MENU_IN_CHG_MNU;}
			void			clear_in_menu_resize()	{ ctl_bits &= ~OI_SCROLL_MENU_IN_MNU_RESIZE;}
			void			clear_in_compute_units()	{ ctl_bits &= ~OI_SCROLL_MENU_IN_COMPUTE_UNITS;}
			void			clear_in_my_constructor()	{ctl_bits&= ~OI_SCROLL_MENU_IN_CONSTRUCTOR;}
			void			clear_need_menu_resize()	{ctl_bits&= ~OI_SCROLL_MENU_NEED_MNU_RESIZE;}
			void			clear_use_min_size()	{ ctl_bits &= ~OI_SCROLL_MENU_MIN_SIZ; }
			void			compute_units(OI_menu*) ;
			void			construct(OI_number, OI_number, OI_class*, OI_number, OI_menu_cell**, OI_orient,
							const char*) ;
			void			construct(OI_number, OI_number, OI_class*, OI_number, OI_cell_spec*, OI_orient,
							const char*) ;
			OI_bool			in_change_menu()	{ return((ctl_bits&OI_SCROLL_MENU_IN_CHG_MNU) ? OI_YES : OI_NO);}
			OI_bool			in_compute_units()	{ return((ctl_bits&OI_SCROLL_MENU_IN_COMPUTE_UNITS) ? OI_YES : OI_NO);}
			OI_bool			in_menu_resize()	{ return((ctl_bits&OI_SCROLL_MENU_IN_MNU_RESIZE) ? OI_YES : OI_NO);}
			OI_bool			in_my_constructor()	{return((ctl_bits&OI_SCROLL_MENU_IN_CONSTRUCTOR) ? OI_YES : OI_NO);}
		virtual	OI_number		inter_cell_x() ;
		virtual	OI_number		inter_cell_y() ;
			OI_bool			need_menu_resize()	{ return((ctl_bits&OI_SCROLL_MENU_NEED_MNU_RESIZE) ? OI_YES : OI_NO);}
			void			new_menu_type(OI_class *) ;			/* change the menu to this menu type */
		virtual	OI_number		num_abbr_cell() ;
		virtual	OI_stat			num_set_abbr_cell(OI_number) ;
		virtual	OI_stat			set_abbr_cell(const char *nmp) ;
			void			set_in_change_menu()	{ ctl_bits |= OI_SCROLL_MENU_IN_CHG_MNU;}
			void			set_in_menu_resize()	{ ctl_bits |= OI_SCROLL_MENU_IN_MNU_RESIZE; }
			void			set_in_compute_units()	{ ctl_bits |= OI_SCROLL_MENU_IN_COMPUTE_UNITS; }
			void			set_in_my_constructor()	{ ctl_bits |= OI_SCROLL_MENU_IN_CONSTRUCTOR;}
			void			set_need_menu_resize()	{ ctl_bits |= OI_SCROLL_MENU_NEED_MNU_RESIZE;}
			void			set_use_min_size()	{ ctl_bits |= OI_SCROLL_MENU_MIN_SIZ; }
			OI_bool			use_min_size()		{ return((ctl_bits&OI_SCROLL_MENU_MIN_SIZ) ? OI_YES : OI_NO); }
		friend	void			dmpOI_scroll_menu(OI_scroll_menu*) ;
	 protected:
						OI_scroll_menu(OI_class *clsp, const char *usr_namp, OI_number ctl, OI_number vw,
							OI_class *mt, OI_number nc, OI_menu_cell **cpp, OI_orient or,
							const char *title=NULL) ;
						OI_scroll_menu(OI_class *clsp, const char *usr_namp, OI_number ctl, OI_number vw,
							OI_class *mt, OI_number nc, OI_cell_spec *cspp, OI_orient or,
							const char *title=NULL) ;
		virtual	OI_d_tech		*callback_object(XrmQuark) ;
		virtual	OI_stat			create() ;					/* create in X environment */
			void			key_srch(const XEvent*) ;			/* search for entry matching key */
		virtual	void			init_selections() ;
			OI_d_tech		*interior_obj(const char *namp) ;
		virtual	void			new_model(OI_model_type) ;
	 public:
		//-------------------------------------------------------------------------------------------------		
		//		
		//	RESTRICTED MEMBER FUNCTIONS
		//		Functions in this section are not documented in the programmer's manual and are
		//		restricted to internal use by the toolkit.
		//		Functions not contained in user documentation are subject to change without notice
		//		and should never be used by toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
						OI_scroll_menu(const char*,OI_number,OI_number,OI_class*,OI_number,OI_menu_cell**,OI_orient,
							const char* =NULL) ;
						OI_scroll_menu(const char*,OI_number,OI_number,OI_class*,OI_number,OI_cell_spec*,OI_orient,
							const char* =NULL) ;
						~OI_scroll_menu() ;
		virtual	void			abs_resume_layout(OI_bool=OI_YES) ;
  		virtual	void			activate(OI_d_tech *, const XEvent *ep, const char* const *, unsigned int *);
		virtual	void			allow_abs_associate();
		virtual	OI_d_tech		*associate_parent(OI_d_tech* =NULL) ;
			void			change_controllers(OI_number) ;			/* change which controllers are present */
			OI_number		controllers();
  		virtual	void			deactivate(OI_d_tech *, const XEvent *ep, const char* const *, unsigned int *);
		virtual	void			disallow_abs_associate();
		virtual	OI_menu_cell		*find_cell(int,int) ;				/* find cell at (x,y) */
			void			fire_cell(OI_menu_cell *);
		virtual	OI_d_tech		*focus_obj() ;					/* get ptr to actual obj to receive focus */
			void			font_resize() ;					/* resize object for font change */
		static	OI_bool			init(OI_connection*) ;
		virtual	OI_bool			is_scroll_menu();
		virtual	OI_bool			has_submenu();
			OI_bool			is_write_resq(XrmQuark);
		virtual	void			make_cell_visible(OI_menu_cell *);
		static	OI_scroll_menu		*make_minimal(const char*,OI_minimal_type) ;
		virtual	OI_number		max_basic_size_x();
		virtual	OI_number		max_basic_size_y();
			void			menu_end(OI_menu *, OI_menu_cell *, void *, OI_number);
			void			menu_resize(OI_d_tech*,void*) ;			/* resize because of change in underlying menu */
 		virtual	void			menu_key(OI_d_tech *, const XEvent *ep, const char* const *, unsigned int *);
		const	char			*menu_type() ;
		virtual	OI_menu_cell		*next_selection(OI_menu_cell *cp) ;
		virtual	void			new_title(const char *title, OI_char_encode_type);
		virtual	void			new_wrap_limit(OI_number);
		virtual	void			nominal_outside_size(OI_number*,OI_number*);
			OI_number		orient_view_size() ;				/* returns the view size for the current orientation */
		virtual	void			paint(const XEvent *, void* =NULL);
			void			pan_paint(OI_panner*,void*,XExposeEvent*) ;	/* paint miniature of object for panner */
			OI_panner		*panner() ;
		virtual	void			popup();
		virtual	OI_string		*ply_title() ;					/* get title */
			void			res_auto_controller_visibility(void *);		// OBSOLETE
			OI_bool			res_collapse(void *);				// OBSOLETE
			void			res_controllers(void *);			/* resource setting callback */
			OI_bool			res_controller_visibility(void *);
			void			res_view_size(void *);				/* resource setting callback */
			void			res_menu_type(void *);				/* resource setting callback */
			void			res_scroll_menu_timeout(void *);		/* resource setting callback */
			void			res_track_cells(void *);
/*KNOWN*/		void			scroll(OI_ctlr_1d*,void*,OI_scroll_event,long) ;	/* scroll object in 1 dimension */
			void			scroll_2d(OI_panner*,void*,OI_scroll_event,long,long) ;	/* scroll object in 2 dimensions */
			OI_scroll_box		*scroll_box()			{ return( sb ); }
			void			scroll_box_resize(OI_d_tech*,void*);
			OI_bool			scroll_timer()			{return((ctl_bits&OI_SCROLL_TIMER_SET) ? OI_YES : OI_NO);}
			OI_number		scroll_menu_timeout();
			void			set_scroll_menu_timeout(OI_number);
			OI_stat			set_menu_type(const char *) ;			/* change the menu to this menu type */
			void			set_scroll_timer()		{ctl_bits |= OI_SCROLL_TIMER_SET;}
			void			stick();
			void			clear_scroll_timer()		{ctl_bits &= ~OI_SCROLL_TIMER_SET;}
		virtual	OI_stat			select_cell(OI_bool, OI_menu_cell*, OI_bool=OI_NO, OI_bool=OI_YES) ;
		virtual	OI_menu_cell		*start_current_cell();
		virtual	OI_tabstops		*tabstops();
			OI_static_text		*title_obj() ;
		virtual	void			unpopup();


		//-------------------------------------------------------------------------------------------------		
		//		
		//	OBSOLETE MEMBER FUNCTIONS	
		//		Functions in this section were previously documented, but have been marked as
		//		obsolete.  These functions have been removed from the programmer's manual.
		//		These functions are subject to removal from the toolkit and should NEVER be
		//		used by toolkit users.
		//
		//-------------------------------------------------------------------------------------------------		
			void			allow_auto_controller_visibility(OI_bool=OI_YES) ;	// use set_controller_visibility
			void			allow_collapse() ;				// use set_controller_visibility()
			OI_stat			change_menu_spec(OI_number,OI_cell_spec*,const char* =NULL) ;	// change underlying menu
			void			disallow_auto_controller_visibility() ;		// use set_controller_visibility
			void			disallow_collapse() ;				// use set_controller_visibility()
			OI_bool			is_auto_controller_visibility() ;		// use controller_visibility
			OI_bool			is_collapse() ;					// use controller_visibility()

		//-------------------------------------------------------------------------------------------------		
		//		
		//	OVERRIDES OF DOCUMENTED PARENT MEMBER FUNCTIONS	
		//		Functions in this section are documented in the programmer's manual under the
		//		parent(s) of this object and are also available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
		virtual	void			add_cell(OI_menu_cell *, OI_number, OI_bool=OI_YES) ;
		virtual	void			allow_cell_outline() ;
		virtual	void			allow_resel() ;
		virtual	void			allow_unsel() ;
		virtual	char			*alpha_value() ;
		virtual	OI_number		cell_number(const char *nmp) ;
		virtual	void			clone_adjust(OI_d_tech*) ;
		virtual	OI_menu_cell		*default_cell() ;
		virtual	void			disallow_cell_outline() ;
		virtual	void			disallow_resel() ;
		virtual	void			disallow_unsel() ;
			void			disallow_track_cells()	{ ctl_bits &= ~OI_SCROLL_MENU_TRACK_CELLS; }
		virtual	OI_bool			is_cell_outline() ;
			OI_bool			is_track_cells()	{ return ((ctl_bits&OI_SCROLL_MENU_TRACK_CELLS)?OI_YES:OI_NO); }
		virtual	OI_bool			is_resel() ;
		virtual	OI_bool			is_unsel() ;
		virtual	OI_menu_cell		**multi_default_cell() ;
		virtual	OI_menu_cell		**multi_selected(OI_number *np=NULL) ;
		virtual	OI_d_tech		*next_child(OI_d_tech*);			/* get child from property list */
		virtual	OI_number		num_cells() ;
		virtual	OI_number		num_default_cell() ;
		virtual	OI_number		*num_multi_default_cell(OI_number *np) ;
		virtual	OI_number		*num_multi_selected(OI_number *np) ;
		virtual	OI_number		num_props();
		virtual	OI_stat			num_select(OI_bool, OI_number, OI_bool=OI_YES) ;
		virtual	OI_number		num_selected() ;
		virtual	OI_stat			num_set_default_cell(OI_number) ;
		virtual	OI_menu_cell		*numbered_cell(OI_number n) ;
		virtual	OI_d_tech		*numbered_child(OI_number n);
		virtual	OI_orient		orientation() ;
		virtual	void			resume_layout(OI_bool=OI_YES);
		virtual	OI_stat			select(OI_bool,const char *nmp, OI_bool=OI_YES) ;	
		virtual	OI_menu_cell		*selected() ;
		virtual	OI_stat			set_default_cell(const char *nmp) ;
			void			set_tab_width(OI_number) ;
			void			set_tabs_custom(OI_number *, OI_number, OI_number =8) ;
												/* change tabs */
		virtual	OI_d_tech		*subobject(const char*) ;			/* find child */
		virtual	OI_d_tech		*subobject(XrmQuark) ;				/* find child */
		virtual	void			suspend_layout() ;
		virtual	char			*title() ;					/* get title */
		virtual	Window			X_window() ;					/* get object's X_window id */


		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED MEMBER FUNCTIONS	
		//		Functions below this point are documented in the programmer's manual under this
		//		object and are available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
			void			allow_track_cells()	{ ctl_bits |= OI_SCROLL_MENU_TRACK_CELLS; }
			OI_scroll_bar		*bottom_scroll_bar() ;
			OI_stat			change_menu(OI_number,OI_menu_cell**,const char* =NULL) ;	/* change underlying menu */
			OI_stat			change_menu(OI_number,OI_cell_spec*,const char* =NULL) ;	/* change underlying menu */
			void			handle_loc(long*,long*) ;
			long			handle_loc_x() ;
			long			handle_loc_y() ;
			OI_scroll_bar		*horz_scroll_bar() ;
			OI_scroll_bar		*left_scroll_bar() ;
			OI_basic_menu		*menu() ;					/* ptr to underlying menu */
			OI_scroll_bar		*right_scroll_bar() ;
			OI_stat			set_handle_loc(long,long) ;			/* position horizontally and vertically */
			OI_stat			set_handle_loc_x(long) ;			/* position horizontally */
			OI_stat			set_handle_loc_y(long) ;			/* position vertically */
			void			set_controller_visibility(OI_controller_visibility) ;	// set controller_visibility mode
			OI_stat			set_units_minor(OI_number) ;			/* change the units in the minor direction */
			OI_stat			set_view_size(OI_number) ;			/* change size of viewport */
			OI_stat			set_view_size_minor(OI_number) ;		/* change size of viewport in the minor direction */
			OI_controller_visibility	controller_visibility() ;		// controller visibility mode
			OI_scroll_bar		*top_scroll_bar() ;
			OI_scroll_bar		*vert_scroll_bar() ;
			void			view_size(OI_number *x, OI_number *y) ;
			OI_number		view_size_x() ;
			OI_number		view_size_y() ;
	} ;

//-------------------------------------------------------------------------------------------------		
//		
//	RESTRICTED FUNCTIONS
//		Functions in this section are not documented in the programmer's manual and are
//		restricted to internal use by the toolkit.
//		Functions not contained in user documentation are subject to change without notice
//		and should never be used by toolkit users.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		
	OI_excl_rect_menu	*oi_scrl_excl_rect_menu(const char*,OI_number,OI_menu_cell**,OI_orient,const char* =NULL) ;
	OI_poly_rect_menu	*oi_scrl_poly_rect_menu(const char*,OI_number,OI_menu_cell**,OI_orient,const char* =NULL) ;

//-------------------------------------------------------------------------------------------------		
//		
//	OBSOLETED FUNCTIONS	
//		Functions below this point were once documented in the programmer's manual under
//		this object, but are now obsolete and will be removed in a future release.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		
	OI_scroll_menu	*oi_scroll_menu(const char*, OI_number, OI_number, OI_class*, OI_number, OI_menu_cell**, OI_orient=OI_vertical,
				const char* =NULL) ;

//-------------------------------------------------------------------------------------------------		
//		
//	DOCUMENTED FUNCTIONS	
//		Functions below this point are documented in the programmer's manual under this
//		object and are available to the toolkit users.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		
	OI_scroll_menu	*oi_create_scroll_menu(const char*,OI_number,OI_number,OI_class*,OI_number,OI_cell_spec*,OI_orient=OI_vertical,
				const char* =NULL);
	OI_scroll_menu	*oi_create_scroll_menu(const char*,OI_number,OI_number,OI_class*,OI_number,OI_menu_cell**,OI_orient=OI_vertical,
				const char* =NULL);
	OI_scroll_menu	*oi_create_scroll_menu(const char*,OI_number,OI_number,const char*,OI_number,OI_cell_spec*,OI_orient=OI_vertical,
				const char* =NULL);
	OI_scroll_menu	*oi_create_scroll_menu(const char*,OI_number,OI_number,const char*,OI_number,OI_menu_cell**,OI_orient=OI_vertical,
				const char* =NULL);

#endif /* OI_scrlmnu_H */
