/*
 ******************************************************************************
 *
 *	ParcPlace Systems, Inc.
 *	Copyright (c) 1990, ParcPlace Systems, Inc. USA   All rights reserved.
 *
 ****************************************************************************
 *
 *	File:	cache.H
 *
 *	Functions(s):
 *
 *	Description:
 *		server cache for shared Pixmaps to reduce total resource consumption
 *
 *	RCSid = "$Id: cache.H,v 4.1.1.1 1993/06/01 22:53:04 mth Exp $"
 *
 ****************************************************************************
 */

#ifndef OI_cache_H
#define OI_cache_H

 /* bits in create_bits */
#define		OI_CACHE_APP_WINDOW	0x4
#define		OI_CACHE_OL_BUTTON_MENU	0x4
#define		OI_CACHE_OL_EXCL_CHECK	0x4
#define		OI_CACHE_OL_POLY_CHECK	0x8

	struct OI_GBL_ATTR {
		unsigned long		create_bits ;	/* bit on => Pixmaps for item have been generated */
		struct {
			Pixmap		pm_pp_in ;	/* pushpin in */
			Pixmap		pm_pp_out ;	/* pushpin out */
			Pixmap		pm_pp_def_out ;	/* pushpin as default, out */
			Pixmap		gray ;		/* gray pixmap for monochrome 3D bevels */
		} openlook ;
		struct {
			Pixmap		pm_btn ;	/* button glyph */
			Pixmap		pm_btn_bsy ;	/* button busy glyph */
		} abbr_menu ;
		struct {
			Pixmap		icon_pm ;	/* pixmap for default icon */
		} app_window ;
		struct {
			Pixmap		pull_rt_msk ;	/* Bitmap for pull-right, top-bevel */
			Pixmap		pull_rc_msk ;	/* Bitmap for pull-right, center */
			Pixmap		pull_rb_msk ;	/* Bitmap for pull-right, bottom bevel */
			Pixmap		pull_dl_msk ;	/* Bitmap for pull-down, left-bevel */
			Pixmap		pull_dc_msk ;	/* Bitmap for pull-down, center */
			Pixmap		pull_dr_msk ;	/* Bitmap for pull-down, right bevel */
		} m_button_menu ;
		struct {
			Pixmap		tp_lf_msk ;	/* Bitmap for top left corner */
			Pixmap		tp_rt_msk ;	/* Bitmap for top right corner */
			Pixmap		bt_lf_msk ;	/* Bitmap for bottom left corner */
			Pixmap		bt_rt_msk ;	/* Bitmap for bottom right corner */
			Pixmap		tp_lf_def_msk ;	/* Bitmap for top left corner w/default ring */
			Pixmap		tp_rt_def_msk ;	/* Bitmap for top right corner w/default ring */
			Pixmap		bt_lf_def_msk ;	/* Bitmap for bottom left corner w/default ring */
			Pixmap		bt_rt_def_msk ;	/* Bitmap for bottom right corner w/default ring */
		} ol_button_menu ;
		struct {
			Pixmap		lf_msk ;
			Pixmap		rt_msk ;
			Pixmap		act_caret_msk ;
			Pixmap		inact_caret_msk ;
		} entry_field ;
		struct {
			Pixmap		on_msk ;	/* Bitmap for selected cell */
			Pixmap		off_msk ;	/* Bitmap for deselected cell */
			Pixmap		def_msk ;	/* Bitmap for default cell (deselected) */
		} ol_excl_check_menu ;
		struct {
			PIXEL		bar_act_pxl ;	/* pixel for active portion of gauge bar */
		} gauge ;
		struct {
			Pixmap		mag_glass_msk ;	/* magnifying glass */
			Pixmap		mag_clip_msk ;	/* clip mask for interior part of magnifying glass */
		} ol_help ;
		struct {
			Pixmap		shadow_pm ;
			Pixmap		pm_dn ;
			Pixmap		pm_rt ;
			Pixmap		pm_subbox ;
			Pixmap		on_pm ;
			Pixmap		off_pm ;
			Pixmap		pm_busy ;	/* busy cell mask */
			OI_number	drag_pix ;	/* # pixels to drag right to bring up submenu */
		} ol_menu ;
		struct {
			Pixmap		act_caret_msk ;
			Pixmap		inact_caret_msk ;
		} multi_text ;
		struct {
			Pixmap		on_msk ;	/* Bitmap for selected cell */
			Pixmap		off_msk ;	/* Bitmap for deselected cell */
			Pixmap		def_msk ;	/* Bitmap for default cell (deselected) */
		} ol_poly_check_menu ;
		struct {
			Cursor		csr ;		/* cursor when panner active */
			GC		vw_gc ;		/* graphics context for drawing panner viewport border */
		} panner ;
		struct {
			Cursor		hz_csr ;	/* horizontal scroll_bar cursor */
			Cursor		vt_csr ;	/* vertical scroll_bar cursor */
			Pixmap		uc_msk ;	/* mask for up arrow (center portion) */
			Pixmap		ul_msk ;	/* mask for up arrow (left bevel) */
			Pixmap		ur_msk ;	/* mask for up arrow (right bevel) */
			Pixmap		dc_msk ;	/* mask for down arrow (center portion) */
			Pixmap		dl_msk ;	/* mask for down arrow (left bevel) */
			Pixmap		dr_msk ;	/* mask for down arrow (right bevel) */
			Pixmap		lc_msk ;	/* mask for left arrow (center portion) */
			Pixmap		lt_msk ;	/* mask for left arrow (top bevel) */
			Pixmap		lb_msk ;	/* mask for left arrow (bottom bevel) */
			Pixmap		rc_msk ;	/* mask for right arrow (center portion) */
			Pixmap		rt_msk ;	/* mask for right arrow (top bevel) */
			Pixmap		rb_msk ;	/* mask for right arrow (bottom bevel) */
		} m_scroll_bar ;
		struct {
			Cursor		hz_csr ;	/* horizontal scroll_bar cursor */
			Cursor		vt_csr ;	/* vertical scroll_bar cursor */
			Pixmap		cbl_pm ;	/* cable pixmap for region not covered by viewport */
			Pixmap		up_msk ;	/* mask for up arrow */
			Pixmap		dn_msk ;	/* mask for down arrow */
			Pixmap		vt_grb_msk ;	/* mask for middle (grabbable portion) of vertical scrollbar */
			Pixmap		lf_msk ;	/* mask for left arrow */
			Pixmap		rt_msk ;	/* mask for right arrow */
			Pixmap		hz_grb_msk ;	/* mask for middle (grabbable portion) of vertical scrollbar */
		} ol_scroll_bar ;
		struct {
			Pixmap		inc_msk ;	/* mask for increment button */
			Pixmap		dec_msk ;	/* mask for decrement button */
		} seq_entry_field ;
		struct {
			PIXEL		bar_act_pxl ;	/* pixel for active portion of slider bar */
		} slider ;
		struct {
			Cursor		hz_csr ;	/* horizontal scroll_bar cursor */
			Cursor		vt_csr ;	/* vertical scroll_bar cursor */
			Pixmap		vt_hdl_msk ;	/* mask for handle in vertical slider */
			Pixmap		hz_hdl_msk ;	/* mask for handle in horizontal slider */
			Pixmap		lf_end_msk ;	/* mask for left end of bar */
			Pixmap		rt_end_msk ;	/* mask for right end of bar */
			Pixmap		tp_end_msk ;	/* mask for top end of bar */
			Pixmap		bt_end_msk ;	/* mask for bottom end of bar */
		} ol_slider ;
	} ;

#endif /* OI_cache_H */
