/*
 ****************************************************************************
 *
 *	ParcPlace Systems, Inc.
 *	Copyright (c) 1990, ParcPlace Systems, Inc.  USA
 *	All rights reserved.
 *
 ****************************************************************************
 *
 *	File:
 *		abrmnu.H
 *
 *	Notes:
 *		Abbreviated menu
 *
 *	RCSid = "$Id: abrmnu.H,v 4.11.1.1 1993/06/01 22:52:42 mth Exp $"
 *
 ****************************************************************************
 */


#ifndef OI_abrmnu_H
#define OI_abrmnu_H

#ifndef OI_mnu_H
#include <OI/mnu.H>
#endif /* OI_mnu_H */

		class	OI_class ;
		class	OI_connection ;
		class	OI_mdl_abbr_menu ;

#define					OI_ABBR_MENU_CELL_SP_X	4

 /* object specific control bits */
#define	OI_ABBR_MENU_TTL_PAINTED		0x2L		/* title has been painted */
#define	OI_ABBR_MENU_BTN_PAINTED		0x4L		/* glyph has been painted */
#define	OI_ABBR_MENU_CELL_PAINTED		0x8L		/* cell has been painted */
#define	OI_ABBR_MENU_IN_CONSTRUCTOR		0x10L		/* cell has been painted */
#define	OI_ABBR_MENU_CELL_PAINT_AS_CELL		0x20L		/* paint cell with submenu cell's colors. */

class OI_abbr_menu : public OI_menu {
		class	OI_mdl_abbr_menu	*mdl_dep ;							/* ptr to model dependent aspects of object */
			unsigned long		ctl_bits ;							/* object specific control bits */
			OI_number		vis_cell ;							/* number of default (displayed) cell */
			OI_number		vp_siz;								/* size of the viewport */
		public:
		static	OI_class		*clsp ;								/* ptr to class record */

		private:

			void			allow_cell_paint_as_cell()	{ctl_bits|= OI_ABBR_MENU_CELL_PAINT_AS_CELL;}
			void			clear_in_my_constructor()	{ctl_bits&= ~OI_ABBR_MENU_IN_CONSTRUCTOR;}
			void			construct(OI_class*, OI_number, OI_menu_cell**, OI_orient, OI_number) ;
			void			construct(OI_class*, OI_number, OI_cell_spec*, OI_orient, OI_number) ;
			OI_stat			create() ;
			void			disallow_cell_paint_as_cell()	{ctl_bits&= ~OI_ABBR_MENU_CELL_PAINT_AS_CELL;}
			OI_bool			in_my_constructor()	{return((ctl_bits&OI_ABBR_MENU_IN_CONSTRUCTOR) ? OI_YES : OI_NO);}
			void			new_menu_type(OI_class*) ;
			void			set_in_my_constructor()	{ctl_bits|=OI_ABBR_MENU_IN_CONSTRUCTOR;}
		virtual	OI_d_tech		*val_assoc(OI_d_tech*) ;

		protected:
						OI_abbr_menu(OI_class*, const char*, OI_class*, OI_number, OI_menu_cell**, OI_orient=OI_VERTICAL,
								const char* =NULL, OI_number=0) ;
						OI_abbr_menu(OI_class*, const char*, OI_class*, OI_number, OI_cell_spec*, OI_orient=OI_VERTICAL,
								const char* =NULL, OI_number=0) ;
		virtual	void			init_selections() ;				/* initialize preselected cells */
		virtual	void			new_model(OI_model_type) ;
		virtual	OI_stat			select_cell(OI_bool, OI_menu_cell*, OI_bool=OI_NO, OI_bool=OI_YES) ;
		public:

		//-------------------------------------------------------------------------------------------------		
		//		
		//	RESTRICTED MEMBER FUNCTIONS
		//		Functions in this section are not documented in the programmer's manual and are
		//		restricted to internal use by the toolkit.
		//		Functions not contained in user documentation are subject to change without notice
		//		and should never be used by toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		

						OI_abbr_menu(const char*, OI_class*,OI_number,OI_menu_cell**,OI_orient=OI_VERTICAL,
								const char* =NULL, OI_number=0) ;
						OI_abbr_menu(const char*, OI_class*,OI_number,OI_cell_spec*,OI_orient=OI_VERTICAL,
								const char* =NULL, OI_number=0) ;
						~OI_abbr_menu() ;
		virtual	OI_menu_cell		*abbr_cell() ;
		virtual	OI_number		alignment_loc_x(OI_alignment = OI_alignment_default);
		virtual	OI_number		alignment_loc_y(OI_alignment = OI_alignment_default);
		virtual	void			cell_paint(OI_menu_cell*) ;
			OI_bool			cell_paint_as_cell()		{return((ctl_bits&OI_ABBR_MENU_CELL_PAINT_AS_CELL) ? OI_YES : OI_NO);}
//		virtual	void			cell_resized(OI_menu_cell*, void *) ;
		virtual	OI_menu_cell		*cell_to_fire(OI_menu_cell*,OI_bool=OI_NO) ;
		virtual	void			do_resize() ;
		virtual	OI_menu_cell		*find_cell(int,int) ;				/* find cell at (x,y) */
			void			fire_cell(OI_menu_cell *);
		virtual	void			font_resize();
		virtual	OI_bool			has_submenu();
		static	OI_bool			init(class OI_connection*) ;
		virtual	OI_number		inter_cell_x() ;
		virtual	OI_number		inter_cell_y() ;
		virtual	OI_bool			is_write_resq(XrmQuark);
		static	OI_abbr_menu		*make_minimal(const char *usr_namp, OI_minimal_type) ;
			OI_menu			*menu();
			void			menu_end(OI_menu *, OI_menu_cell *, void *, OI_number);
		const	char			*menu_type() ;						/* underlying menu type */
		virtual	void			new_layout(OI_layout l, OI_number v= -1, OI_number h= -1) ;
		virtual	void			new_title(const char *title, OI_char_encode_type);
			void			new_view_size(OI_number);
		virtual	void			new_wrap_limit(OI_number);
		virtual	OI_number		num_abbr_cell() ;
		virtual	OI_number		*num_multi_default_cell(OI_number *n) ;
		virtual	OI_stat			num_set_abbr_cell(OI_number) ;
			void			pre_popup(OI_d_tech *, void *);
			void			paint_cell();
			void			res_menu_type(void *);					/* resource setting callback */
			void			res_cell_paint_as_cell(void *);				/* callback for how cell should be painted */
			void			res_view_size(void *);					/* resource setting callback */
		virtual	OI_stat			set_abbr_cell(const char *cell_name) ;
			OI_stat			set_menu_type(const char *) ;			/* change the underlying menu to this menu type */
			void			set_visible_cell(OI_number cn)	{vis_cell = cn;}
		virtual	OI_menu_cell		*start_current_cell();
		virtual	OI_tabstops		*tabstops();
 		virtual	void			deactivate(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
 		virtual	void			deactivate_all(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
 		virtual	void			focus_in(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
 		virtual	void			focus_out(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
 		virtual	OI_number		super_caret_loc();
			OI_number		visible_cell()			{return(vis_cell);}
		// Translation functions;


		//-------------------------------------------------------------------------------------------------		
		//		
		//	OVERRIDES OF DOCUMENTED PARENT MEMBER FUNCTIONS	
		//		Functions in this section are documented in the programmer's manual under the
		//		parent(s) of this object and are also available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
		virtual	void			add_cell(OI_menu_cell *cp, OI_number n, OI_bool=OI_YES) ;
		virtual	void			allow_cell_outline() ;
		virtual	void			allow_persistent() ;
		virtual	void			allow_pushpin() ;
		virtual	void			allow_resel() ;
		virtual	void			allow_unsel() ;
		virtual	char			*alpha_value() ;
		virtual	void			disallow_pushpin() ;
		virtual	void			disallow_persistent() ;
		virtual	void			disallow_resel() ;
		virtual	void			disallow_unsel() ;
		virtual	OI_number		cell_number(const char *cell_name) ;
		virtual	void			clone_adjust(OI_d_tech*) ;
		virtual	OI_menu_cell		*default_cell() ;
		virtual	void			disallow_cell_outline() ;
		virtual	OI_bool			is_cell_outline() ;
		virtual	OI_bool			is_persistent() ;
		virtual	OI_bool			is_pushpin() ;
		virtual	OI_bool			is_resel() ;
		virtual	OI_bool			is_unsel() ;
		virtual	OI_layout		layout() ;
		virtual	OI_menu_cell		**multi_default_cell() ;
		virtual	OI_menu_cell		**multi_selected(OI_number *n=NULL) ;
		virtual	OI_d_tech		*next_child(OI_d_tech*);			/* get child from property list */
		virtual	OI_menu_cell		*next_selection(OI_menu_cell *cp) ;
		virtual	OI_number		num_cells() ;
		virtual	OI_number		num_default_cell() ;
		virtual	OI_number		*num_multi_selected(OI_number *n) ;
		virtual	OI_stat			num_select(OI_bool onoff, OI_number n, OI_bool=OI_YES) ;
		virtual	OI_number		num_selected() ;
		virtual	OI_stat			num_set_default_cell(OI_number) ;
		virtual	OI_number		num_props() ;
		virtual	OI_d_tech		*numbered_child(OI_number n) ;
		virtual	OI_menu_cell		*numbered_cell(OI_number i) ;
		virtual	OI_orient		orientation() ;
		virtual	void			resume_layout(OI_bool=OI_YES);
		virtual	OI_stat			select(OI_bool, const char *cell_name, OI_bool=OI_YES) ;
		virtual	OI_menu_cell		*selected() ;
		virtual	OI_stat			set_default_cell(const char *cell_name) ;
		virtual	OI_stat			set_state(OI_state) ;
		virtual	void			set_tab_width(OI_number) ;
		virtual	void			set_tabs_custom(OI_number *, OI_number, OI_number =8) ;
		virtual	OI_d_tech		*subobject(const char *obj_name) ;
		virtual	OI_d_tech		*subobject(XrmQuark) ;
		virtual	void			suspend_layout();

		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED MEMBER FUNCTIONS	
		//		Functions below this point are documented in the programmer's manual under this
		//		object and are available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
			void			set_view_size(OI_number) ;			/* change size of viewport */
			OI_number		view_size()		{ return (vp_siz); }	/* return size of viewport */
};
//-------------------------------------------------------------------------------------------------		
//		
//	RESTRICTED FUNCTIONS
//		Functions in this section are not documented in the programmer's manual and are
//		restricted to internal use by the toolkit.
//		Functions not contained in user documentation are subject to change without notice
//		and should never be used by toolkit users.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		

//-------------------------------------------------------------------------------------------------		
//		
//	OBSOLETED FUNCTIONS	
//		Functions below this point were once documented in the programmer's manual under
//		this object, but are now obsolete and will be removed in a future release.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		
		OI_abbr_menu	*oi_abbr_menu(const char*, OI_class*, OI_number, OI_menu_cell**, OI_orient=OI_VERTICAL, const char* =NULL, OI_number=0) ;

//-------------------------------------------------------------------------------------------------		
//		
//	DOCUMENTED FUNCTIONS	
//		Functions below this point are documented in the programmer's manual under this
//		object and are available to the toolkit users.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		
	OI_abbr_menu	*oi_create_abbr_menu(const char*,OI_class*,OI_number=0,OI_cell_spec* =NULL,OI_orient=OI_VERTICAL,const char* =NULL, OI_number=0) ;
	OI_abbr_menu	*oi_create_abbr_menu(const char*,OI_class*,OI_number,OI_menu_cell**,OI_orient=OI_VERTICAL,const char* =NULL, OI_number=0) ;
	OI_abbr_menu	*oi_create_abbr_menu(const char*,const char*,OI_number=0,OI_cell_spec* =NULL,OI_orient=OI_VERTICAL,const char* =NULL, OI_number=0) ;
	OI_abbr_menu	*oi_create_abbr_menu(const char*,const char*,OI_number,OI_menu_cell**,OI_orient=OI_VERTICAL,const char* =NULL, OI_number=0) ;

#endif /* OI_abrmnu_H */
