/*
 * Copyright (c) 1983 Eric P. Allman
 * Copyright (c) 1988 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef lint
char copyright[] =
"@(#) Copyright (c) 1988 Regents of the University of California.\n\
 All rights reserved.\n";
#endif /* not lint */

/*
	-a -c -o -r support by E.V., 02-Sep-92.
	Only the superuser is allowed to use -r.
*/

#ifndef lint
static char sccsid[] = "@(#)mailstats.c	5.7 (Berkeley) 6/1/90";
static char  rcsid[] = "@(#)$Id: mailstats.c,v 5.7.0.4 1992/10/12 22:22:14 paul Exp $";

#ifdef	__GNUC__
static	char	compiled[] = "@(#)compiled by gcc version "__VERSION__;
#endif
#endif /* not lint */

#include <sys/types.h>
#include <stdio.h>
/* #include <sys/file.h> /**/		/* already included by sendmail.h,
					/* double inclusion causes trouble
					/* on ISC */
#include <sendmail.h>
#include <mailstats.h>
#include "pathnames.h"

#define MNAMELEN 35			/* maximum length of mailer
					/* name to display */

char *name;
int
main(argc, argv)
	int argc;
	char **argv;
{
	extern char *optarg;
	extern int optind;
	struct statistics stat;
	register int i;
	int ch, fd;
	bool opt_z = FALSE, opt_a = FALSE;
	char buf[MAXLINE];
	char mtable[MAXMAILERS][MNAMELEN+1];
	FILE *CFILE;
	register char *b, *m, *s;
	char *cfile = _PATH_SENDMAILCF;
	char *sfile = _PATH_MAILSTATS;

	char *ctime();
	int getopt();
	void perror();

	name = argv[0];

	while ((ch = getopt(argc, argv, "ac:f:or?")) != EOF)
		switch((char)ch) {
			case 'a':	/* display all mailers */
				opt_a = TRUE;
				break;
			case 'c':	/* use alternate .cf file */
				cfile = optarg;
				break;
			case 'f':	/* use alternate statistics file */
				sfile = optarg;
				break;
			case 'o':	/* produce exactly old style display */
					/* (no mailer names) */
				cfile = "";
				break;
			case 'r':	/* reset stats file after display */
				opt_z = TRUE;
				break;
			case '?':
			default:
				printhelp(EX_USAGE);
		}

	argc -= optind;
	argv += optind;

	if (argc != 0) {			/* error if excessive args */
		fprintf(stderr, "%s: Syntax error -- %s\n", name, *argv);
		printhelp(EX_USAGE);
	}

	if (*cfile != '\0') {			/* print mailer names ? */
		if ((CFILE=fopen(cfile,"r")) == NULL)
			printerror(cfile, EX_NOINPUT);
		i = 0;
		while (fgets(buf, sizeof(buf), CFILE) != NULL) {
			b=buf;
			if (*b++ != 'M') continue;	/* not mailer def */

			if (i >= MAXMAILERS) {		/* more space? */
				fprintf(stderr,
					"Too many mailers defined, %d max.\n",
					MAXMAILERS);
				exit(EX_SOFTWARE);
			}
			m=mtable[i];
			s=m+MNAMELEN;			/* is [MNAMELEN+1] */
			while (*b != ',' && !isspace(*b) && *b != '\0' && m < s)
 				*m++ = *b++;
			*m = '\0';
			i++;
		}
		(void) fclose(CFILE);
		for (; i < MAXMAILERS; i++) mtable[i][0]='\0'; /* clear rest */
	}

	if ((fd = open(sfile, O_RDONLY)) < 0) printerror(sfile, EX_NOINPUT);
	
	if ((i=read(fd, (char *)&stat, sizeof(stat))) != sizeof(stat) ||
	    stat.stat_size != sizeof(stat)) {
		if (i == 0) 
			fprintf(stderr, "%s: No data in %s\n", name, sfile);
		else
			fprintf(stderr, "%s: Bad size of %s\n", name, sfile);
		exit(EX_OSERR);
	}

	printf("Statistics from %s", ctime(&stat.stat_itime));
	printf(" M msgsfr bytes_from  msgsto   bytes_to%s\n",
	       *cfile == '\0' ? "" : "  Mailer" );
	for (i = 0; i < MAXMAILERS; i++)
		if (stat.stat_nf[i] || stat.stat_nt[i] ||
                    (opt_a && mtable[i][0] != '\0'))	/* print all? */
			printf("%2d %6lu %10lu  %6lu %10lu%s%s\n",
			       i,
			       stat.stat_nf[i], stat.stat_bf[i],
			       stat.stat_nt[i], stat.stat_bt[i],
			       *cfile == '\0' ? "" : "  ",
			       *cfile == '\0' ? "" : mtable[i]);
	(void) close(fd);

	if (opt_z) {			/* zero stat file? */
		errno = EPERM;
		if (getuid() != 0 || (fd=open(sfile, O_WRONLY|O_TRUNC)) < 0)
			printerror(sfile, EX_OSERR);
		close(fd);
		fprintf(stderr, "%s: Statistics file %s reset.\n", name, sfile);
	}

	return(0);
}

printhelp(status)
	int status;
{
    fprintf(stderr,
	    "usage: %s [-a] [-o] [-r] [-c configfile] [-f statfile]\n", name);
    fprintf(stderr,
	    "       -a  display statistics for all mailers\n");
    fprintf(stderr,
	    "           (including those with zero counts)\n");
    fprintf(stderr,
	    "       -o  omit mailer names (old display format)\n");
    fprintf(stderr,
	    "       -r  reset statistics file after displaying\n");
    fprintf(stderr,
	    "       -c  sendmail configuration file to be used\n");
    fprintf(stderr,
	    "           (default %s)\n", _PATH_SENDMAILCF);
    fprintf(stderr,
	    "       -f  sendmail statistics file to be used\n");
    fprintf(stderr,
	    "           (default %s)\n", _PATH_MAILSTATS);
    exit(status);
}

printerror(filename, status)
	char *filename;
	int status;
{
	fprintf(stderr, "%s: ", name);
	perror(filename);
	exit(status);
}
