/*
**  RMAIL -- Receive remote mail requests.
**  Copyright (c) 1987 Lennart Lovstrand
**  CIS Dept, Univ of Linkoping, Sweden
**
**  Use it, abuse it, but don't sell it.
**
**  Version 2.6 of 5-May-87.
**
**	Modified Neil Rickert. 1992.  Replace the popen() call
**	with pipe() and execv(), and be careful about writing beyond
**	the end of strings.  Now supports multiple initial "From "
**	lines.
**
**  This time logging selected header lines + more liberal parsing of
**  the initial from-line but not yet with accounting & like; 14-Apr-85.
**  Dbm lookup of UUCP domain names added 5-May-87.
**
**  The following definitions below are optional:
**	LOGFILE -- If defined, should be the name of a file in which to
**		log the raw addresses of each message.
**	DEFAULT_HOST -- If no host is found in the envelope recipients,
**		this host is assumed [defaults to your local host].
**	DEFAULT_DOMAIN -- If the sending host is unqualifed, add this
**		domain to the host for use in the Received: line.
**	DOMAINTABLE -- If defined, should point to your local domain
**		lookup database.  It is used for the same purpose as
**		the DEFAULT_DOMAIN.
**	SM_DELIVER_MODE	-- if defined as "-odq" will cause sendmail to
**		queue mail for a later queueing run.  Or define as "-odi"
**		for interactive deliver,  to at least serialize processing.
**		If you receive large batches of email via UUCP you may
**		need this to limit the resulting system load.
*/

#ifndef lint
static char	Rcsid[] = "@(#)$Id: rmail.c,v 1.12 1992/08/04 18:01:30 paul Exp $";
#endif /* !lint */

#include "sendmail.h"

#define DB_DIREXT	".dir"
#define DB_PAGEXT	".pag"

#define STRSIZ		1024
#define MAXARGS		200
/* #define LOGFILE		"/usr/lib/uucp/rmail.log" */
#define SENDMAIL	"/usr/lib/sendmail"
/* #define SM_DELIVER_MODE	"-odq"	/*	*/
#define NETCHRS		"%@!:"
/* #define DEFAULT_HOST	"liuida" */
#define DEFAULT_DOMAIN	"UUCP"
/* #define DOMAINTABLE	"/usr/lib/mail/domaintable"	/*	*/

#define HH_CC		"cc"
#define HH_FROM		"from"
#define HH_MESSAGE_ID	"message-id"
#define HH_RETURN_PATH	"return-path"
#define HH_TO		"to"
#define HH_VIA		"via"

#define MAKELC(C)	(isupper(C) ? tolower(C) : C)
#define EATSPACE(P)	while (*P == ' ') P++

int anyin __P((const char *, const char *));
int iskey __P((const char *, const char *));

char *Progname;
int Debug = FALSE;
DBMFILE	*Dbm;

main(argc, argv)
    int argc;
    char **argv;
{
    char sys_name[STRSIZ], s_mac[STRSIZ], f_opt[STRSIZ], s[STRSIZ];
    int len_f; /* current length of f_opt */
    char *v_opt = "";
    char *p, *user, *host, *domain = "";
    char *readbuf;
    char *acctsys;
    char *CmdArgs[MAXARGS];
    char **NextArg;
    int CmdPipe[2];
    int ChildPid = -1, ChildStatus = 0;
    int n;
    FILE *outf;
#ifdef LOGFILE
    FILE *logf = NULL;
#endif /* LOGFILE */
#ifdef DOMAINTABLE
    datum key, val;
#endif /* DOMAINTABLE */
    int insideheader, printedlast = FALSE;
    int c, errflg = FALSE;
    
    extern int optind;
    extern char *optarg;

#ifdef DEFAULT_DOMAIN
    domain = DEFAULT_DOMAIN;
#endif /* DEFAULT_DOMAIN */

    Progname = argv[0];
    while ((c = getopt(argc, argv, "D:dv")) != EOF) {
	switch (c) {
	  case 'D':
	    domain = optarg;
	    break;
	  case 'd':
	    Debug++;
	    break;
	  case 'v':
	    v_opt = "-v";
	    break;
	  default:
	    errflg = TRUE;
	    break;
	}
    }
    if (errflg || optind >= argc) {
	(void) fprintf(stderr, "usage: %s [-Ddomain] user ...\n", Progname);
	exit(2);
    }

    sys_name[0]='\0';  /* Initial system name */
    acctsys = getenv("ACCTSYS");
    if (acctsys == NULL)	/* for HDB uucp */
	acctsys = getenv("UU_MACHINE");

    (void) strncpy(f_opt,"-f",sizeof(f_opt)); /* Initialize sender option */
    len_f = 2;
    user = NULL; /* Indicate no "From " line found yet */

#ifdef DOMAINTABLE
    Dbm = dbm_open(DOMAINTABLE, O_RDONLY);
    if (Dbm == NULL)
	perror(DOMAINTABLE);
#endif /* DOMAINTABLE */

#ifdef LOGFILE
    if ((logf = fopen(Debug ? "/dev/tty" : LOGFILE, "a")) != NULL) {
	struct timeval t;
	int a;

	(void) gettimeofday(&t, (struct timezone *) NULL);
	(void) fprintf(logf, "\n[%.12s] ", ctime(&t.tv_sec) + 4);
	for (a = 0; a < argc; a++)
	    (void) fprintf(logf, " '%s'", argv[a]);
	(void) putc('\n', logf);
    } else
	(void) fprintf(stderr, "%s: couldn't open log file \"%s\"\n",
		       Progname, LOGFILE);
#endif /* LOGFILE */

 /* Read all leading "From " or ">From " lines to construct a path */
    while ((readbuf = fgets(s,sizeof s, stdin)) &&
		(strncmp(s, "From ", 5) == 0 ||
		strncmp(s, ">From ", 6) == 0))
    {
#ifdef LOGFILE
	if (logf != NULL)
	    (void) fputs(s,logf);
#endif /* LOGFILE */

	host = NULL;
	user = &s[5];
	EATSPACE(user);
	if ((p = index(user, ' ')) != NULL)
	{
	    *p = '\0';
	    while ((p = index(p + 1, 'r')) != NULL)
	    {
		if (strncmp(p, "remote from ", 12) == 0)
		{
		    host = p + 12;
		    EATSPACE(host);
		    if ((p = index(host, '\n')) != NULL)
		    {
			*p-- = '\0';
			if (*p == '\r') *p = '\0';
		    }
		    if (*host == '\0')
			host = NULL;
		    break;
		}
	    }
	    if (host == NULL && (p = index(user, '!')) != NULL)
	    {
		host = user;
		*p++ = '\0';
		user = p;
	    }
	    if (strcmp(host, "somewhere") == 0)
		host = NULL;

	    if (acctsys == NULL)
	    {
		if (host)
		    acctsys = strncpy(sys_name, host, sizeof(sys_name));
		else
		    acctsys = ""; /* Only first "From " used for acctsys */
	    }

	    if (host)
	    {
		(void) strncpy(f_opt+len_f,host,sizeof(f_opt)-len_f-2);
		(void) strcat(f_opt, "!");
		len_f = strlen(f_opt);
	    }
	    /*
	    **	Copy user to '-f' option.  But don't
	    **	accumulate the length, as it may be
	    **	overwritten by later "From " lines.
	    */
	    (void) strncpy(f_opt+len_f,user,sizeof(f_opt)-len_f);
	}
    }

    if (user == NULL)
	*f_opt = '\0';

    if (acctsys && *acctsys) {
#ifdef DOMAINTABLE
	if (Dbm != NULL) {
	    key.dptr = acctsys;
	    key.dsize = strlen(acctsys) + 1;
	    val = dbm_fetch(Dbm, key);
	    if (val.dptr == NULL) {

		/* try again w.o. trailing null */
		key.dsize--;
		val = dbm_fetch(Dbm, key);
	    }
	    if (val.dptr != NULL)
		acctsys = strncpy(sys_name, val.dptr, sizeof(sys_name));
	}
#endif /* DOMAINTABLE */
	(void) strncpy(s_mac, "-oMs",sizeof(s_mac));
	(void) strncpy(&s_mac[4],acctsys,sizeof(s_mac) - 6);
	if (index(acctsys, '.') == NULL && *domain != '\0')
	{
	    n=strlen(s_mac);
	    s_mac[n] = '.';
	    (void) strncpy(&s_mac[n+1], domain, sizeof(s_mac) - n - 2);
	}
    } else {
	*s_mac = '\0';
	if (index(domain,'.') != NULL)
	{
	    (void) strncpy(s_mac, "-oMs",sizeof(s_mac));
	    (void) strncpy(&s_mac[4],domain,sizeof(s_mac) - 5);
	}
    }

    NextArg = &CmdArgs[0];
    *NextArg++ = SENDMAIL;
#ifdef SM_DELIVER_MODE
    *NextArg++ = SM_DELIVER_MODE ;
#endif /* SM_DELIVER_MODE */
    *NextArg++ = "-oee";
    *NextArg++ = "-oi";
    *NextArg++ = "-oMrUUCP";
    if (*s_mac) *NextArg++ = s_mac;
    if (*f_opt) *NextArg++ = f_opt;
    if (*v_opt) *NextArg++ = v_opt;

    for (; optind < argc; optind++) {
	p = argv[optind];
	if (*p == '(')
	{
	    n = strlen(p) -1;
	    if (p[n] == ')')
	    {
		p[n] = '\0';
		p++;
	    }
	}
#ifdef DEFAULT_HOST
	if (anyin(argv[optind], NETCHRS) == NULL)
	{
		char *tp;
		tp = (char *) malloc(sizeof(DEFAULT_HOST) + strlen(p) + 2);
		if (tp)
		{
			(void) strcpy(tp, DEFAULT_HOST);
			(void) strcat(tp,"!");
			(void) strcat(tp,p);
			p = tp;
		}
	}
#endif /* DEFAULT_HOST */
	if (*p != '-')
	    *NextArg++ = p;
	else
	{
	/*
	** Sendmail may treat '-' as an option violating security.
	** But it is a syntactically legal address.  We fudge by
	** prepending whitespace, which sendmail will ignore.
	*/
	    char *tp;
	    tp = (char *) malloc(2 + strlen(p));
	    if (tp)
	    {
		*tp = ' ';
		(void) strcpy(&tp[1], p);
		*NextArg++ = tp;
	    }
	}
    }
    *NextArg = NULL;

#ifdef LOGFILE
    if (logf != NULL)
    {
	for (NextArg= &CmdArgs[0];*NextArg;NextArg++)
		fprintf(logf," '%s'",*NextArg);
	fprintf(logf,"\n");
    }
#endif /* LOGFILE */
    if (Debug)
	outf = stdout;
    else {
	outf = NULL;
	ChildPid = pipe(CmdPipe) ? -1 : fork() ;
	if (ChildPid == 0)
	{
    /*
     * set our real uid to root as well as our effective uid so
     * make sendmail accept the -oM options
     */

		if (*f_opt)
    		    (void) setuid(0);
		close(CmdPipe[1]);
		dup2(CmdPipe[0],0);
		close(CmdPipe[0]);
		execv(CmdArgs[0], CmdArgs);
		exit(1);
	}
	if (ChildPid > 0)
	{
		outf = fdopen(CmdPipe[1],"w");
		close(CmdPipe[0]);
	}

	if (outf == NULL) {
	    (void) fprintf(stderr, "%s: could not open pipe thru %s\n",
			   Progname, CmdArgs[0]);
	    exit(1);
	}
    }

    insideheader = TRUE;
    for (; readbuf != NULL; readbuf = fgets(s, sizeof(s), stdin))
    {
#ifdef LOGFILE
	if (insideheader && (*s == '\n' || (*s == '\r' && s[1] == '\n')))
	    insideheader = FALSE;

	if (logf != NULL && insideheader &&
	    ((printedlast && isspace(*s)) ||
	     iskey(HH_FROM, s) || iskey(HH_TO, s) || iskey(HH_CC, s) ||
	     iskey(HH_RETURN_PATH, s) || iskey(HH_MESSAGE_ID, s))) {
		 (void) fprintf(logf, "\t%s", s);
		 printedlast = TRUE;
	     } else
		 printedlast = FALSE;
#endif /* LOGFILE */
	(void) fputs(s, outf);
    }

    if (!Debug)
    {
	fclose(outf);
	wait(&ChildStatus);
    }

#ifdef uuxqt_worked		/* uuxqt horibly mangles return addresses.
				 * Any address that contains a @ still gets
				 * remote! prepended to it.
				 *
				 * This hardwired exit value prevents uuxqt
				 * from attempting to send bounced mail.
				 *
				 * NB. Some other program (/bin/mail ???)
				 * also tried to handle this address and 
				 * further mungs it with another perpended
				 * remote!.
				 */
# ifdef LOGFILE
    if (logf != NULL)
	(void) fclose(logf);
# endif /* LOGFILE */

    if (!Debug)
	exit((ChildStatus >> 8) & 0377);
#else
   {
    
# ifdef LOGFILE
       if (logf != NULL)
       {
	   if (ChildStatus)
	       (void) fprintf(logf, "sendmail retval 0x%x\n", ChildStatus);
	   (void) fclose(logf);
       }
# endif /* LOGFILE */
   }
    exit(0);
#endif
}

#ifdef DEFAULT_HOST
/*
**	ANYIN -- Does the target string contain chars from the pattern string?
*/
anyin(t, p)
    const char *t;
    register const char *p;
{
    for (; *p != '\0'; p++)
	if (index(t, *p) != NULL)
	    return TRUE;
    return FALSE;
}
#endif /* DEFAULT_HOST */

#ifdef LOGFILE
/*
**	ISKEY -- Checks if the line is prefixed by the supplied keyword
**	(immediately followed by a colon)
*/
iskey(key, line)
    const char *key, *line;
{
    for (; *key != '\0' && *line != '\0'; key++, line++)
	if (MAKELC(*key) != MAKELC(*line))
	    break;

    return *key == '\0' && *line == ':';
}
#endif /* LOGFILE */
