/* This file is part of the Project Athena Zephyr Notification System.
 * It contains headers for the windowgram COMPILER rope structure.
 * A rope is a thick string.
 *
 *	Created by:	Mark W Eichin
 *
 *	$Source: /mit/zephyr/src/zwgc/RCS/ropes.h,v $
 *	$Author: jtkohl $
 *
 *	Copyright (c) 1987 by the Massachusetts Institute of Technology.
 *	For copying and distribution information, see the file
 *	"mit-copyright.h". 
 *	$Header: ropes.h,v 2.6 89/05/30 09:53:20 jtkohl Exp $
 */

#include <zephyr/mit-copyright.h>

#define ROPE_SIZE 16
#include "minmax.h"

typedef enum {NEXT=0, VAR, FIELD, HEAD, RAW, SYNC, SHOW, FORM, ROPE,
		COMMAND, END} rope_type;
/*
  rope_type labels the possible links in a rope. They determine what ind means.
  NEXT:		ind.next => another piece (this is a knot.)
  VAR:		ind.ex => a user variable name/val
  FIELD:	ind.ex => a user field name/val
  HEAD:		ind.ex => a notice header
  RAW:		ind.ex => a raw piece of text
  SYNC:		Delimiter of attached strings
  FORM:		Formatting information ignored in comparison 
  ROPE:		ind.rope == a nested rope
  END:		No more rope components.
*/

typedef void (*pfv)();

typedef struct _rope {
  rope_type	typ;
  union		_ind {
    int		ex;
    struct _rope *rope;
    struct _rope *next;
  } ind;
} rope;


/* Globals which (1) shouldn't be (2) should be elsewhere... */
extern rope *varropes[];		/* char *strand_var[] gone! */
extern char *strand_field[];		/* field contents */
extern char *strand_head[];
extern char *strand_raw[];
rope *fieldrp;			/* FIELDS to get freed */

int strand_field_max;
int strand_head_max;
int strand_raw_max;

#define WILDCHAR '*'
int ropcmp();
/*
  int ropcmp(r1, r2)
  rope *r1, *r2;

  Inputs: 2 ropes.
  Returns: 0 (false) if the ropes are the same (for compatibility with strcmp.)
	   Otherwise they are different. Ignores formatting data.

  Side Effects: None yet. Tries to be fast.
*/

#ifndef FALSE
#define FALSE (0)
#endif

#ifndef TRUE
#define TRUE (!FALSE)
#endif

rope *ropcat();
/*
  rope *r1, *r2;

  Inputs: 2 ropes.
  Returns: The concatenation of the two ropes, which is also already in r1.

  Side Effects: does NOT copy r2, just chains them.
*/

void ropappend();
/*
  rope *r;
  rope re;
  int size;

  Inputs: 1 rope, one piece, and a size (of sections of rope.)
  Returns: nothing.

  Side Effects: re is added to the end of r. If needed, another piece of
  	rope of length size is allocated to contain it.
*/

rope *ropinit();
void ropfree();
void relfree();

