/* This file is part of the Project Athena Zephyr Notification System.
 * Created by: Mark W. Eichin <eichin@athena.mit.edu>
 * $Source: /mit/zephyr/src/zwgc/RCS/parse_show.c,v $
 * $Author: eichin $
 *
 *	Copyright (c) 1988 by the Massachusetts Institute of Technology.
 *	For copying and distribution information, see the file
 *	"mit-copyright.h". 
 */
#include <zephyr/mit-copyright.h>
#ifndef lint
static char rcsid[] = "$Header: parse_show.c,v 2.7 88/07/10 23:45:28 eichin Exp $";
#endif lint

/*
 * parse_show uses a grammar as follows:
 *
 * <WS> <STUFF> <COMMENTS> <NL>
 * Thus it is much like the normal loop, but stuff is really weird.
 *
 */
#include "ropes.h"
#include "support.h"
#include "comp_types.h"

rope *parse_show(inv)
     char **inv;
{
  char *ins = *inv;
  char *str = ins;
  rope *showrope, cmd_ro;
  int done=0, eol=0;
  int is_variable=0;

  cmd_ro.typ = END;
  showrope = ropinit(ROPE_SIZE);

  while(*str && !done)
    {
      /* skip leading space */
      while(*str && is_blank(*str)) str++;
      eol = 0;
      
      /* grab the first frob */
      while(*str && !eol)
	{
	  char *cmnd = str;
	  int cmdlen = 0;
				/* ...was just is_symchar... */
	  while(*str && (cmdlen?isalnum(*str):is_symchar(*str)))
	    /* is_symchar('#') == FALSE */
	    {
	      str++;
	      cmdlen++;
	    }
	  if(is_variable)
	    {
	      cmd_ro = tokenize_variable(cmnd, cmdlen);
	      is_variable = 0;
	    }
	  else if(*cmnd == '$')
	    {
	      is_variable = TRUE;
	      str++;
	    }
	  else if (*cmnd == '@')
	    {
	      /* just hit it directly... */
	      if(cmdlen>1)
		{
		  cmd_ro = tokenize_show(cmnd+1, cmdlen-1);
		}
	      else
		{
		  cmd_ro = tokenize_raw(cmnd, cmdlen);
		  /* to catch solitary @ signs... */
		}
	    }
	  else if (*cmnd == '\n')
	    {
	      eol = TRUE;
	      str++;
	    }
	  else if(*str == '#')
	    {
	      while(*str && *str != '\n')
		str++;
	      continue;
	    }
	  else if (cmdlen == 0)
	    {
	      cmd_ro = tokenize_raw(cmnd, 1);
	      str++;
	      /* this was for whitespace, I guess... */
	    }
	  else
	    {
	      if(!strncasecmp(cmnd, "endshow", cmdlen))
		{
		  done = TRUE;
		  break;	/* don't let eol get set */
		}
	      else
		cmd_ro = tokenize_raw(cmnd, cmdlen);
	    }
	  if(cmd_ro.typ != END)
	    {
	      ropappend(showrope, cmd_ro, ROPE_SIZE);
	      cmd_ro.typ = END;
	    }
	}
      if(*str == '#')		/* this probably won't happen anymore */
	{
	  while(*str && *str != '\n')
	    str++;
	  eol = TRUE;
	}
      if(eol)
	{
	  rope elro;
	  char *eln = "\n";
	  elro = tokenize_raw(eln, 1);
	  ropappend(showrope, elro, ROPE_SIZE);
	}
    }

  *inv = str;
  
  return(showrope);
}
