#ifndef UMSDOS_PROGS_H
#define UMSDOS_PROGS_H

class UMSDOS_IOCTL{
	int fd;
	int verbose;
	/*~PROTOBEG~ UMSDOS_IOCTL */
public:
	UMSDOS_IOCTL (const char *dpath,
		 int _verbose,
		 int quit);
	int create (const char *fname,
		 mode_t mode,
		 time_t atime,
		 time_t ctime,
		 time_t mtime,
		 int uid,
		 int gid,
		 int rdev);
	int dosrmdir (const char *fname);
	int dossetup (int uid, int gid, mode_t mode);
	int dosstat (const char *fname,
		 struct stat&stat);
	int dosunlink (const char *fname);
private:
	void fname_copy (struct umsdos_ioctl&data,
		 const char *fname);
public:
	int getversion (int &version, int &release);
	int initemd (void);
private:
	int ioctl (int cmd, struct umsdos_ioctl *data);
public:
	int isok (void);
	int readdir (struct dirent&dirent);
	void rewind (void);
	int ureaddir (struct umsdos_dirent&udirent,
		 struct dirent&dirent);
	int urmdir (const char *fname);
	int uunlink (const char *fname);
	~UMSDOS_IOCTL (void);
	/*~PROTOEND~ UMSDOS_IOCTL */
};

#include "umsdos_progs.p"

#endif

