.TH polygons 3U "2 February 1991" "Unidraw" "InterViews Reference Manual"
.SH NAME
Rect, S_Rect, F_Rect, SF_Rect, Polygon, S_Polygon, F_Polygon,
SF_Polygon \- structured graphics classes for rectangles and polygons
.SH SYNOPSIS
.B #include <Unidraw/Graphic/polygons.h>
.SH DESCRIPTION
Rect and Polygon serve as abstract base classes for rectangle and
polygon structured graphics.  They are derived from Graphic and
Vertices, respectively.  Predefined subclasses include S_Rect, F_Rect,
and SF_Rect, which draw stroked, filled, and stroked-filled
rectangles, respectively; and S_Polygon, F_Polygon, and SF_Polygon,
which draw stroked, filled, and stroked-filled polygons, respectively.
The stroked subclasses store a PSBrush, the filled subclasses store a
PSPattern, and the stroked-filled subclasses store one of each.
.SH RECT PUBLIC OPERATIONS
.TP
.B "void GetOriginal(Coord& x0, Coord& y0, Coord& x1, Coord& y1)"
Return the rectangle's geometry, as specified in the constructor.
(\fIx0, y0\fP) defines one corner of the rectangle, while (\fIx1\fP,
\fIy1\fP) defines the opposing corner.
.SH RECT PROTECTED OPERATIONS
.TP
.B "Rectangle(Coord x0, Coord y0, Coord x1, Coord y1, Graphic* = nil)"
The constructor is protected to disallow instantiation of the abstract
base class.  A rectangle's geometry is defined by two points,
corresponding to opposing corners of the rectangle.  The constructor
also takes an optional graphic from which to obtain an initial set of
graphics state.
.TP
.B "void s_getExtent("
.ns
.TP
.B "    float&, float&, float&, float&, float&, Graphic*"
.ns
.TP
.B ")"
.ns
.TP
.B "void f_getExtent("
.ns
.TP
.B "    float&, float&, float&, float&, float&, Graphic*"
.ns
.TP
.B ")"
.ns
.TP
.B "boolean s_contains(PointObj&, Graphic*)"
.ns
.TP
.B "boolean f_contains(PointObj&, Graphic*)"
.ns
.TP
.B "boolean s_intersects(BoxObj&, Graphic*)"
.ns
.TP
.B "boolean f_intersects(BoxObj&, Graphic*)"
Helper functions that return extent and hit detection information
based on the bounding box that the rectangle defines.  s_getExtent,
s_contains, and s_intersects return information that accounts for the
width of a brush, as would be necessary if the rectangle is stroked,
while f_getExtent, f_contains, and f_intersects assumes that the
rectangle is filled.  Subclasses can use the operations to help
implement their getExtent, contains, and intersects operations.
.SH RECT SUBCLASS PUBLIC OPERATIONS
.TP
.B "S_Rect(Coord x0, Coord y0, Coord x1, Coord y1, Graphic* = nil)"
.ns
.TP
.B "F_Rect(Coord x0, Coord y0, Coord x1, Coord y1, Graphic* = nil)"
.ns
.TP
.B "SF_Rect(Coord x0, Coord y0, Coord x1, Coord y1, Graphic* = nil)"
Constructors for the various predefined Rect subclasses.
.SH POLYGON PROTECTED OPERATIONS
.TP
.B "Polygon(Coord* x, Coord* y, int count, Graphic* = nil)"
Polygon's constructor is protected to prevent instantiation of the
abstract base class.  The parameters are passed directly to the
Vertices constructor.
.SH POLYGON SUBCLASS PUBLIC OPERATIONS
.TP
.B "S_Polygon(Coord* x, Coord* y, int count, Graphic* = nil)"
.ns
.TP
.B "F_Polygon(Coord* x, Coord* y, int count, Graphic* = nil)"
.ns
.TP
.B "SF_Polygon(Coord* x, Coord* y, int count, Graphic* = nil)"
Constructors for the various predefined Rect subclasses.
.SH SEE ALSO
Graphic(3U), Vertices(3U), geomobjs(3U), pspaint(3U)
