#
#       Common Sub-Makefile for the MMDF System
#
HOST            = uclvax2
SYSTEM          = 4.2
MMPREF          =
LIBDIR          = /usr/mmdf/lib
CHANDIR         = /usr/mmdf/lib/chans
TBLDIR          = /usr/mmdf/mmdftable
BINDIR          = /bin
RCVDIR          = /usr/mmdf/lib/rcvmail

#
#  Defines used during installation
#
INSTALL		= install
CHOWN           = /bin/chug
MMDFLOGIN       = mmdf
ROOTLOGIN       = root
PGMPROT         = 755

#
#  Configuration Defines
#
#  See the document "Installing and Operating MMDF II" for descriptions
#  of the available CONFIGDEFS options.
#  (The paths below are relative from the individual source directories.)
#
CONFIGDEFS	= -DDEBUG=1 -DV4_2BSD -DNODOMLIT
CFLAGS          = -O -I../../h $(CONFIGDEFS)
LDFLAGS         = -s
MMDFLIBS        = ../../lib/libmmdf.a
SYSLIBS         = -ldbm
LINT            = lint
LFLAGS          = -phbvxacL -I../../h $(CONFIGDEFS)
LLIBS		= ../../lib/llib-lmmdf.ln
AR              = ar


#  Specify either ch_tbdbm (for DBM based tables) or ch_tbseq for
#  sequential IO based tables.
CH_TB   = ch_tbdbm

#  Specify one of the nameserver modules or the fake module
#  if you do not intend to support nameservers (4.2, fake)
TB_NS	= 4.2

#  Specify tai_???.o and lk_lock???.o
LOCALUTIL = tai_file.o lk_lock.o dial_noop.o


default:        real-default

.c.o:
	$(CC) $(CFLAGS) $(TARGET_ARCH) -c $<

.SUFFIXES: .o .c

#
#  special case dependencies
#
../../h/mmdf.h: ../../h/conf.h
	-touch ../../h/mmdf.h
.PRECIOUS: ../../h/mmdf.h

#
#  #include dependencies
#
#  Two versions are supplied.  One for sites with cc support
#  and one for those that don't have it.  Comment out the one
#  you do not want.

#  This one is for sites without cc support.
#
#  Note that this one blindly greps out all the include lines regardless
#  of whether or not they are actually active.  This will almost
#  certainly make too many dependencies and make(1) will complain that
#  it cannot make certain files in /usr/include.  Usually you can just
#  delete the reference to the file and go on. [DSH]
#
#depend:
#	cat </dev/null >x.c
#	for i in $(MODULES); do \
#		(echo $$i.o: $$i.c >>makedep; \
#		grep '^#[ 	]*include' x.c $$i.c | sed \
#			-e 's,c:[^"]*"\./\([^"]*\)".*,o: \1,' \
#			-e 's,c:[^"]*"/\([^"]*\)".*,o: /\1,' \
#			-e 's,c:[^"]*"\([^"]*\)".*,o: ../../h/\1,' \
#			-e 's,c:[^<]*<\(.*\)>.*,o: /usr/include/\1,' \
#			>>makedep); done
#	echo '/^# DO NOT DELETE THIS LINE/+2,$$d' >eddep
#	echo '$$r makedep' >>eddep
#	echo 'w' >>eddep
#	cp Makefile.real Makefile.bak
#	ed - Makefile.real < eddep
#	rm eddep makedep x.c
#	echo '# DEPENDENCIES MUST END AT END OF FILE' >> Makefile.real
#	echo '# IF YOU PUT STUFF HERE IT WILL GO AWAY' >> Makefile.real
#	echo '# see make depend above' >> Makefile.real

#  This one is for sites with cc support
#
# This macro contains the option for cc to turn on the dependency generation.
#
# Known values:
#
# 4.3BSD		-M
# Ultrix v3 (?)		-Em
# SysV r3.2 (?)		-E -H
#
# (?) -- not exactly sure of versions.
#
THE_M_FLAG= -M
#
depend:
#
# This section is for cc's which generate dependencies already in the
# format needed for a Makefile.  The awk incantation puts as many
# dependencies per line as are reasonable, and is the same as the awk
# incantation in the other half of this section. [DSH]
#
	( for i in ${MODULES} ; do \
		${CC} ${THE_M_FLAG} ${CFLAGS} $$i.c ; done ) | \
	awk ' { if ($$1 != prev) { print rec; rec = $$0; prev = $$1; } \
		else { if (length(rec $$2) > 78) { print rec; rec = $$0; } \
		       else rec = rec " " $$2 } } \
	      END { print rec } ' > makedep
#
# This section is for cc's which merely generate a list of included
# files.  The first awk incantation masages that output into the
# "file.o: file.c" preferred by make, and the second is the one above
# for prettying things up.  Note in the first incantion that error
# messages are assumed to have greater than one "field", and also
# are printed on the terminal.  Oh for a /dev/std{out,err} ... [DSH]
#
# 	( for i in ${MODULES} ; do \
# 		echo $$i >/tmp/curfile; echo "$$i.o: $$i.c" ; \
# 		${CC} ${THE_M_FLAG} ${CFLAGS} $$i.c >/dev/null 2>$$i.deps; \
# 		awk <$$i.deps 'NF > 1 { print >"/dev/tty"; next } \
# 			{print "'`cat /tmp/curfile`'.o: " $$1}' ; \
# 		rm -f $$i.deps $$i.out; done ) | \
# 	awk ' { if ($$1 != prev) { print rec; rec = $$0; prev = $$1; } \
# 		else { if (length(rec $$2) > 78) { print rec; rec = $$0; } \
# 		       else rec = rec " " $$2 } } \
# 	      END { print rec } ' > makedep
#
# This section is common to both and edits the Makefile to include
# the dependencies generated by one of the two methods above. [DSH]
#
	echo '/^# DO NOT DELETE THIS LINE/+2,$$d' >eddep
	echo '$$r makedep' >>eddep
	echo 'w' >>eddep
	cp Makefile.real Makefile.bak
	ed - Makefile.real < eddep
	rm eddep makedep
	echo '# DEPENDENCIES MUST END AT END OF FILE' >> Makefile.real
	echo '# IF YOU PUT STUFF HERE IT WILL GO AWAY' >> Makefile.real
	echo '# see make depend above' >> Makefile.real
