#define NSIGNALS	32


/* These are the error numbers for the SVr4 signal handling */
#define IBCS_SIGHUP	1
#define IBCS_SIGINT	2
#define IBCS_SIGQUIT	3
#define IBCS_SIGILL	4
#define IBCS_SIGTRAP	5
#define IBCS_SIGIOT	6
#define IBCS_SIGABRT	6
#define IBCS_SIGEMT	7
#define IBCS_SIGFPE	8
#define IBCS_SIGKILL	9
#define IBCS_SIGBUS	10
#define IBCS_SIGSEGV	11
#define IBCS_SIGSYS	12
#define IBCS_SIGPIPE	13
#define IBCS_SIGALRM	14
#define IBCS_SIGTERM	15
#define IBCS_SIGUSR1	16
#define IBCS_SIGUSR2	17
#define IBCS_SIGCLD	18
#define IBCS_SIGCHLD	18
#define IBCS_SIGPWR	19
#define IBCS_SIGWINCH	20
#define IBCS_SIGURG	21
#define IBCS_SIGPOLL	22
#define IBCS_SIGIO	22
#define IBCS_SIGSTOP	23
#define IBCS_SIGTSTP	24
#define IBCS_SIGCONT	25
#define IBCS_SIGTTIN	26
#define IBCS_SIGTTOU	27
#define IBCS_SIGVTALRM	28
#define IBCS_SIGPROF	29
#define IBCS_SIGGXCPU	30
#define IBCS_SIGGXFSZ	31


static unsigned long linux_to_ibcs_signals[NSIGNALS] = {
	0,
	IBCS_SIGHUP,	IBCS_SIGINT,	IBCS_SIGQUIT,	IBCS_SIGILL,
	IBCS_SIGTRAP,	IBCS_SIGABRT,	-1,		IBCS_SIGFPE,
	IBCS_SIGKILL,	IBCS_SIGUSR1,	IBCS_SIGSEGV,	IBCS_SIGUSR2,
	IBCS_SIGPIPE,	IBCS_SIGALRM,	IBCS_SIGTERM,	IBCS_SIGSEGV,
	IBCS_SIGCHLD,	IBCS_SIGCONT,	IBCS_SIGSTOP,	IBCS_SIGTSTP,
	IBCS_SIGTTIN,	IBCS_SIGTTOU,	IBCS_SIGIO,	IBCS_SIGGXCPU,
	IBCS_SIGGXFSZ,	IBCS_SIGVTALRM,	IBCS_SIGPROF,	IBCS_SIGWINCH,
	-1,		IBCS_SIGPWR,	-1
};

static unsigned long ibcs_to_linux_signals[NSIGNALS] = {
	0,
	SIGHUP,		SIGINT,		SIGQUIT,	SIGILL,
	SIGTRAP,	SIGIOT,		SIGUNUSED,	SIGFPE,
	SIGKILL,	SIGUNUSED,	SIGSEGV,	SIGUNUSED,
	SIGPIPE,	SIGALRM,	SIGTERM,	SIGUSR1,
	SIGUSR2,	SIGCHLD,	SIGPWR,		SIGWINCH,
	-1,		SIGPOLL,	SIGSTOP,	SIGTSTP,
	SIGCONT,	SIGTTIN,	SIGTTOU,	SIGVTALRM,
	SIGPROF,	SIGXCPU,	SIGXFSZ
};

/* SIGSTOP (23) is zeroed because Oracle seems to be sending this to the
 * backend when the frontend gets a tty interrupt. Why is not clear
 * because ISC doesn't, apparently, define 23 at all but it clearly
 * shouldn't be handled as SIGSTOP because this causes the backend to
 * halt and requires a restart.
 */
static unsigned long isc_to_linux_signals[NSIGNALS] = {
	0,
	SIGHUP,		SIGINT,		SIGQUIT,	SIGILL,
	SIGTRAP,	SIGIOT,		SIGUNUSED,	SIGFPE,
	SIGKILL,	SIGUNUSED,	SIGSEGV,	SIGUNUSED,
	SIGPIPE,	SIGALRM,	SIGTERM,	SIGUSR1,
	SIGUSR2,	SIGCHLD,	SIGPWR,		SIGWINCH,
	-1,		SIGPOLL,	0,		SIGTSTP,
	SIGCONT,	SIGTTIN,	SIGTTOU,	SIGVTALRM,
	SIGPROF,	SIGXCPU,	SIGXFSZ
};

unsigned long *signal_map_to_linux[] = {
	NULL,
	ibcs_to_linux_signals,
	ibcs_to_linux_signals,	/* SVR3 is a subset of SVR4 */
	ibcs_to_linux_signals,
	ibcs_to_linux_signals,
	isc_to_linux_signals	/* ISC4 - not checked yet */
};

unsigned long *signal_map_from_linux[] = {
	NULL,
	linux_to_ibcs_signals,
	linux_to_ibcs_signals,	/* SVR3 is a subset of SVR4 */
	linux_to_ibcs_signals,
	linux_to_ibcs_signals,
	linux_to_ibcs_signals	/* ISC4 - not checked yet */
};
