/*
 *  /vol/src/devel/gated/master/gated/src/isis_mib.h,v 1.1 1993/01/07 22:39:40 jch Exp
 */

/*
**	isis_mib.h
**
**	This file contains isis mib related definitions.
**
**
**	John Chu <jychu@watson.ibm.com>
**
*/


#define TRUE	1
#define FALSE	0


typedef struct OIDentifier *ObjectID;		/* ASN.1 OBJECT IDENTIFIER */


/* C types for ASN.1 or SMI types */
typedef int		Integer;		/* ASN.1 INTEGER */
typedef unsigned long	TimeTicks;		/* SMI TimeTicks */
#ifdef	USE_ISIS_MIB_COUNTER_DEF
typedef unsigned long	Counter;		/* SMI Counter */
#endif
typedef unsigned long	Gauge;			/* SMI Gauge */

typedef struct qbuf 	*OctetStr;		/* ASN.1 OCTET STRING */


/* Structure to model an object type */
typedef struct object_type ObjectType;

/* Structure to model an object instance */
typedef struct object_instance ObjectInstance;


/* ISIS mib table entries */
#define MAXOIDSIZE	64		/* a reasonal value */
typedef struct	{
	int	oid_nelem;		/* number of sub-identifers */
	unsigned int oid_elements[MAXOIDSIZE];	/* list of sub-identifers */

} ObjectIdentifier;


#define MAXOCTETSTRINGSIZELONG	256		/* number of bytes allocated */
#define MAXOCTETSTRINGSIZESHORT 32		/* number of bytes allocated */

typedef struct 	{
	unsigned short len;			/* actual length in contents */
	unsigned short maxlen;			/* max length defined by isis mib */
	unsigned char contents[MAXOCTETSTRINGSIZELONG];

} LongOctetString;

typedef struct 	{
	unsigned short len;			/* actual length in contents */
	unsigned short maxlen;			/* max length defined by isis mib */
	unsigned char contents[MAXOCTETSTRINGSIZESHORT];

} ShortOctetString;

typedef ShortOctetString OSINSAddress;
typedef ShortOctetString SNPAAddress;



/* The System Group, mandatory */

/* Maximum Number of Area Addresses, per ISO/IEC 10589:1992 (E), 7.1.5 */
#define MAXAREAADDRESSES	4	/* it should be equal or larger than the number 
					   setable by the system management */

/* The Level 1 Manual Area Address Entry and Table */
typedef struct 	{
	Integer		isisManAreaAddrSysInstance;
        OSINSAddress    isisManAreaAddr;
	Integer 	isisManAreaAddrExistState;

} IsisManAreaAddrEntry;

typedef struct	{	/* sorted by isisManAreaAddr */
	int		mib;
  	int		nentries;		
	int		maxentries;
	IsisManAreaAddrEntry *pentry[MAXAREAADDRESSES];
	IsisManAreaAddrEntry isisManAreaAddrEntry[MAXAREAADDRESSES];
} IsisManAreaAddrTable;


/* The Level 1 Area Address Entry and Table */
typedef struct	{
	Integer		isisAreaAddrSysInstance;
        OSINSAddress    isisAreaAddr;

} IsisAreaAddrEntry;

typedef struct	{	/* sorted by isisAreaAddr */
	int		mib;
  	int		nentries;		
	int		maxentries;
	IsisAreaAddrEntry *pentry[MAXAREAADDRESSES];
	IsisAreaAddrEntry isisAreaAddrEntry[MAXAREAADDRESSES];
} IsisAreaAddrTable;


/* The System Table Entry */
typedef struct 	{
        Integer		isisSysInstance;			/* planted */
	Integer         isisSysExistState;			/* planted */
	ShortOctetString isisSysVersion;			/* planted */
	Integer         isisSysType;				/* planted */
	ShortOctetString isisSysID;				/* planted */
	Integer         isisSysMaxPathSplits;			/* unfeatured */
	Integer         isisSysMinLSPTransInt;			/* jaded */
	Integer         isisSysMaxLSPGenInt;			/* jaded */
	Integer         isisSysMinBroadLSPTransInt;		/* jaded */
	Integer         isisSysCompSNPInt;			/* jaded */
	Integer         isisSysOrigL1LSPBuffSize;		/* jaded */
	Integer         isisSysMaxAreaAddresses;		/* jaded */
	Integer         isisSysMinLSPGenInt;			/* jaded */
	Integer         isisSysPollESHelloRate;			/* jaded */
	Integer         isisSysPartSNPInt;			/* jaded */
	Integer         isisSysWaitTime;			/* jaded */
	Integer	        isisSysDRISISHelloTimer;		/* jaded */
	Integer	        isisSysOperState;			/* planted */
	Integer	        isisSysL1State;				/* planted */
        Counter         isisSysCorrLSPs;			/* planted */
        Counter         isisSysLSPL1DbaseOloads;		/* planted */
        Counter         isisSysManAddrDropFromAreas;
        Counter         isisSysAttemptToExMaxSeqNums;		/* planted */
        Counter         isisSysSeqNumSkips;
        Counter         isisSysOwnLSPPurges;			/* planted */
        Counter         isisSysIDFieldLenMismatches;
        Counter         isisSysMaxAreaAddrMismatches;
	Integer		isisSysOrigL2LSPBufSize;		/* jaded */
	Integer	        isisSysL2State;				/* planted */
        Counter         isisSysLSPL2DbaseOloads;		/* planted */
        LongOctetString isisSysAuthAreaTransPwd;		/* unfeatured */
	LongOctetString isisSysAuthDomainTransPwd;		/* unfeatured */
        Counter         isisSysAuthFails;			/* unfeatured */
	IsisManAreaAddrTable	isisManAreaAddrTable;		/* planted */
	IsisAreaAddrTable	isisAreaAddrTable;		/* planted */

} IsisSysEntry;


/* The IS Adjacency Group, mandatory */
/* The IS Adjacency Area Address Table Entry */
typedef struct 	{
	Integer 	isisISAdjAreaAddrSysInstance;
	Integer         isisISAdjAreaAddrCircIndex;
	Integer         isisISAdjAreaAddrAdjIndex;
        OSINSAddress    isisISAdjAreaAddress;

} IsisISAdjAreaAddrEntry;

/* Maximum IS Adjacency Area Addresses Per IS Adjacency */
#define MAXAREAADDRESSESPERISADJ	4

typedef struct	{	/* sorted by isisISAdjAreaAddress */
	int		mib;
  	int		nentries;		
	int		maxentries;
	IsisISAdjAreaAddrEntry 	*pentry[MAXAREAADDRESSESPERISADJ];
	IsisISAdjAreaAddrEntry	isisISAdjAreaAddrEntry[MAXAREAADDRESSESPERISADJ];

} IsisISAdjAreaAddrTable;


/* The IS Adjacency Table Entry */
typedef struct 	{
        Integer                isisISAdjSysInstance;		/* planted */
	Integer                isisISAdjCircIndex;		/* planted */
	Integer                isisISAdjIndex;			/* planted */
	Integer                isisISAdjState;			/* planted */
	ShortOctetString       isisISAdjNeighSNPAAddress;	/* planted */
	Integer                isisISAdjNeighSysType;		/* planted */
	ShortOctetString       isisISAdjNeighSysID;		/* planted */
	Integer                isisISAdjUsage;			/* unknown */
	Integer                isisISAdjHoldTimer;		/* planted */
	Integer                isisISAdjNeighPriority;		/* planted */
	IsisISAdjAreaAddrTable isisISAdjAreaAddrTable;

} IsisISAdjEntry;

/* Maximum IS Adjacencies Per Circuit */
#define MAXISADJPERCIRC		12	

typedef struct	{	/* sorted by isisISAdjCircIndex */
	int		mib;
  	int		nentries;		
	int		maxentries;
	IsisISAdjEntry	*pentry[MAXISADJPERCIRC];
	IsisISAdjEntry	isisISAdjEntry[MAXISADJPERCIRC];

} IsisISAdjTable;


/* The Circuit Group, mandatory */

/* The Circuit Entry and Table */
typedef struct 	{
	Integer                isisCircSysInstance;		/* planted */
	Integer                isisCircIndex;			/* planted */
	Integer                isisCircIfIndex;			/* planted */
	Integer                isisCircOperState;
	Integer                isisCircExistState;		/* planted */
	Integer                isisCircType;			/* planted */
	Integer                isisCircISISHelloTimer;		/* jaded */
	Integer                isisCircL1DefaultMetric;		/* jaded */
	Integer                isisCircL1DelayMetric;		/* jaded */
	Integer                isisCircL1ExpenseMetric;		/* jaded */
	Integer                isisCircL1ErrorMetric;		/* jaded */
	Integer                isisCircExtDomain;		/* unfeatured */
        Counter                isisCircAdjChanges;		/* planted */
        Counter                isisCircInitFails;		/* planted */
        Counter                isisCircRejAdjs;
        Counter                isisCircOutCtrlPDUs;		/* planted */
        Counter                isisCircInCtrlPDUs;		/* planted */
        Counter                isisCircIDFieldLenMismatches;
        Counter                isisCircMaxAreaAddrMismatches;
	Integer                isisCircL2DefaultMetric;		/* jaded */
	Integer                isisCircL2DelayMetric;		/* jaded */
	Integer                isisCircL2ExpenseMetric;		/* jaded */
	Integer                isisCircL2ErrorMetric;		/* jaded */
	Integer                isisCircManL2Only;		/* planted */
	Integer                isisCircL1ISPriority;		/* planted */
	ShortOctetString       isisCircL1CircID;		/* planted */
	ShortOctetString       isisCircL1DesIS;			/* planted */
        Counter                isisCircLANL1DesISChanges;	/* planted */
	Integer                isisCircL2ISPriority;		/* planted */
	ShortOctetString       isisCircL2CircID;		/* planted */
	ShortOctetString       isisCircL2DesIS;			/* planted */
        Counter                isisCircLANL2DesISChanges;	/* planted */
	ShortOctetString       isisCircPtToPtCircID;
	ObjectIdentifier       isisCircStaticCallInfo;
	Integer                isisCircDACallDefMetInc;
	Integer                isisCircDACallDelMetInc;
	Integer                isisCircDACallErrMetInc;
	Integer                isisCircDACallExpMetInc;
	LongOctetString        isisCircAuthTransPwd;		/* unfeatured */
        Counter                isisCircAuthFails;		/* unfeatured */
	IsisISAdjTable	       isisISAdjTable;

} IsisCircEntry;

#define MAXCIRCSPERINSTANCE 10	 	/* must conform with MaximumCircuits in 
				   	   isis_base.h */

typedef struct 	{	/* sorted by isisCircIndex */
	int		mib;
  	int		nentries;		
	int		maxentries;
	IsisCircEntry	*pentry[MAXCIRCSPERINSTANCE];
	IsisCircEntry   isisCircEntry[MAXCIRCSPERINSTANCE];

} IsisCircTable;




/* Tables per instance of IS-IS */
typedef struct 	{
	IsisSysEntry		isisSysEntry;
	IsisCircTable		isisCircTable;

} IsisMibEntry;


/* Maximum IS-IS System Instances in this Intermediate-System */
#define MAXISISSYSINSTANCES	2

typedef struct 	{	/* sorted by isisSysInstance */
	int		mib;
  	int		nentries;		
	int		maxentries;
	IsisMibEntry	*pentry[MAXISISSYSINSTANCES];
	IsisMibEntry	isisMibEntry[MAXISISSYSINSTANCES];

	/* none-perInstance tables */

} IsisMibTable;


/* For mapping the queue part of a mib table */
typedef struct	{
	int		mib;			/* which mib table */
  	int		nentries;		/* valid number of entries */
	int		maxentries;		/* maximum number of valid entries */
	unsigned char	*pentry[1];		/* ptr to the entries */

} Queue;



/* Memory structures in isis_mib_table.c */
extern IsisMibTable isisMibTable;

/* Routines defined in isis_mib_table.c */
int initIsisMibCold();
int initIsisMibWarm();
unsigned char *locateEntry();
unsigned char *locateNextEntry();
unsigned char *searchEntry();			/* recursively search mib tree */

/* Indices for the depth of mib tree */
#define DEPTHSYSTEM		1
#define DEPTHCIRCUIT		2
#define DEPTHISADJ		3
#define DEPTHISADJAREAADDR	4
#define HEIGHTSYSTEM		1
#define HEIGHTCIRCUIT		2
#define HEIGHTISADJ		3
#define HEIGHTISADJAREAADDR	4

/* Type of mib table */
#define MIBSYSTEM		1
#define MIBMANAREAADDR		2
#define MIBAREAADDR		3
#define MIBCIRCUIT		4
#define MIBISADJ		5
#define MIBISADJAREAADDR	6


void queueInit();
void queueFlush();
unsigned char *queueNew();
int queueAdd();
int queueDelete();
int cmpSysEntry();
int cmpManAreaAddrEntry();
int cmpAreaAddrEntry();
int cmpCircEntry();
int cmpISAdjEntry();
int cmpISAdjAreaAddrEntry();


void initOctetString();
int copyOctetString();

int freshISAdjEntry();
int freshISAdjAreaAddrTable();



/* end of isis_mib.h */
