
FOREIGN MODULE msReduce;

(*
 *  Reduction Library for Modula-2*
 *
 *  allows for efficient reduction operations on
 *  arbitrarily large and distributed arrays
 *
 *
 *  Modula-2* interface by Ernst A. Heinz
 *
 *  C/MPL implementation by Ernst A. Heinz
 *
 *  Last change: 16.10.1992
 *)

(*
 *  naming conventions:
 *  -------------------
 *
 *    <as>Reduce<op><ts>( x: ARRAY ... OF <type> ) : <type>;
 *
 *    <as>MaskReduce<op><ts>( mask: ARRAY ... OF BOOLEAN;
 *                            x: ARRAY ... OF <type> ) : <type>;
 *
 *    <as> = "allocator shortcut",  <op> = "reduction operator"
 *    <ts> = "type shortcut"
 *
 *  example #1:
 *  -----------
 *
 *    SReduceMaxI( x: ARRAY SPREAD OF LONGINT ) : LONGINT;
 *
 *    SMaskReduceMaxI( mask: ARRAY SPREAD OF BOOLEAN;
 *                     x: ARRAY SPREAD OF LONGINT ) : LONGINT;
 *
 *    <as> = S,  <op> = Max,  <ts> = I,  <type> = LONGINT
 *
 *  example #2:
 *  -----------
 *
 *    CSReduceAddSC( x: ARRAY CYCLE OF ARRAY SPREAD OF SHORTCARD ) : SHORTCARD;
 *
 *    CSMaskReduceAddSC( mask: ARRAY CYCLE OF ARRAY SPREAD OF BOOLEAN;
 *                       x: ARRAY CYCLE OF ARRAY SPREAD OF SHORTCARD ) : SHORTCARD;
 *
 *    <as> = CS,  <op> = Add,  <ts> = SC,  <type> = SHORTCARD
 *)

(*
 *  normal reduction routines for 1-dimensional SPREAD arrays
 *)

PROCEDURE SReduceAddB ( x: ARRAY SPREAD OF BOOLEAN   ) : BOOLEAN;
PROCEDURE SReduceAddCh( x: ARRAY SPREAD OF CHAR	     ) : CHAR;
PROCEDURE SReduceAddSC( x: ARRAY SPREAD OF SHORTCARD ) : SHORTCARD;
PROCEDURE SReduceAddC ( x: ARRAY SPREAD OF LONGCARD  ) : LONGCARD;
PROCEDURE SReduceAddSI( x: ARRAY SPREAD OF SHORTINT  ) : SHORTINT;
PROCEDURE SReduceAddI ( x: ARRAY SPREAD OF LONGINT   ) : LONGINT;
PROCEDURE SReduceAddR ( x: ARRAY SPREAD OF REAL	     ) : REAL;
PROCEDURE SReduceAddLR( x: ARRAY SPREAD OF LONGREAL  ) : LONGREAL;

PROCEDURE SReduceAndB ( x: ARRAY SPREAD OF BOOLEAN   ) : BOOLEAN;
PROCEDURE SReduceAndCh( x: ARRAY SPREAD OF CHAR	     ) : CHAR;
PROCEDURE SReduceAndSC( x: ARRAY SPREAD OF SHORTCARD ) : SHORTCARD;
PROCEDURE SReduceAndC ( x: ARRAY SPREAD OF LONGCARD  ) : LONGCARD;
PROCEDURE SReduceAndSI( x: ARRAY SPREAD OF SHORTINT  ) : SHORTINT;
PROCEDURE SReduceAndI ( x: ARRAY SPREAD OF LONGINT   ) : LONGINT;

PROCEDURE SReduceMaxB ( x: ARRAY SPREAD OF BOOLEAN   ) : BOOLEAN;
PROCEDURE SReduceMaxCh( x: ARRAY SPREAD OF CHAR	     ) : CHAR;
PROCEDURE SReduceMaxSC( x: ARRAY SPREAD OF SHORTCARD ) : SHORTCARD;
PROCEDURE SReduceMaxC ( x: ARRAY SPREAD OF LONGCARD  ) : LONGCARD;
PROCEDURE SReduceMaxSI( x: ARRAY SPREAD OF SHORTINT  ) : SHORTINT;
PROCEDURE SReduceMaxI ( x: ARRAY SPREAD OF LONGINT   ) : LONGINT;
PROCEDURE SReduceMaxR ( x: ARRAY SPREAD OF REAL	     ) : REAL;
PROCEDURE SReduceMaxLR( x: ARRAY SPREAD OF LONGREAL  ) : LONGREAL;

PROCEDURE SReduceMinB ( x: ARRAY SPREAD OF BOOLEAN   ) : BOOLEAN;
PROCEDURE SReduceMinCh( x: ARRAY SPREAD OF CHAR	     ) : CHAR;
PROCEDURE SReduceMinSC( x: ARRAY SPREAD OF SHORTCARD ) : SHORTCARD;
PROCEDURE SReduceMinC ( x: ARRAY SPREAD OF LONGCARD  ) : LONGCARD;
PROCEDURE SReduceMinSI( x: ARRAY SPREAD OF SHORTINT  ) : SHORTINT;
PROCEDURE SReduceMinI ( x: ARRAY SPREAD OF LONGINT   ) : LONGINT;
PROCEDURE SReduceMinR ( x: ARRAY SPREAD OF REAL	     ) : REAL;
PROCEDURE SReduceMinLR( x: ARRAY SPREAD OF LONGREAL  ) : LONGREAL;

PROCEDURE SReduceMulB ( x: ARRAY SPREAD OF BOOLEAN   ) : BOOLEAN;
PROCEDURE SReduceMulCh( x: ARRAY SPREAD OF CHAR	     ) : CHAR;
PROCEDURE SReduceMulSC( x: ARRAY SPREAD OF SHORTCARD ) : SHORTCARD;
PROCEDURE SReduceMulC ( x: ARRAY SPREAD OF LONGCARD  ) : LONGCARD;
PROCEDURE SReduceMulSI( x: ARRAY SPREAD OF SHORTINT  ) : SHORTINT;
PROCEDURE SReduceMulI ( x: ARRAY SPREAD OF LONGINT   ) : LONGINT;
PROCEDURE SReduceMulR ( x: ARRAY SPREAD OF REAL	     ) : REAL;
PROCEDURE SReduceMulLR( x: ARRAY SPREAD OF LONGREAL  ) : LONGREAL;

PROCEDURE SReduceOrB  ( x: ARRAY SPREAD OF BOOLEAN   ) : BOOLEAN;
PROCEDURE SReduceOrCh ( x: ARRAY SPREAD OF CHAR	     ) : CHAR;
PROCEDURE SReduceOrSC ( x: ARRAY SPREAD OF SHORTCARD ) : SHORTCARD;
PROCEDURE SReduceOrC  ( x: ARRAY SPREAD OF LONGCARD  ) : LONGCARD;
PROCEDURE SReduceOrSI ( x: ARRAY SPREAD OF SHORTINT  ) : SHORTINT;
PROCEDURE SReduceOrI  ( x: ARRAY SPREAD OF LONGINT   ) : LONGINT;

(*
 *  masked reduction routines for 1-dimensional SPREAD arrays
 *
 *  necessary condition:  HIGH(mask) = HIGH(x)
 *)

PROCEDURE SMaskReduceAddB ( mask: ARRAY SPREAD OF BOOLEAN;
			    x: ARRAY SPREAD OF BOOLEAN ) : BOOLEAN;
PROCEDURE SMaskReduceAddCh( mask: ARRAY SPREAD OF BOOLEAN;
			    x: ARRAY SPREAD OF CHAR ) : CHAR;
PROCEDURE SMaskReduceAddSC( mask: ARRAY SPREAD OF BOOLEAN;
			    x: ARRAY SPREAD OF SHORTCARD ) : SHORTCARD;
PROCEDURE SMaskReduceAddC ( mask: ARRAY SPREAD OF BOOLEAN;
			    x: ARRAY SPREAD OF LONGCARD ) : LONGCARD;
PROCEDURE SMaskReduceAddSI( mask: ARRAY SPREAD OF BOOLEAN;
			    x: ARRAY SPREAD OF SHORTINT ) : SHORTINT;
PROCEDURE SMaskReduceAddI ( mask: ARRAY SPREAD OF BOOLEAN;
			    x: ARRAY SPREAD OF LONGINT ) : LONGINT;
PROCEDURE SMaskReduceAddR ( mask: ARRAY SPREAD OF BOOLEAN;
			    x: ARRAY SPREAD OF REAL ) : REAL;
PROCEDURE SMaskReduceAddLR( mask: ARRAY SPREAD OF BOOLEAN;
			    x: ARRAY SPREAD OF LONGREAL ) : LONGREAL;

PROCEDURE SMaskReduceAndB ( mask: ARRAY SPREAD OF BOOLEAN;
			    x: ARRAY SPREAD OF BOOLEAN ) : BOOLEAN;
PROCEDURE SMaskReduceAndCh( mask: ARRAY SPREAD OF BOOLEAN;
			    x: ARRAY SPREAD OF CHAR ) : CHAR;
PROCEDURE SMaskReduceAndSC( mask: ARRAY SPREAD OF BOOLEAN;
			    x: ARRAY SPREAD OF SHORTCARD ) : SHORTCARD;
PROCEDURE SMaskReduceAndC ( mask: ARRAY SPREAD OF BOOLEAN;
			    x: ARRAY SPREAD OF LONGCARD ) : LONGCARD;
PROCEDURE SMaskReduceAndSI( mask: ARRAY SPREAD OF BOOLEAN;
			    x: ARRAY SPREAD OF SHORTINT ) : SHORTINT;
PROCEDURE SMaskReduceAndI ( mask: ARRAY SPREAD OF BOOLEAN;
			    x: ARRAY SPREAD OF LONGINT ) : LONGINT;

PROCEDURE SMaskReduceMaxB ( mask: ARRAY SPREAD OF BOOLEAN;
			    x: ARRAY SPREAD OF BOOLEAN ) : BOOLEAN;
PROCEDURE SMaskReduceMaxCh( mask: ARRAY SPREAD OF BOOLEAN;
			    x: ARRAY SPREAD OF CHAR ) : CHAR;
PROCEDURE SMaskReduceMaxSC( mask: ARRAY SPREAD OF BOOLEAN;
			    x: ARRAY SPREAD OF SHORTCARD ) : SHORTCARD;
PROCEDURE SMaskReduceMaxC ( mask: ARRAY SPREAD OF BOOLEAN;
			    x: ARRAY SPREAD OF LONGCARD ) : LONGCARD;
PROCEDURE SMaskReduceMaxSI( mask: ARRAY SPREAD OF BOOLEAN;
			    x: ARRAY SPREAD OF SHORTINT ) : SHORTINT;
PROCEDURE SMaskReduceMaxI ( mask: ARRAY SPREAD OF BOOLEAN;
			    x: ARRAY SPREAD OF LONGINT ) : LONGINT;
PROCEDURE SMaskReduceMaxR ( mask: ARRAY SPREAD OF BOOLEAN;
			    x: ARRAY SPREAD OF REAL ) : REAL;
PROCEDURE SMaskReduceMaxLR( mask: ARRAY SPREAD OF BOOLEAN;
			    x: ARRAY SPREAD OF LONGREAL ) : LONGREAL;

PROCEDURE SMaskReduceMinB ( mask: ARRAY SPREAD OF BOOLEAN;
			    x: ARRAY SPREAD OF BOOLEAN ) : BOOLEAN;
PROCEDURE SMaskReduceMinCh( mask: ARRAY SPREAD OF BOOLEAN;
			    x: ARRAY SPREAD OF CHAR ) : CHAR;
PROCEDURE SMaskReduceMinSC( mask: ARRAY SPREAD OF BOOLEAN;
			    x: ARRAY SPREAD OF SHORTCARD ) : SHORTCARD;
PROCEDURE SMaskReduceMinC ( mask: ARRAY SPREAD OF BOOLEAN;
			    x: ARRAY SPREAD OF LONGCARD ) : LONGCARD;
PROCEDURE SMaskReduceMinSI( mask: ARRAY SPREAD OF BOOLEAN;
			    x: ARRAY SPREAD OF SHORTINT ) : SHORTINT;
PROCEDURE SMaskReduceMinI ( mask: ARRAY SPREAD OF BOOLEAN;
			    x: ARRAY SPREAD OF LONGINT ) : LONGINT;
PROCEDURE SMaskReduceMinR ( mask: ARRAY SPREAD OF BOOLEAN;
			    x: ARRAY SPREAD OF REAL ) : REAL;
PROCEDURE SMaskReduceMinLR( mask: ARRAY SPREAD OF BOOLEAN;
			    x: ARRAY SPREAD OF LONGREAL ) : LONGREAL;

PROCEDURE SMaskReduceMulB ( mask: ARRAY SPREAD OF BOOLEAN;
			    x: ARRAY SPREAD OF BOOLEAN ) : BOOLEAN;
PROCEDURE SMaskReduceMulCh( mask: ARRAY SPREAD OF BOOLEAN;
			    x: ARRAY SPREAD OF CHAR ) : CHAR;
PROCEDURE SMaskReduceMulSC( mask: ARRAY SPREAD OF BOOLEAN;
			    x: ARRAY SPREAD OF SHORTCARD ) : SHORTCARD;
PROCEDURE SMaskReduceMulC ( mask: ARRAY SPREAD OF BOOLEAN;
			    x: ARRAY SPREAD OF LONGCARD ) : LONGCARD;
PROCEDURE SMaskReduceMulSI( mask: ARRAY SPREAD OF BOOLEAN;
			    x: ARRAY SPREAD OF SHORTINT ) : SHORTINT;
PROCEDURE SMaskReduceMulI ( mask: ARRAY SPREAD OF BOOLEAN;
			    x: ARRAY SPREAD OF LONGINT ) : LONGINT;
PROCEDURE SMaskReduceMulR ( mask: ARRAY SPREAD OF BOOLEAN;
			    x: ARRAY SPREAD OF REAL ) : REAL;
PROCEDURE SMaskReduceMulLR( mask: ARRAY SPREAD OF BOOLEAN;
			    x: ARRAY SPREAD OF LONGREAL ) : LONGREAL;

PROCEDURE SMaskReduceOrB  ( mask: ARRAY SPREAD OF BOOLEAN;
			    x: ARRAY SPREAD OF BOOLEAN ) : BOOLEAN;
PROCEDURE SMaskReduceOrCh ( mask: ARRAY SPREAD OF BOOLEAN;
			    x: ARRAY SPREAD OF CHAR ) : CHAR;
PROCEDURE SMaskReduceOrSC ( mask: ARRAY SPREAD OF BOOLEAN;
			    x: ARRAY SPREAD OF SHORTCARD ) : SHORTCARD;
PROCEDURE SMaskReduceOrC  ( mask: ARRAY SPREAD OF BOOLEAN;
			    x: ARRAY SPREAD OF LONGCARD ) : LONGCARD;
PROCEDURE SMaskReduceOrSI ( mask: ARRAY SPREAD OF BOOLEAN;
			    x: ARRAY SPREAD OF SHORTINT ) : SHORTINT;
PROCEDURE SMaskReduceOrI  ( mask: ARRAY SPREAD OF BOOLEAN;
			    x: ARRAY SPREAD OF LONGINT ) : LONGINT;

END msReduce.
