
/*
 *  I/O Library for Modula-2*
 *
 *  all output goes to "stdout", all input comes from "stdin"
 *
 *
 *  Modula-2* interface by Ernst A. Heinz
 *
 *  C/MPL implementation by Ernst A. Heinz
 *
 *  Last change: 15.10.1992
 */

#include "msIO.LINX.h"
#include <stdio.h>

#define EolCh	'\n'

void
WrB(b)
BOOLEAN b;
{
  if (b) {
    WrCh('T');
  } else {
    WrCh('F');
  }
}

void
WrC(n, w)
LONGCARD n;
SHORTINT w;
{
  printf("%*u",w,n);
}

void
WrCh(ch)
CHAR ch;
{ 
  printf("%c",ch);
}

void
WrE(n, w, prec)
LONGREAL n;
SHORTINT w;
SHORTCARD prec;
{
  printf("%*.*e",w,prec,n);
}

void
WrF(n, w, prec, exp)
LONGREAL n;
SHORTINT w;
SHORTCARD prec;
BOOLEAN exp;
{
  if (exp) {
    WrE(n,w,prec);
  } else {
    WrR(n,w,prec);
  }  
}

void
WrH(n, w)
LONGCARD n;
SHORTINT w;
{
  printf("%*x",w,n);
}

void
WrI(n, w)
LONGINT n;
SHORTINT w;
{ 
  printf("%*d",w,n);
}
 
void
WrNl()
{ 
  printf("\n");
}

void
WrO(n, w)
LONGCARD n;
SHORTINT w;
{
  printf("%*o",w,n);
}

void
WrR(n, w, prec)
LONGREAL n;
SHORTINT w;
SHORTCARD prec;
{
  printf("%*.*f",w,prec,n);
}

void
WrS(s, l)
CHAR *s;
LONGCARD l;
{ 
  printf("%.*s",l,s);
}  

BOOLEAN
RdB()
{
  CHAR ch;
  do {
    ch = RdCh();
  } while (ch != 'f' && ch != 'F' && ch != 't' && ch != 'T');
  return (ch == 't' || ch == 'T');
}

LONGCARD
RdC()
{ 
  LONGCARD c;
  scanf("%lu",&c);
  return c;
}

CHAR
RdCh()
{ 
  CHAR ch;
  scanf("%c",&ch);
  return ch;
}  

LONGCARD
RdH()
{ 
  LONGCARD c;
  scanf("%lx",&c);
  return c;
}

LONGINT
RdI()
{ 
  LONGINT i;
  scanf("%ld",&i);
  return i;
}

void
RdNl()
{
  do {
  } while (RdCh() != EolCh);
}

LONGCARD
RdO()
{ 
  LONGCARD c;
  scanf("%lo",&c);
  return c;
}

LONGREAL
RdR()
{
  LONGREAL r;
  scanf("%lf",&r);
  return r;
}

void
RdS(s, l)
CHAR *s;
LONGCARD l;
{ 
  scanf("%s",s);
}
