
{ A demo program that uses the xbgi library.
  It draws a pie diagram to a new window.

  The demo was written a long time ago by a friend of mine for TP 3.0.
  It was modified to conform with extended pascal.
}

{ BGI graphics interface module.

  This interface module defines the BGI interfaces to be used with the
  XBGI library written by Peter King <king@physics.su.oz.au>

  Currently the interface module must be inserted in the source file
  before the modules that use the library.

  Author: Juki <jtv@hut.fi>

  This has been used only to test two tiny programs, so it is not
  likely to be correct.....
}

MODULE bgi Interface;

EXPORT BgiGraphics
 	       (Arc,Bar,Bar3D,Circle,ClearDevice,ClearViewport,CloseGraph,
 		DetectGraph,DrawPoly,FillEllipse,FillPoly,FloodFill,
 		GetAspectRatio,GetbkColor,GetColor,GetFillPattern,GetImage,
 		GetMaxColor,GetMaxMode,GetMaxX,GetMaxY,GetModeName,
 		GetModeRange,GetPixel,GetX,GetY,GraphDefaults,
		GraphResult,ImageSize,InitGraph,Line,LineTo,MoveTo,OutText,
 		OutTextXY,PieSlice,PutImage,PutPixel,Rectangle,Sector,
 		SetActivePage,SetAspectRatio,SetbkColor,SetColor,
 		SetFillPattern,SetFillStyle,SetLineStyle,SetPalette,
 		SetTextJustify,SetTextStyle,SetUserCharSize,SetViewPort,
 		SetVisualPage,SetWriteMode,TextHeight,TextWidth,
 		GetArcCoords, GetFillSettings, GetLineSettings,
 		GetTextSettings, GetViewSettings, SetAllPalette,
  		GetCH,KbHit,KeyPressed,ReadKey);

TYPE
   str_param = PACKED ARRAY [ 1..255 ] OF Char;

   ptr_char = ^Char;
   ptr_int  = ^Integer;
   u_int    =  __unsigned__ integer;
   longint  =  __long__     integer;
   u_long   =  __unsigned__ longint;

   Byte     =  0 .. 255;
   SignedByte = -128 .. 127;

TYPE
  ArcCoordsType =  RECORD
		     x,
   		     y,
   		     xStart,
		     yStart,
		     xEnd,
		     yEnd   :  Integer;
		   END;

{ Date is reserved in Extended Pascal.
  Use GetTimeStamp to get the date & time }
  rdate = RECORD
	    da_year : Integer;
	    da_day  ,
	    da_mon : Byte;
	  END;	     

  FillSettingsType = RECORD
		       pattern,
		       color   : Integer;
		     END;

  LineSettingsType = RECORD
		       linestyle : integer;
		       upattern  : u_int;
		       thickness : integer;
		     END;

  PaletteType = RECORD
		  size    : Byte;
		  colours : PACKED ARRAY [ Colours ] OF SignedByte;
		END;

  TextSettingsType = RECORD
		       font,
		       direction,
		       charsize,
		       horiz,
		       vert :  Integer;
		     END;

  ViewPortType = RECORD
		   left,
		   top,
		   right,
		   bottom,
		   clip :	 Integer;
		 END;

  Borland_Info = RECORD
		   colour_index : Integer;
		   colour_name  : ptr_char;
		   pixel_values : u_long;
		 END;


  { ** clean up parameter names below ** }

  PROCEDURE arc (x,y,stangle,endangle,radius : integer); C;
  PROCEDURE bar (left,top,right,bottom: integer); C;
  PROCEDURE bar3d (left,top,right,bottom,depth,topflag: integer); C;
  PROCEDURE circle (x,y,radius: integer); C;
  PROCEDURE cleardevice; C;
  PROCEDURE clearviewport; C;
  PROCEDURE closegraph; C;
  PROCEDURE detectgraph (VAR driver, mode: integer); C;
  PROCEDURE drawpoly (numpoints: integer; polypoints: ptr_int); C;
  PROCEDURE fillellipse (a,b,c,d: integer); C;
  PROCEDURE fillpoly (numpoints: integer; polypoints: ptr_int); C;
  PROCEDURE floodfill (x,y,border: integer); C;
  PROCEDURE getaspectratio (VAR xasp, yasp: integer); C;
  FUNCTION  getbkcolor : integer; C;
  FUNCTION  getcolor : integer; C;
  PROCEDURE getfillsettings (VAR a : fillsettingstype); C;
  PROCEDURE getfillpattern (VAR a: str_param); C;
  PROCEDURE getimage (a,b,c,d : integer; e : __cstring__); C;
  FUNCTION  getmaxcolor : integer; C;
  FUNCTION  getmaxmode : integer; C;
  FUNCTION  getmaxx : integer; C;
  FUNCTION  getmaxy : integer; C;
  FUNCTION  getmodename (a: integer) : ptr_char; C;
  PROCEDURE getmoderange (a: integer; VAR b,c: integer); C;
  FUNCTION  getpixel (a, b: integer) : u_int; C;
  FUNCTION  getx : integer; C;
  FUNCTION  gety : integer; C;
  PROCEDURE graphdefaults; C;
  FUNCTION  graphresult : integer; C;
  FUNCTION  imagesize (a,b,c,d: integer) : u_int; C;
  PROCEDURE initgraph (VAR a,b: integer; VAR c: str_param); C;
  PROCEDURE line (a,b,c,d: integer); C;
  PROCEDURE lineto (a, b: integer); C;
  PROCEDURE moveto (a, b: integer); C;
  PROCEDURE outtext (VAR c: str_param); C;
  PROCEDURE outtextxy (x,y: integer; VAR c: str_param); C;
  PROCEDURE pieslice (a,b,c,d,e: integer); C;
  PROCEDURE putimage (a,b: integer; c: __cstring__; d: integer); C;
  PROCEDURE putpixel (a,b,c: integer); C;
  PROCEDURE rectangle (a,b,c,d: integer); C;
  PROCEDURE sector (a,b,c,d,e,f	: integer); C;
  PROCEDURE setactivepage (a: integer); C;
  PROCEDURE setaspectratio (a, b: integer); C;
  PROCEDURE setbkcolor (a: integer); C;
  PROCEDURE setcolor (a: integer); C;
  PROCEDURE setfillpattern (VAR	a: str_param; b: integer); C;
  PROCEDURE setfillstyle (a, b: integer); C;
  PROCEDURE setlinestyle (a: integer; b: u_int; c: integer); C;
  PROCEDURE setpalette (a, b: integer); C;
  PROCEDURE settextjustify (a, b: integer); C;
  PROCEDURE settextstyle (a,b,c: integer); C;
  PROCEDURE setusercharsize (a,b,c,d: integer); C;
  PROCEDURE setviewport (a,b,c,d,e: integer); C;
  PROCEDURE setvisualpage (a: integer); C;
  PROCEDURE setwritemode (a: integer); C;
  FUNCTION  textheight (VAR a: str_param) : integer; C;
  FUNCTION  textwidth (VAR a: str_param) : integer; C;

  PROCEDURE getarccoords (VAR a	: arccoordstype); C;
  PROCEDURE getlinesettings (VAR a : linesettingstype); C;
  PROCEDURE gettextsettings (VAR a : textsettingstype); C;
  PROCEDURE getviewsettings (VAR a : viewporttype); C;
  PROCEDURE setallpalette (VAR a : palettetype); C;

{-------------------------------------------------------------------------}

  FUNCTION  getch : integer; C;
  FUNCTION  kbhit : integer; C;

  { This could be done in a standard way in extended pascal }
{  PROCEDURE getdate (VAR a : rdate); C; }

   FUNCTION keypressed : integer; C;
   FUNCTION readkey : char; C;
end.

{ DEMO STARTS HERE. The above is the library interface module. }

Program PieChart (Input,Output);

import BgiGraphics;

const
  maxinx = 10;

var
  data : array [ 1..maxinx ] of record
				  d : integer;	
				  n : string(30);
				end;

function filldata : integer;
begin
  data[1].d := 55;  
  data[2].d := 20;  
  data[3].d := 10;  
  data[4].d := 4;  
  data[5].d := 3;  
  data[6].d := 3;  
  data[7].d := 2;  
  data[8].d := 2;  
  data[9].d := 2;  
  data[10].d := 5;  

  data[1].n := 'Tekn. Yo.';  
  data[2].n := 'Yo';  
  data[3].n := 'Ins';  
  data[4].n := 'Asent';  
  data[5].n := 'Fil. Yo.';  
  data[6].n := 'Kaupt.Yo';  
  data[7].n := 'Valt.Yo.';  
  data[8].n := 'Arkkit.Yo';  
  data[9].n := 'Ei mitaan';  
  data[10].n := 'Muut';  

  filldata := maxinx;
end;

type
  stype = packed array [ 1..255 ] of char;

var
  Driver : integer;
  mode   : integer;
  foo    : stype;
  cptr   : ^char;

var
  total : real value 0.0;
  y,x,r : integer value 0;
  i,lkm : integer;
  j     : real value 0.0;
  ch    : char;

Begin
  detectgraph(driver,mode);

  lkm := filldata;
  for i := 1 to lkm do
    total := total + data[i].d;

  initgraph(driver,mode,foo);
  y := getmaxy/2;
  x := y;
  r := y;

  settextstyle (0, 0, 4);

  for i := 1 to lkm do
  begin
   setlinestyle (0, 0, 3);
   setfillstyle(1,i);
   pieslice(x+x/10,
	    y,
            trunc(j), 
	    trunc(j)+(data[i].d*360)/total,
	    r);
   j := j + ((data[i].d*360)/total);
   bar3d(x*2+3*x/10,
	 r*2/lkm*(i-1),
	 x*2+4*x/10,
	 r*2/lkm*i,
	 0,
	 0);

  writestr (foo, data[i].n,' ',trunc((data[i].d*100)/total):2);
  outtextxy(2*x+5*x/10+5,r*2/lkm*(i-1)+3,foo);
  end;
  read(ch);
  closegraph;
end.
