/* 
 * order.c 
 * 
 * Copyright (C), 1994, Graeme W. Wilford. (Wilf.)
 *
 * You may distribute under the terms of the GNU General Public
 * License as specified in the file COPYING that comes with the man
 * distribution.
 *
 * code to order an ':' separated set of filenames within
 * a string, according to the hierarchy of *std_sections[]
 * - reverse order of priority used, as this is later re-reversed.
 *
 * Tue Apr 26 12:56:44 BST 1994  Wilf. (G.Wilford@ee.surrey.ac.uk) 
 */

#define MAN_MAIN /* to not define config_file */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "config.h"
#include "gripes.h"

#define ELEMENTS        20       /* max. No. of man sections per path */
extern char *prognam;
extern int debug;

/*
 * Try and keep this one as fast as possible.
 * -- the compare function --
 * decides the priority of manpages, based upon *std_sections[]
 */
 
int compare(char **page1, char **page2)
{
   /* static char *std_sections[] = { "1", "2", ... , NULL } */

	register char *sec1, *sec2;
	char **sec_list;

	sec_list = std_sections;

	sec1 = strrchr(*page1, '.');
	sec2 = strrchr(*page2, '.');

	if (*(++sec1) == *(++sec2)){
		if (debug)
			fprintf(stderr, "\ncompare: unlikely scenario of equal sections\n\t%s\n\t%s\n\n",
			  *page1, *page2);
		return 0;
	}
	 
	while(*sec_list != NULL){

		if (*sec1 == **sec_list)
			return -1;
		
		if (*sec2 == **(sec_list++))
			return 1;
	}
/*
	while(std_sections[i] != NULL){

		if (*sec1 == *std_sections[i])
			return -1;
		
		if (*sec2 == *std_sections[i++])
			return 1;
	}
 */
	/* big BIG problems if we ever reach here */

	fprintf(stderr,"%s: compare: neither %c or %c appear to exist in section list -"
	 " cannot order pages.\n", prognam, *sec1, *sec2);
	exit(1);
}

char *orderthem(char *newpage, char *list)
{
	char *substring[ELEMENTS];
	char *delim;
	char *newlist;
	short i = 0;
	size_t len;

	len = strlen (newpage) + strlen(list) + 2;

	if ( (newlist = (char *) malloc (len)) == NULL)
		gripe_alloc(len, "newlist in orderthem");

	while ( (delim = strrchr(list, ':')) != NULL){
		*delim = '\0';
		substring[i++] = ++delim;
	}

	substring[i++] = list;
	substring[i++] = newpage;

	qsort( (void *) substring, i--, sizeof(char *) , (__compar_fn_t) compare);

	*newlist = '\0';
	
	while (i >= 0){
		strcat(newlist, substring[i]);
		if (i-- > 0)
			strcat(newlist, ":");
	}
	return newlist;
}
