/*
 * This file used to be part of manp.c (which actually used to be called
 * manpath.c) - see that file for copyright and other info.
 *
 * manpath.c: driver for the manpath routines
 */

#define MANPATH_MAIN    /* to not define *std_sections[] */

#ifndef STDC_HEADERS
extern char *strcpy ();
extern int fflush ();
#endif

#include <unistd.h>
#include <stdio.h>

char *mkprogname(char *s);
char *manpath(int perrs);

char *prognam;
int debug;

/*
 * Examine user's PATH and print a reasonable MANPATH.
 */
int main (int argc, char *argv[])
{
	int c, quiet = 1;

	prognam = mkprogname (argv[0]);

	while ((c = getopt (argc, argv, "dhq?")) != EOF){

		switch (c){

			case 'd':
			    	debug++;
			    	break;
		    	case 'q':
			    	quiet--;
			    	break;
		    	case '?':
		    	case 'h':
		    	default:
				fprintf (stderr, "usage: %s [-q]\n", prognam);
				return 0;
		}
	}
	printf ("%s\n", manpath (quiet));
	return 0;
}
