#ifndef _LINUX_PPP_H
#define _LINUX_PPP_H

/* definitions for kernel PPP module
   Michael Callahan <callahan@maths.ox.ac.uk>
   Nov. 4 1993 */

/* how many PPP units? */
#define PPP_NRUNIT     4

#define PPP_VERSION  "0.1.2"

/* line discipline number */
#define N_PPP          3

#define	PPPIOCGFLAGS	0x5490	/* get configuration flags */
#define	PPPIOCSFLAGS	0x5491	/* set configuration flags */
#define	PPPIOCGASYNCMAP	0x5492	/* get async map */
#define	PPPIOCSASYNCMAP	0x5493	/* set async map */
#define	PPPIOCGUNIT	0x5494	/* get ppp unit number */
#define PPPIOCSINPSIG   0x5495  /* set input ready signal */
#define PPPIOCSDEBUG    0x5497  /* set debug level */
#define PPPIOCGDEBUG    0x5498  /* get debug level */

/* special characters in the framing protocol */
#define PPP_FLAG       0x7E   	/* frame delimiter -- marks frame boundaries */
#define PPP_ADDRESS    0xFF	/* first character of frame   <--  (may be   */
#define PPP_CONTROL    0x03	/* second character of frame  <-- compressed)*/
#define PPP_ESC        0x7d	/* escape charecter -- next character is
				   data, and the 0x20 bit should be toggled.
				   PPP_ESC PPP_FLAG is illegal */

/* protocol numbers */
#define PROTO_IP       0x0021
#define PROTO_VJCOMP   0x002d
#define PROTO_VJUNCOMP 0x002f

/* FCS support */
#define PPP_FCS_INIT   0xffff
#define PPP_FCS_GOOD   0xf0b8

/* initial MTU */
#define PPP_MTU        1500

/* flags */
#define SC_COMP_PROT	0x00000001	/* protocol compression (output) */
#define SC_COMP_AC	0x00000002	/* header compression (output) */
#define	SC_COMP_TCP	0x00000004	/* TCP (VJ) compression (output) */
#define SC_NO_TCP_CCID	0x00000008	/* disable VJ connection-id comp. */
#define SC_REJ_COMP_AC	0x00000010	/* reject adrs/ctrl comp. on input */
#define SC_REJ_COMP_TCP	0x00000020	/* reject TCP (VJ) comp. on input */
#define	SC_MASK		0x0000ffff	/* bits that user can change */

#ifdef __KERNEL__

struct ppp {
  /* Bitmapped flag fields. */
  char			inuse;		/* are we allocated?		*/
  char			sending;	/* "channel busy" indicator	*/
  char			escape;		/* 0x20 if prev char was PPP_ESC*/
  char			toss;		/* toss this frame              */

  unsigned char         flags;		/* miscellany                   */

  int                   async_map;	/* 1 bit means that given control 
					   character is quoted on output,
					   ignored on input             */
  int                   mtu;		/* maximum frame size           */
  unsigned short        fcs;	        /* FCS field of current frame   */

  /* Various fields. */
  int			line;		/* PPP channel number		*/
  struct tty_struct	*tty;		/* ptr to TTY structure		*/
  struct device		*dev;		/* easy for intr handling	*/
  struct slcompress	*slcomp;	/* for header compression 	*/

  /* These are pointers to the malloc()ed frame buffers.
     These buffers are used while processing a packet.  If a packet
     has to hang around for the user process to read it, it lingers in
     the user buffers below. */
  unsigned char		*rbuff;		/* receiver buffer		*/
  unsigned char		*xbuff;		/* transmitter buffer		*/
  unsigned char		*cbuff;		/* compression buffer		*/

  /* These are the various pointers into the buffers. */
  unsigned char		*rhead;		/* RECV buffer pointer (head)	*/
  unsigned char		*rend;		/* RECV buffer pointer (end)	*/
  int			rcount;		/* PPP receive counter		*/
  unsigned char         *xhead;	        /* XMIT buffer pointer          */

  /* Structures for interfacing with the user process. */
#define RBUFSIZE 4000
  unsigned char         *us_rbuff;      /* circular incoming packet buf.*/
  unsigned char         *us_rbuff_end;  /* end of allocated space       */
  unsigned char         *us_rbuff_head; /* head of waiting packets      */
  unsigned char         *us_rbuff_tail; /* tail of waiting packets      */
  struct wait_queue     *us_read_waitq; /* queue for reading processes  */
  struct wait_queue     *us_write_waitq;/* queue for writing processes  */
  unsigned char         us_rbuff_lock;  /* lock: bit 0 head bit 1 tail  */
  int                   inp_sig;        /* input ready signal for pgrp  */
  int                   inp_sig_pid;    /* process to get notified      */

  /* PPP interface statistics. */
  unsigned long		rpacket;	/* inbound frame counter	*/
  unsigned long		roverrun;	/* "buffer overrun" counter	*/
  unsigned long		spacket;	/* outbound frames counter	*/
  unsigned long		sbusy;		/* "transmitter busy" counter	*/
  unsigned long		errors;		/* error count			*/

};
#endif  /* __KERNEL__ */
#endif  /* _LINUX_PPP_H */
