/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.pilotlink;

import org.gnu.pilotlink.AppInfo;

public class RawAppInfo
extends AppInfo {
    byte[] buffer;
    String[] categories = new String[16];
    boolean[] isRenamed = new boolean[16];
    int catCount = 0;

    public RawAppInfo(byte[] byArray) {
        this.setBuffer(byArray);
    }

    @Override
    public byte[] getBuffer() {
        return this.buffer;
    }

    @Override
    public void setBuffer(byte[] byArray) {
        this.buffer = byArray;
        int n = byArray[0] * 256 + byArray[1];
        this.catCount = 0;
        for (int i = 0; i < 16; ++i) {
            if (byArray[2 + i * 16] != 0) {
                this.categories[i] = new String(byArray, 2 + i * 16, 16);
                System.out.println("Got Category: \"" + this.categories[i] + "\"");
                ++this.catCount;
            } else {
                this.categories[i] = null;
            }
            this.isRenamed[i] = (n & 1 << i) != 0;
        }
    }

    @Override
    public boolean isCatRenamed(int n) {
        return this.isRenamed[n];
    }

    @Override
    public String getCatName(int n) {
        return this.categories[n];
    }

    @Override
    public int getCatCount() {
        return this.catCount;
    }
}

