/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jdbc3;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import virtuoso.jdbc3.Closeable;
import virtuoso.jdbc3.ConnectionWrapper;
import virtuoso.jdbc3.ResultSetWrapper;
import virtuoso.jdbc3.VirtuosoException;

public class StatementWrapper
implements Statement,
Closeable {
    private Integer r_MaxFieldSize;
    private Integer r_MaxRows;
    private Boolean r_EscapeProcessing;
    private Integer r_QueryTimeout;
    private Integer r_FetchDirection;
    private Integer r_FetchSize;
    protected Statement stmt;
    protected ConnectionWrapper wconn;
    protected HashMap objsToClose = new HashMap();
    protected volatile boolean isClosed = false;

    protected StatementWrapper(ConnectionWrapper connectionWrapper, Statement statement) {
        this.wconn = connectionWrapper;
        this.stmt = statement;
        this.addLink();
    }

    protected void exceptionOccurred(SQLException sQLException) {
        if (this.wconn != null) {
            this.wconn.exceptionOccurred(sQLException);
        }
    }

    public void finalize() throws Throwable {
        this.close();
    }

    protected void addLink() {
        this.wconn.addObjToClose(this);
    }

    protected void removeLink() {
        this.wconn.removeObjFromClose(this);
    }

    protected void reset() throws SQLException {
        HashMap hashMap = (HashMap)this.objsToClose.clone();
        try {
            Iterator iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                ((ResultSetWrapper)iterator.next()).close();
            }
            this.objsToClose.clear();
            hashMap.clear();
            if (this.r_MaxFieldSize != null) {
                this.stmt.setMaxFieldSize(this.r_MaxFieldSize);
            }
            if (this.r_MaxRows != null) {
                this.stmt.setMaxRows(this.r_MaxRows);
            }
            if (this.r_EscapeProcessing != null) {
                this.stmt.setEscapeProcessing(this.r_EscapeProcessing);
            }
            if (this.r_QueryTimeout != null) {
                this.stmt.setQueryTimeout(this.r_QueryTimeout);
            }
            if (this.r_FetchDirection != null) {
                this.stmt.setFetchDirection(this.r_FetchDirection);
            }
            if (this.r_FetchSize != null) {
                this.stmt.setFetchSize(this.r_FetchSize);
            }
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        StatementWrapper statementWrapper = this;
        synchronized (statementWrapper) {
            try {
                this.removeLink();
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.wconn = null;
                if (this.objsToClose != null) {
                    this.objsToClose.clear();
                }
            }
            catch (SQLException sQLException) {
                this.exceptionOccurred(sQLException);
                throw sQLException;
            }
        }
    }

    public ResultSet executeQuery(String string) throws SQLException {
        this.check_close();
        try {
            ResultSet resultSet = this.stmt.executeQuery(string);
            if (resultSet != null) {
                return new ResultSetWrapper(this.wconn, this, resultSet);
            }
            return null;
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public int executeUpdate(String string) throws SQLException {
        this.check_close();
        try {
            return this.stmt.executeUpdate(string);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public int getMaxFieldSize() throws SQLException {
        this.check_close();
        try {
            return this.stmt.getMaxFieldSize();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public void setMaxFieldSize(int n) throws SQLException {
        this.check_close();
        try {
            if (this.r_MaxFieldSize == null) {
                this.r_MaxFieldSize = new Integer(this.getMaxFieldSize());
            }
            this.stmt.setMaxFieldSize(n);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public int getMaxRows() throws SQLException {
        this.check_close();
        try {
            return this.stmt.getMaxRows();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public void setMaxRows(int n) throws SQLException {
        this.check_close();
        try {
            if (this.r_MaxRows == null) {
                this.r_MaxRows = new Integer(this.getMaxRows());
            }
            this.stmt.setMaxRows(n);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        this.check_close();
        try {
            if (this.r_EscapeProcessing == null) {
                this.r_EscapeProcessing = new Boolean(true);
            }
            this.stmt.setEscapeProcessing(bl);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public int getQueryTimeout() throws SQLException {
        this.check_close();
        try {
            return this.stmt.getQueryTimeout();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public void setQueryTimeout(int n) throws SQLException {
        this.check_close();
        try {
            if (this.r_QueryTimeout == null) {
                this.r_QueryTimeout = new Integer(this.getQueryTimeout());
            }
            this.stmt.setQueryTimeout(n);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public void cancel() throws SQLException {
        this.check_close();
        try {
            this.stmt.cancel();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        this.check_close();
        try {
            return this.stmt.getWarnings();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public void clearWarnings() throws SQLException {
        this.check_close();
        try {
            this.stmt.clearWarnings();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public void setCursorName(String string) throws SQLException {
        this.check_close();
        try {
            this.stmt.setCursorName(string);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean execute(String string) throws SQLException {
        this.check_close();
        try {
            return this.stmt.execute(string);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public ResultSet getResultSet() throws SQLException {
        this.check_close();
        try {
            ResultSet resultSet = this.stmt.getResultSet();
            if (resultSet != null) {
                return new ResultSetWrapper(this.wconn, this, resultSet);
            }
            return null;
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public int getUpdateCount() throws SQLException {
        this.check_close();
        try {
            return this.stmt.getUpdateCount();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean getMoreResults() throws SQLException {
        this.check_close();
        try {
            return this.stmt.getMoreResults();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public void setFetchDirection(int n) throws SQLException {
        this.check_close();
        try {
            if (this.r_FetchDirection == null) {
                this.r_FetchDirection = new Integer(1000);
            }
            this.stmt.setFetchDirection(n);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public int getFetchDirection() throws SQLException {
        this.check_close();
        try {
            return this.stmt.getFetchDirection();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public void setFetchSize(int n) throws SQLException {
        this.check_close();
        try {
            if (this.r_FetchSize == null) {
                this.r_FetchSize = new Integer(this.getFetchSize());
            }
            this.stmt.setFetchSize(n);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public int getFetchSize() throws SQLException {
        this.check_close();
        try {
            return this.stmt.getFetchSize();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public int getResultSetConcurrency() throws SQLException {
        this.check_close();
        try {
            return this.stmt.getResultSetConcurrency();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public int getResultSetType() throws SQLException {
        this.check_close();
        try {
            return this.stmt.getResultSetType();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public void addBatch(String string) throws SQLException {
        this.check_close();
        try {
            this.stmt.addBatch(string);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public void clearBatch() throws SQLException {
        this.check_close();
        try {
            this.stmt.clearBatch();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public int[] executeBatch() throws SQLException {
        this.check_close();
        try {
            return this.stmt.executeBatch();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public Connection getConnection() throws SQLException {
        this.check_close();
        return this.wconn;
    }

    public boolean getMoreResults(int n) throws SQLException {
        this.check_close();
        try {
            return this.stmt.getMoreResults(n);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        this.check_close();
        try {
            ResultSet resultSet = this.stmt.getGeneratedKeys();
            if (resultSet != null) {
                return new ResultSetWrapper(this.wconn, this, resultSet);
            }
            return null;
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public int executeUpdate(String string, int n) throws SQLException {
        this.check_close();
        try {
            return this.stmt.executeUpdate(string, n);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public int executeUpdate(String string, int[] nArray) throws SQLException {
        this.check_close();
        try {
            return this.stmt.executeUpdate(string, nArray);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        this.check_close();
        try {
            return this.stmt.executeUpdate(string, stringArray);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean execute(String string, int n) throws SQLException {
        this.check_close();
        try {
            return this.stmt.execute(string, n);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean execute(String string, int[] nArray) throws SQLException {
        this.check_close();
        try {
            return this.stmt.execute(string, nArray);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean execute(String string, String[] stringArray) throws SQLException {
        this.check_close();
        try {
            return this.stmt.execute(string, stringArray);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public int getResultSetHoldability() throws SQLException {
        this.check_close();
        try {
            return this.stmt.getResultSetHoldability();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    protected synchronized void check_close() throws SQLException {
        if (this.isClosed) {
            throw new VirtuosoException("The statement is closed.", 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addObjToClose(Object object) {
        HashMap hashMap = this.objsToClose;
        synchronized (hashMap) {
            this.objsToClose.put(object, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeObjFromClose(Object object) {
        HashMap hashMap = this.objsToClose;
        synchronized (hashMap) {
            this.objsToClose.remove(object);
        }
    }
}

