/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jena.driver;

import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.sparql.core.DatasetImpl;
import com.hp.hpl.jena.sparql.engine.http.QueryEngineHTTP;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.util.FileManager;
import java.util.List;
import virtuoso.jena.driver.VirtDataset;
import virtuoso.jena.driver.VirtGraph;
import virtuoso.jena.driver.VirtuosoQueryExecution;

public class VirtuosoQueryExecutionFactory {
    private VirtuosoQueryExecutionFactory() {
    }

    public static VirtuosoQueryExecution create(Query query, VirtGraph virtGraph) {
        VirtuosoQueryExecution virtuosoQueryExecution = new VirtuosoQueryExecution(query, virtGraph);
        return virtuosoQueryExecution;
    }

    public static VirtuosoQueryExecution create(String string, VirtGraph virtGraph) {
        VirtuosoQueryExecution virtuosoQueryExecution = new VirtuosoQueryExecution(string, virtGraph);
        return virtuosoQueryExecution;
    }

    public static QueryExecution create(Query query, Dataset dataset) {
        if (dataset instanceof VirtDataset) {
            VirtuosoQueryExecution virtuosoQueryExecution = new VirtuosoQueryExecution(query.toString(), (VirtGraph)dataset);
            return virtuosoQueryExecution;
        }
        return VirtuosoQueryExecutionFactory.make(query, dataset);
    }

    public static QueryExecution create(String string, Dataset dataset) {
        if (dataset instanceof VirtDataset) {
            VirtuosoQueryExecution virtuosoQueryExecution = new VirtuosoQueryExecution(string, (VirtGraph)dataset);
            return virtuosoQueryExecution;
        }
        return VirtuosoQueryExecutionFactory.make(VirtuosoQueryExecutionFactory.makeQuery(string), dataset);
    }

    public static QueryExecution create(Query query, FileManager fileManager) {
        VirtuosoQueryExecutionFactory.checkArg(query);
        QueryExecution queryExecution = VirtuosoQueryExecutionFactory.make(query);
        if (fileManager != null) {
            queryExecution.setFileManager(fileManager);
        }
        return queryExecution;
    }

    public static QueryExecution create(String string, FileManager fileManager) {
        VirtuosoQueryExecutionFactory.checkArg(string);
        return VirtuosoQueryExecutionFactory.create(VirtuosoQueryExecutionFactory.makeQuery(string), fileManager);
    }

    public static QueryExecution create(Query query, Model model) {
        VirtuosoQueryExecutionFactory.checkArg(query);
        VirtuosoQueryExecutionFactory.checkArg(model);
        if (model.getGraph() instanceof VirtGraph) {
            VirtuosoQueryExecution virtuosoQueryExecution = new VirtuosoQueryExecution(query.toString(), (VirtGraph)model.getGraph());
            return virtuosoQueryExecution;
        }
        return VirtuosoQueryExecutionFactory.make(query, (Dataset)new DatasetImpl(model));
    }

    public static QueryExecution create(String string, Model model) {
        VirtuosoQueryExecutionFactory.checkArg(string);
        VirtuosoQueryExecutionFactory.checkArg(model);
        if (model.getGraph() instanceof VirtGraph) {
            VirtuosoQueryExecution virtuosoQueryExecution = new VirtuosoQueryExecution(string, (VirtGraph)model.getGraph());
            return virtuosoQueryExecution;
        }
        return VirtuosoQueryExecutionFactory.create(VirtuosoQueryExecutionFactory.makeQuery(string), model);
    }

    public static QueryExecution create(Query query, QuerySolution querySolution) {
        VirtuosoQueryExecutionFactory.checkArg(query);
        QueryExecution queryExecution = VirtuosoQueryExecutionFactory.make(query);
        if (querySolution != null) {
            queryExecution.setInitialBinding(querySolution);
        }
        return queryExecution;
    }

    public static QueryExecution create(String string, QuerySolution querySolution) {
        VirtuosoQueryExecutionFactory.checkArg(string);
        return VirtuosoQueryExecutionFactory.create(VirtuosoQueryExecutionFactory.makeQuery(string), querySolution);
    }

    public static QueryExecution create(Query query, Dataset dataset, QuerySolution querySolution) {
        VirtuosoQueryExecutionFactory.checkArg(query);
        QueryExecution queryExecution = VirtuosoQueryExecutionFactory.make(query, dataset);
        if (querySolution != null) {
            queryExecution.setInitialBinding(querySolution);
        }
        return queryExecution;
    }

    public static QueryExecution create(String string, Dataset dataset, QuerySolution querySolution) {
        VirtuosoQueryExecutionFactory.checkArg(string);
        return VirtuosoQueryExecutionFactory.create(VirtuosoQueryExecutionFactory.makeQuery(string), dataset, querySolution);
    }

    public static QueryExecution sparqlService(String string, Query query) {
        VirtuosoQueryExecutionFactory.checkNotNull(string, "URL for service is null");
        VirtuosoQueryExecutionFactory.checkArg(query);
        return VirtuosoQueryExecutionFactory.makeServiceRequest(string, query);
    }

    public static QueryExecution sparqlService(String string, Query query, String string2) {
        VirtuosoQueryExecutionFactory.checkNotNull(string, "URL for service is null");
        VirtuosoQueryExecutionFactory.checkArg(query);
        QueryEngineHTTP queryEngineHTTP = VirtuosoQueryExecutionFactory.makeServiceRequest(string, query);
        queryEngineHTTP.addDefaultGraph(string2);
        return queryEngineHTTP;
    }

    public static QueryExecution sparqlService(String string, Query query, List list, List list2) {
        VirtuosoQueryExecutionFactory.checkNotNull(string, "URL for service is null");
        VirtuosoQueryExecutionFactory.checkArg(query);
        QueryEngineHTTP queryEngineHTTP = VirtuosoQueryExecutionFactory.makeServiceRequest(string, query);
        if (list != null) {
            queryEngineHTTP.setDefaultGraphURIs(list);
        }
        if (list2 != null) {
            queryEngineHTTP.setNamedGraphURIs(list2);
        }
        return queryEngineHTTP;
    }

    private static Query makeQuery(String string) {
        return QueryFactory.create((String)string);
    }

    private static QueryExecution make(Query query) {
        return VirtuosoQueryExecutionFactory.make(query, null);
    }

    private static QueryExecution make(Query query, Dataset dataset) {
        return VirtuosoQueryExecutionFactory.make(query, dataset, null);
    }

    private static QueryExecution make(Query query, Dataset dataset, Context context) {
        return null;
    }

    private static QueryEngineHTTP makeServiceRequest(String string, Query query) {
        return new QueryEngineHTTP(string, query);
    }

    private static void checkNotNull(Object object, String string) {
        if (object == null) {
            throw new IllegalArgumentException(string);
        }
    }

    private static void checkArg(Model model) {
        VirtuosoQueryExecutionFactory.checkNotNull(model, "Model is a null pointer");
    }

    private static void checkArg(String string) {
        VirtuosoQueryExecutionFactory.checkNotNull(string, "Query string is null");
    }

    private static void checkArg(Query query) {
        VirtuosoQueryExecutionFactory.checkNotNull(query, "Query is null");
    }
}

