/*
  Copyright (c) 2014-2015 Montel Laurent <montel@kde.org>

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License, version 2, as
  published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef FOLLOWUPREMINDERAGENT_H
#define FOLLOWUPREMINDERAGENT_H

#include <akonadi/agentbase.h>
class FollowUpReminderManager;
class FollowUpReminderAgent : public Akonadi::AgentBase, public Akonadi::AgentBase::ObserverV3
{
    Q_OBJECT
public:
    explicit FollowUpReminderAgent(const QString &id);
    ~FollowUpReminderAgent();

    void setEnableAgent(bool b);
    bool enabledAgent() const;

    void showConfigureDialog(qlonglong windowId = 0);

    QString printDebugInfo();

public Q_SLOTS:
    void configure( WId windowId );
    void reload();

protected:
    void itemAdded(const Akonadi::Item &item, const Akonadi::Collection &collection);

private:
    FollowUpReminderManager *mManager;
    QTimer *mTimer;
};

#endif // FOLLOWUPREMINDERAGENT_H
