; RUN: llc -verify-machineinstrs < %s -mtriple=aarch64-none-linux-gnu | FileCheck %s

@varfloat = global float 0.0
@vardouble = global double 0.0

define void @testfloat() {
; CHECK: testfloat:
  %val1 = load float* @varfloat

  %val2 = fadd float %val1, %val1
; CHECK: fadd {{s[0-9]+}}, {{s[0-9]+}}, {{s[0-9]+}}

  %val3 = fmul float %val2, %val1
; CHECK: fmul {{s[0-9]+}}, {{s[0-9]+}}, {{s[0-9]+}}

  %val4 = fdiv float %val3, %val1
; CHECK: fdiv {{s[0-9]+}}, {{s[0-9]+}}, {{s[0-9]+}}

  %val5 = fsub float %val4, %val2
; CHECK: fsub {{s[0-9]+}}, {{s[0-9]+}}, {{s[0-9]+}}

  store volatile float %val5, float* @varfloat

; These will be enabled with the implementation of floating-point litpool entries.
  %val6 = fmul float %val1, %val2
  %val7 = fsub float -0.0, %val6
; CHECK: fnmul {{s[0-9]+}}, {{s[0-9]+}}, {{s[0-9]+}}

  store volatile float %val7, float* @varfloat

  ret void
}

define void @testdouble() {
; CHECK: testdouble:
  %val1 = load double* @vardouble

  %val2 = fadd double %val1, %val1
; CHECK: fadd {{d[0-9]+}}, {{d[0-9]+}}, {{d[0-9]+}}

  %val3 = fmul double %val2, %val1
; CHECK: fmul {{d[0-9]+}}, {{d[0-9]+}}, {{d[0-9]+}}

  %val4 = fdiv double %val3, %val1
; CHECK: fdiv {{d[0-9]+}}, {{d[0-9]+}}, {{d[0-9]+}}

  %val5 = fsub double %val4, %val2
; CHECK: fsub {{d[0-9]+}}, {{d[0-9]+}}, {{d[0-9]+}}

  store volatile double %val5, double* @vardouble

; These will be enabled with the implementation of doubleing-point litpool entries.
   %val6 = fmul double %val1, %val2
   %val7 = fsub double -0.0, %val6
; CHECK: fnmul {{d[0-9]+}}, {{d[0-9]+}}, {{d[0-9]+}}

   store volatile double %val7, double* @vardouble

  ret void
}
