/* client functions auto-generated by pidl */

#include "includes.h"
#include <tevent.h>
#include "lib/util/tevent_ntstatus.h"
#include "librpc/gen_ndr/ndr_eventlog.h"
#include "librpc/gen_ndr/ndr_eventlog_c.h"

/* eventlog - client functions generated by pidl */

struct dcerpc_eventlog_ClearEventLogW_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_eventlog_ClearEventLogW_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_eventlog_ClearEventLogW_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct eventlog_ClearEventLogW *r)
{
	struct tevent_req *req;
	struct dcerpc_eventlog_ClearEventLogW_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_eventlog_ClearEventLogW_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_eventlog,
			NDR_EVENTLOG_CLEAREVENTLOGW, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_eventlog_ClearEventLogW_r_done, req);

	return req;
}

static void dcerpc_eventlog_ClearEventLogW_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_eventlog_ClearEventLogW_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_eventlog_ClearEventLogW_r_state *state =
		tevent_req_data(req,
		struct dcerpc_eventlog_ClearEventLogW_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_eventlog_ClearEventLogW_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct eventlog_ClearEventLogW *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_eventlog,
			NDR_EVENTLOG_CLEAREVENTLOGW, mem_ctx, r);

	return status;
}

struct dcerpc_eventlog_ClearEventLogW_state {
	struct eventlog_ClearEventLogW orig;
	struct eventlog_ClearEventLogW tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_eventlog_ClearEventLogW_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_eventlog_ClearEventLogW_send(TALLOC_CTX *mem_ctx,
						       struct tevent_context *ev,
						       struct dcerpc_binding_handle *h,
						       struct policy_handle *_handle /* [in] [ref] */,
						       struct lsa_String *_backupfile /* [in] [unique] */)
{
	struct tevent_req *req;
	struct dcerpc_eventlog_ClearEventLogW_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_eventlog_ClearEventLogW_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.backupfile = _backupfile;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_eventlog_ClearEventLogW_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_eventlog_ClearEventLogW_done, req);
	return req;
}

static void dcerpc_eventlog_ClearEventLogW_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_eventlog_ClearEventLogW_state *state = tevent_req_data(
		req, struct dcerpc_eventlog_ClearEventLogW_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_eventlog_ClearEventLogW_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_eventlog_ClearEventLogW_recv(struct tevent_req *req,
					     TALLOC_CTX *mem_ctx,
					     NTSTATUS *result)
{
	struct dcerpc_eventlog_ClearEventLogW_state *state = tevent_req_data(
		req, struct dcerpc_eventlog_ClearEventLogW_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_eventlog_ClearEventLogW(struct dcerpc_binding_handle *h,
					TALLOC_CTX *mem_ctx,
					struct policy_handle *_handle /* [in] [ref] */,
					struct lsa_String *_backupfile /* [in] [unique] */,
					NTSTATUS *result)
{
	struct eventlog_ClearEventLogW r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.backupfile = _backupfile;

	status = dcerpc_eventlog_ClearEventLogW_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_eventlog_BackupEventLogW_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_eventlog_BackupEventLogW_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_eventlog_BackupEventLogW_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct eventlog_BackupEventLogW *r)
{
	struct tevent_req *req;
	struct dcerpc_eventlog_BackupEventLogW_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_eventlog_BackupEventLogW_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_eventlog,
			NDR_EVENTLOG_BACKUPEVENTLOGW, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_eventlog_BackupEventLogW_r_done, req);

	return req;
}

static void dcerpc_eventlog_BackupEventLogW_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_eventlog_BackupEventLogW_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_eventlog_BackupEventLogW_r_state *state =
		tevent_req_data(req,
		struct dcerpc_eventlog_BackupEventLogW_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_eventlog_BackupEventLogW_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct eventlog_BackupEventLogW *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_eventlog,
			NDR_EVENTLOG_BACKUPEVENTLOGW, mem_ctx, r);

	return status;
}

struct dcerpc_eventlog_BackupEventLogW_state {
	struct eventlog_BackupEventLogW orig;
	struct eventlog_BackupEventLogW tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_eventlog_BackupEventLogW_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_eventlog_BackupEventLogW_send(TALLOC_CTX *mem_ctx,
							struct tevent_context *ev,
							struct dcerpc_binding_handle *h,
							struct policy_handle *_handle /* [in] [ref] */,
							struct lsa_String *_backup_filename /* [in] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_eventlog_BackupEventLogW_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_eventlog_BackupEventLogW_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.backup_filename = _backup_filename;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_eventlog_BackupEventLogW_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_eventlog_BackupEventLogW_done, req);
	return req;
}

static void dcerpc_eventlog_BackupEventLogW_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_eventlog_BackupEventLogW_state *state = tevent_req_data(
		req, struct dcerpc_eventlog_BackupEventLogW_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_eventlog_BackupEventLogW_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_eventlog_BackupEventLogW_recv(struct tevent_req *req,
					      TALLOC_CTX *mem_ctx,
					      NTSTATUS *result)
{
	struct dcerpc_eventlog_BackupEventLogW_state *state = tevent_req_data(
		req, struct dcerpc_eventlog_BackupEventLogW_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_eventlog_BackupEventLogW(struct dcerpc_binding_handle *h,
					 TALLOC_CTX *mem_ctx,
					 struct policy_handle *_handle /* [in] [ref] */,
					 struct lsa_String *_backup_filename /* [in] [ref] */,
					 NTSTATUS *result)
{
	struct eventlog_BackupEventLogW r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.backup_filename = _backup_filename;

	status = dcerpc_eventlog_BackupEventLogW_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_eventlog_CloseEventLog_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_eventlog_CloseEventLog_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_eventlog_CloseEventLog_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct eventlog_CloseEventLog *r)
{
	struct tevent_req *req;
	struct dcerpc_eventlog_CloseEventLog_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_eventlog_CloseEventLog_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_eventlog,
			NDR_EVENTLOG_CLOSEEVENTLOG, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_eventlog_CloseEventLog_r_done, req);

	return req;
}

static void dcerpc_eventlog_CloseEventLog_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_eventlog_CloseEventLog_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_eventlog_CloseEventLog_r_state *state =
		tevent_req_data(req,
		struct dcerpc_eventlog_CloseEventLog_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_eventlog_CloseEventLog_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct eventlog_CloseEventLog *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_eventlog,
			NDR_EVENTLOG_CLOSEEVENTLOG, mem_ctx, r);

	return status;
}

struct dcerpc_eventlog_CloseEventLog_state {
	struct eventlog_CloseEventLog orig;
	struct eventlog_CloseEventLog tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_eventlog_CloseEventLog_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_eventlog_CloseEventLog_send(TALLOC_CTX *mem_ctx,
						      struct tevent_context *ev,
						      struct dcerpc_binding_handle *h,
						      struct policy_handle *_handle /* [in,out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_eventlog_CloseEventLog_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_eventlog_CloseEventLog_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;

	/* Out parameters */
	state->orig.out.handle = _handle;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_eventlog_CloseEventLog_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_eventlog_CloseEventLog_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_eventlog_CloseEventLog_done, req);
	return req;
}

static void dcerpc_eventlog_CloseEventLog_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_eventlog_CloseEventLog_state *state = tevent_req_data(
		req, struct dcerpc_eventlog_CloseEventLog_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_eventlog_CloseEventLog_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.handle = *state->tmp.out.handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_eventlog_CloseEventLog_recv(struct tevent_req *req,
					    TALLOC_CTX *mem_ctx,
					    NTSTATUS *result)
{
	struct dcerpc_eventlog_CloseEventLog_state *state = tevent_req_data(
		req, struct dcerpc_eventlog_CloseEventLog_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_eventlog_CloseEventLog(struct dcerpc_binding_handle *h,
				       TALLOC_CTX *mem_ctx,
				       struct policy_handle *_handle /* [in,out] [ref] */,
				       NTSTATUS *result)
{
	struct eventlog_CloseEventLog r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;

	status = dcerpc_eventlog_CloseEventLog_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_handle = *r.out.handle;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_eventlog_DeregisterEventSource_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_eventlog_DeregisterEventSource_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_eventlog_DeregisterEventSource_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct eventlog_DeregisterEventSource *r)
{
	struct tevent_req *req;
	struct dcerpc_eventlog_DeregisterEventSource_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_eventlog_DeregisterEventSource_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_eventlog,
			NDR_EVENTLOG_DEREGISTEREVENTSOURCE, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_eventlog_DeregisterEventSource_r_done, req);

	return req;
}

static void dcerpc_eventlog_DeregisterEventSource_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_eventlog_DeregisterEventSource_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_eventlog_DeregisterEventSource_r_state *state =
		tevent_req_data(req,
		struct dcerpc_eventlog_DeregisterEventSource_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_eventlog_DeregisterEventSource_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct eventlog_DeregisterEventSource *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_eventlog,
			NDR_EVENTLOG_DEREGISTEREVENTSOURCE, mem_ctx, r);

	return status;
}

struct dcerpc_eventlog_DeregisterEventSource_state {
	struct eventlog_DeregisterEventSource orig;
	struct eventlog_DeregisterEventSource tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_eventlog_DeregisterEventSource_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_eventlog_DeregisterEventSource_send(TALLOC_CTX *mem_ctx,
							      struct tevent_context *ev,
							      struct dcerpc_binding_handle *h,
							      struct policy_handle *_handle /* [in,out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_eventlog_DeregisterEventSource_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_eventlog_DeregisterEventSource_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;

	/* Out parameters */
	state->orig.out.handle = _handle;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_eventlog_DeregisterEventSource_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_eventlog_DeregisterEventSource_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_eventlog_DeregisterEventSource_done, req);
	return req;
}

static void dcerpc_eventlog_DeregisterEventSource_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_eventlog_DeregisterEventSource_state *state = tevent_req_data(
		req, struct dcerpc_eventlog_DeregisterEventSource_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_eventlog_DeregisterEventSource_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.handle = *state->tmp.out.handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_eventlog_DeregisterEventSource_recv(struct tevent_req *req,
						    TALLOC_CTX *mem_ctx,
						    NTSTATUS *result)
{
	struct dcerpc_eventlog_DeregisterEventSource_state *state = tevent_req_data(
		req, struct dcerpc_eventlog_DeregisterEventSource_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_eventlog_DeregisterEventSource(struct dcerpc_binding_handle *h,
					       TALLOC_CTX *mem_ctx,
					       struct policy_handle *_handle /* [in,out] [ref] */,
					       NTSTATUS *result)
{
	struct eventlog_DeregisterEventSource r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;

	status = dcerpc_eventlog_DeregisterEventSource_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_handle = *r.out.handle;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_eventlog_GetNumRecords_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_eventlog_GetNumRecords_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_eventlog_GetNumRecords_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct eventlog_GetNumRecords *r)
{
	struct tevent_req *req;
	struct dcerpc_eventlog_GetNumRecords_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_eventlog_GetNumRecords_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_eventlog,
			NDR_EVENTLOG_GETNUMRECORDS, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_eventlog_GetNumRecords_r_done, req);

	return req;
}

static void dcerpc_eventlog_GetNumRecords_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_eventlog_GetNumRecords_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_eventlog_GetNumRecords_r_state *state =
		tevent_req_data(req,
		struct dcerpc_eventlog_GetNumRecords_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_eventlog_GetNumRecords_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct eventlog_GetNumRecords *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_eventlog,
			NDR_EVENTLOG_GETNUMRECORDS, mem_ctx, r);

	return status;
}

struct dcerpc_eventlog_GetNumRecords_state {
	struct eventlog_GetNumRecords orig;
	struct eventlog_GetNumRecords tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_eventlog_GetNumRecords_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_eventlog_GetNumRecords_send(TALLOC_CTX *mem_ctx,
						      struct tevent_context *ev,
						      struct dcerpc_binding_handle *h,
						      struct policy_handle *_handle /* [in] [ref] */,
						      uint32_t *_number /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_eventlog_GetNumRecords_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_eventlog_GetNumRecords_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;

	/* Out parameters */
	state->orig.out.number = _number;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_eventlog_GetNumRecords_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_eventlog_GetNumRecords_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_eventlog_GetNumRecords_done, req);
	return req;
}

static void dcerpc_eventlog_GetNumRecords_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_eventlog_GetNumRecords_state *state = tevent_req_data(
		req, struct dcerpc_eventlog_GetNumRecords_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_eventlog_GetNumRecords_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.number = *state->tmp.out.number;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_eventlog_GetNumRecords_recv(struct tevent_req *req,
					    TALLOC_CTX *mem_ctx,
					    NTSTATUS *result)
{
	struct dcerpc_eventlog_GetNumRecords_state *state = tevent_req_data(
		req, struct dcerpc_eventlog_GetNumRecords_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_eventlog_GetNumRecords(struct dcerpc_binding_handle *h,
				       TALLOC_CTX *mem_ctx,
				       struct policy_handle *_handle /* [in] [ref] */,
				       uint32_t *_number /* [out] [ref] */,
				       NTSTATUS *result)
{
	struct eventlog_GetNumRecords r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;

	status = dcerpc_eventlog_GetNumRecords_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_number = *r.out.number;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_eventlog_GetOldestRecord_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_eventlog_GetOldestRecord_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_eventlog_GetOldestRecord_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct eventlog_GetOldestRecord *r)
{
	struct tevent_req *req;
	struct dcerpc_eventlog_GetOldestRecord_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_eventlog_GetOldestRecord_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_eventlog,
			NDR_EVENTLOG_GETOLDESTRECORD, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_eventlog_GetOldestRecord_r_done, req);

	return req;
}

static void dcerpc_eventlog_GetOldestRecord_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_eventlog_GetOldestRecord_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_eventlog_GetOldestRecord_r_state *state =
		tevent_req_data(req,
		struct dcerpc_eventlog_GetOldestRecord_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_eventlog_GetOldestRecord_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct eventlog_GetOldestRecord *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_eventlog,
			NDR_EVENTLOG_GETOLDESTRECORD, mem_ctx, r);

	return status;
}

struct dcerpc_eventlog_GetOldestRecord_state {
	struct eventlog_GetOldestRecord orig;
	struct eventlog_GetOldestRecord tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_eventlog_GetOldestRecord_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_eventlog_GetOldestRecord_send(TALLOC_CTX *mem_ctx,
							struct tevent_context *ev,
							struct dcerpc_binding_handle *h,
							struct policy_handle *_handle /* [in] [ref] */,
							uint32_t *_oldest_entry /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_eventlog_GetOldestRecord_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_eventlog_GetOldestRecord_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;

	/* Out parameters */
	state->orig.out.oldest_entry = _oldest_entry;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_eventlog_GetOldestRecord_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_eventlog_GetOldestRecord_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_eventlog_GetOldestRecord_done, req);
	return req;
}

static void dcerpc_eventlog_GetOldestRecord_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_eventlog_GetOldestRecord_state *state = tevent_req_data(
		req, struct dcerpc_eventlog_GetOldestRecord_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_eventlog_GetOldestRecord_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.oldest_entry = *state->tmp.out.oldest_entry;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_eventlog_GetOldestRecord_recv(struct tevent_req *req,
					      TALLOC_CTX *mem_ctx,
					      NTSTATUS *result)
{
	struct dcerpc_eventlog_GetOldestRecord_state *state = tevent_req_data(
		req, struct dcerpc_eventlog_GetOldestRecord_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_eventlog_GetOldestRecord(struct dcerpc_binding_handle *h,
					 TALLOC_CTX *mem_ctx,
					 struct policy_handle *_handle /* [in] [ref] */,
					 uint32_t *_oldest_entry /* [out] [ref] */,
					 NTSTATUS *result)
{
	struct eventlog_GetOldestRecord r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;

	status = dcerpc_eventlog_GetOldestRecord_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_oldest_entry = *r.out.oldest_entry;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_eventlog_OpenEventLogW_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_eventlog_OpenEventLogW_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_eventlog_OpenEventLogW_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct eventlog_OpenEventLogW *r)
{
	struct tevent_req *req;
	struct dcerpc_eventlog_OpenEventLogW_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_eventlog_OpenEventLogW_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_eventlog,
			NDR_EVENTLOG_OPENEVENTLOGW, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_eventlog_OpenEventLogW_r_done, req);

	return req;
}

static void dcerpc_eventlog_OpenEventLogW_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_eventlog_OpenEventLogW_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_eventlog_OpenEventLogW_r_state *state =
		tevent_req_data(req,
		struct dcerpc_eventlog_OpenEventLogW_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_eventlog_OpenEventLogW_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct eventlog_OpenEventLogW *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_eventlog,
			NDR_EVENTLOG_OPENEVENTLOGW, mem_ctx, r);

	return status;
}

struct dcerpc_eventlog_OpenEventLogW_state {
	struct eventlog_OpenEventLogW orig;
	struct eventlog_OpenEventLogW tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_eventlog_OpenEventLogW_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_eventlog_OpenEventLogW_send(TALLOC_CTX *mem_ctx,
						      struct tevent_context *ev,
						      struct dcerpc_binding_handle *h,
						      struct eventlog_OpenUnknown0 *_unknown0 /* [in] [unique] */,
						      struct lsa_String *_logname /* [in] [ref] */,
						      struct lsa_String *_servername /* [in] [ref] */,
						      uint32_t _major_version /* [in]  */,
						      uint32_t _minor_version /* [in]  */,
						      struct policy_handle *_handle /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_eventlog_OpenEventLogW_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_eventlog_OpenEventLogW_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.unknown0 = _unknown0;
	state->orig.in.logname = _logname;
	state->orig.in.servername = _servername;
	state->orig.in.major_version = _major_version;
	state->orig.in.minor_version = _minor_version;

	/* Out parameters */
	state->orig.out.handle = _handle;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_eventlog_OpenEventLogW_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_eventlog_OpenEventLogW_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_eventlog_OpenEventLogW_done, req);
	return req;
}

static void dcerpc_eventlog_OpenEventLogW_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_eventlog_OpenEventLogW_state *state = tevent_req_data(
		req, struct dcerpc_eventlog_OpenEventLogW_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_eventlog_OpenEventLogW_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.handle = *state->tmp.out.handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_eventlog_OpenEventLogW_recv(struct tevent_req *req,
					    TALLOC_CTX *mem_ctx,
					    NTSTATUS *result)
{
	struct dcerpc_eventlog_OpenEventLogW_state *state = tevent_req_data(
		req, struct dcerpc_eventlog_OpenEventLogW_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_eventlog_OpenEventLogW(struct dcerpc_binding_handle *h,
				       TALLOC_CTX *mem_ctx,
				       struct eventlog_OpenUnknown0 *_unknown0 /* [in] [unique] */,
				       struct lsa_String *_logname /* [in] [ref] */,
				       struct lsa_String *_servername /* [in] [ref] */,
				       uint32_t _major_version /* [in]  */,
				       uint32_t _minor_version /* [in]  */,
				       struct policy_handle *_handle /* [out] [ref] */,
				       NTSTATUS *result)
{
	struct eventlog_OpenEventLogW r;
	NTSTATUS status;

	/* In parameters */
	r.in.unknown0 = _unknown0;
	r.in.logname = _logname;
	r.in.servername = _servername;
	r.in.major_version = _major_version;
	r.in.minor_version = _minor_version;

	status = dcerpc_eventlog_OpenEventLogW_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_handle = *r.out.handle;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_eventlog_RegisterEventSourceW_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_eventlog_RegisterEventSourceW_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_eventlog_RegisterEventSourceW_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct eventlog_RegisterEventSourceW *r)
{
	struct tevent_req *req;
	struct dcerpc_eventlog_RegisterEventSourceW_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_eventlog_RegisterEventSourceW_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_eventlog,
			NDR_EVENTLOG_REGISTEREVENTSOURCEW, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_eventlog_RegisterEventSourceW_r_done, req);

	return req;
}

static void dcerpc_eventlog_RegisterEventSourceW_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_eventlog_RegisterEventSourceW_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_eventlog_RegisterEventSourceW_r_state *state =
		tevent_req_data(req,
		struct dcerpc_eventlog_RegisterEventSourceW_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_eventlog_RegisterEventSourceW_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct eventlog_RegisterEventSourceW *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_eventlog,
			NDR_EVENTLOG_REGISTEREVENTSOURCEW, mem_ctx, r);

	return status;
}

struct dcerpc_eventlog_RegisterEventSourceW_state {
	struct eventlog_RegisterEventSourceW orig;
	struct eventlog_RegisterEventSourceW tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_eventlog_RegisterEventSourceW_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_eventlog_RegisterEventSourceW_send(TALLOC_CTX *mem_ctx,
							     struct tevent_context *ev,
							     struct dcerpc_binding_handle *h,
							     struct eventlog_OpenUnknown0 *_unknown0 /* [in] [unique] */,
							     struct lsa_String *_module_name /* [in] [ref] */,
							     struct lsa_String *_reg_module_name /* [in] [ref] */,
							     uint32_t _major_version /* [in]  */,
							     uint32_t _minor_version /* [in]  */,
							     struct policy_handle *_log_handle /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_eventlog_RegisterEventSourceW_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_eventlog_RegisterEventSourceW_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.unknown0 = _unknown0;
	state->orig.in.module_name = _module_name;
	state->orig.in.reg_module_name = _reg_module_name;
	state->orig.in.major_version = _major_version;
	state->orig.in.minor_version = _minor_version;

	/* Out parameters */
	state->orig.out.log_handle = _log_handle;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_eventlog_RegisterEventSourceW_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_eventlog_RegisterEventSourceW_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_eventlog_RegisterEventSourceW_done, req);
	return req;
}

static void dcerpc_eventlog_RegisterEventSourceW_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_eventlog_RegisterEventSourceW_state *state = tevent_req_data(
		req, struct dcerpc_eventlog_RegisterEventSourceW_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_eventlog_RegisterEventSourceW_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.log_handle = *state->tmp.out.log_handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_eventlog_RegisterEventSourceW_recv(struct tevent_req *req,
						   TALLOC_CTX *mem_ctx,
						   NTSTATUS *result)
{
	struct dcerpc_eventlog_RegisterEventSourceW_state *state = tevent_req_data(
		req, struct dcerpc_eventlog_RegisterEventSourceW_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_eventlog_RegisterEventSourceW(struct dcerpc_binding_handle *h,
					      TALLOC_CTX *mem_ctx,
					      struct eventlog_OpenUnknown0 *_unknown0 /* [in] [unique] */,
					      struct lsa_String *_module_name /* [in] [ref] */,
					      struct lsa_String *_reg_module_name /* [in] [ref] */,
					      uint32_t _major_version /* [in]  */,
					      uint32_t _minor_version /* [in]  */,
					      struct policy_handle *_log_handle /* [out] [ref] */,
					      NTSTATUS *result)
{
	struct eventlog_RegisterEventSourceW r;
	NTSTATUS status;

	/* In parameters */
	r.in.unknown0 = _unknown0;
	r.in.module_name = _module_name;
	r.in.reg_module_name = _reg_module_name;
	r.in.major_version = _major_version;
	r.in.minor_version = _minor_version;

	status = dcerpc_eventlog_RegisterEventSourceW_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_log_handle = *r.out.log_handle;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_eventlog_OpenBackupEventLogW_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_eventlog_OpenBackupEventLogW_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_eventlog_OpenBackupEventLogW_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct eventlog_OpenBackupEventLogW *r)
{
	struct tevent_req *req;
	struct dcerpc_eventlog_OpenBackupEventLogW_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_eventlog_OpenBackupEventLogW_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_eventlog,
			NDR_EVENTLOG_OPENBACKUPEVENTLOGW, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_eventlog_OpenBackupEventLogW_r_done, req);

	return req;
}

static void dcerpc_eventlog_OpenBackupEventLogW_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_eventlog_OpenBackupEventLogW_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_eventlog_OpenBackupEventLogW_r_state *state =
		tevent_req_data(req,
		struct dcerpc_eventlog_OpenBackupEventLogW_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_eventlog_OpenBackupEventLogW_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct eventlog_OpenBackupEventLogW *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_eventlog,
			NDR_EVENTLOG_OPENBACKUPEVENTLOGW, mem_ctx, r);

	return status;
}

struct dcerpc_eventlog_OpenBackupEventLogW_state {
	struct eventlog_OpenBackupEventLogW orig;
	struct eventlog_OpenBackupEventLogW tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_eventlog_OpenBackupEventLogW_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_eventlog_OpenBackupEventLogW_send(TALLOC_CTX *mem_ctx,
							    struct tevent_context *ev,
							    struct dcerpc_binding_handle *h,
							    struct eventlog_OpenUnknown0 *_unknown0 /* [in] [unique] */,
							    struct lsa_String *_backup_logname /* [in] [ref] */,
							    uint32_t _major_version /* [in]  */,
							    uint32_t _minor_version /* [in]  */,
							    struct policy_handle *_handle /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_eventlog_OpenBackupEventLogW_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_eventlog_OpenBackupEventLogW_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.unknown0 = _unknown0;
	state->orig.in.backup_logname = _backup_logname;
	state->orig.in.major_version = _major_version;
	state->orig.in.minor_version = _minor_version;

	/* Out parameters */
	state->orig.out.handle = _handle;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_eventlog_OpenBackupEventLogW_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_eventlog_OpenBackupEventLogW_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_eventlog_OpenBackupEventLogW_done, req);
	return req;
}

static void dcerpc_eventlog_OpenBackupEventLogW_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_eventlog_OpenBackupEventLogW_state *state = tevent_req_data(
		req, struct dcerpc_eventlog_OpenBackupEventLogW_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_eventlog_OpenBackupEventLogW_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.handle = *state->tmp.out.handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_eventlog_OpenBackupEventLogW_recv(struct tevent_req *req,
						  TALLOC_CTX *mem_ctx,
						  NTSTATUS *result)
{
	struct dcerpc_eventlog_OpenBackupEventLogW_state *state = tevent_req_data(
		req, struct dcerpc_eventlog_OpenBackupEventLogW_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_eventlog_OpenBackupEventLogW(struct dcerpc_binding_handle *h,
					     TALLOC_CTX *mem_ctx,
					     struct eventlog_OpenUnknown0 *_unknown0 /* [in] [unique] */,
					     struct lsa_String *_backup_logname /* [in] [ref] */,
					     uint32_t _major_version /* [in]  */,
					     uint32_t _minor_version /* [in]  */,
					     struct policy_handle *_handle /* [out] [ref] */,
					     NTSTATUS *result)
{
	struct eventlog_OpenBackupEventLogW r;
	NTSTATUS status;

	/* In parameters */
	r.in.unknown0 = _unknown0;
	r.in.backup_logname = _backup_logname;
	r.in.major_version = _major_version;
	r.in.minor_version = _minor_version;

	status = dcerpc_eventlog_OpenBackupEventLogW_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_handle = *r.out.handle;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_eventlog_ReadEventLogW_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_eventlog_ReadEventLogW_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_eventlog_ReadEventLogW_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct eventlog_ReadEventLogW *r)
{
	struct tevent_req *req;
	struct dcerpc_eventlog_ReadEventLogW_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_eventlog_ReadEventLogW_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_eventlog,
			NDR_EVENTLOG_READEVENTLOGW, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_eventlog_ReadEventLogW_r_done, req);

	return req;
}

static void dcerpc_eventlog_ReadEventLogW_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_eventlog_ReadEventLogW_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_eventlog_ReadEventLogW_r_state *state =
		tevent_req_data(req,
		struct dcerpc_eventlog_ReadEventLogW_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_eventlog_ReadEventLogW_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct eventlog_ReadEventLogW *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_eventlog,
			NDR_EVENTLOG_READEVENTLOGW, mem_ctx, r);

	return status;
}

struct dcerpc_eventlog_ReadEventLogW_state {
	struct eventlog_ReadEventLogW orig;
	struct eventlog_ReadEventLogW tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_eventlog_ReadEventLogW_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_eventlog_ReadEventLogW_send(TALLOC_CTX *mem_ctx,
						      struct tevent_context *ev,
						      struct dcerpc_binding_handle *h,
						      struct policy_handle *_handle /* [in] [ref] */,
						      uint32_t _flags /* [in]  */,
						      uint32_t _offset /* [in]  */,
						      uint32_t _number_of_bytes /* [in] [range(0,0x7FFFF)] */,
						      uint8_t *_data /* [out] [ref,size_is(number_of_bytes)] */,
						      uint32_t *_sent_size /* [out] [ref] */,
						      uint32_t *_real_size /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_eventlog_ReadEventLogW_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_eventlog_ReadEventLogW_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.flags = _flags;
	state->orig.in.offset = _offset;
	state->orig.in.number_of_bytes = _number_of_bytes;

	/* Out parameters */
	state->orig.out.data = _data;
	state->orig.out.sent_size = _sent_size;
	state->orig.out.real_size = _real_size;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_eventlog_ReadEventLogW_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_eventlog_ReadEventLogW_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_eventlog_ReadEventLogW_done, req);
	return req;
}

static void dcerpc_eventlog_ReadEventLogW_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_eventlog_ReadEventLogW_state *state = tevent_req_data(
		req, struct dcerpc_eventlog_ReadEventLogW_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_eventlog_ReadEventLogW_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	{
		size_t _copy_len_data;
		_copy_len_data = state->tmp.in.number_of_bytes;
		memcpy(state->orig.out.data, state->tmp.out.data, _copy_len_data * sizeof(*state->orig.out.data));
	}
	*state->orig.out.sent_size = *state->tmp.out.sent_size;
	*state->orig.out.real_size = *state->tmp.out.real_size;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_eventlog_ReadEventLogW_recv(struct tevent_req *req,
					    TALLOC_CTX *mem_ctx,
					    NTSTATUS *result)
{
	struct dcerpc_eventlog_ReadEventLogW_state *state = tevent_req_data(
		req, struct dcerpc_eventlog_ReadEventLogW_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_eventlog_ReadEventLogW(struct dcerpc_binding_handle *h,
				       TALLOC_CTX *mem_ctx,
				       struct policy_handle *_handle /* [in] [ref] */,
				       uint32_t _flags /* [in]  */,
				       uint32_t _offset /* [in]  */,
				       uint32_t _number_of_bytes /* [in] [range(0,0x7FFFF)] */,
				       uint8_t *_data /* [out] [ref,size_is(number_of_bytes)] */,
				       uint32_t *_sent_size /* [out] [ref] */,
				       uint32_t *_real_size /* [out] [ref] */,
				       NTSTATUS *result)
{
	struct eventlog_ReadEventLogW r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.flags = _flags;
	r.in.offset = _offset;
	r.in.number_of_bytes = _number_of_bytes;

	status = dcerpc_eventlog_ReadEventLogW_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	{
		size_t _copy_len_data;
		_copy_len_data = r.in.number_of_bytes;
		memcpy(_data, r.out.data, _copy_len_data * sizeof(*_data));
	}
	*_sent_size = *r.out.sent_size;
	*_real_size = *r.out.real_size;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_eventlog_ReportEventW_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_eventlog_ReportEventW_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_eventlog_ReportEventW_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct eventlog_ReportEventW *r)
{
	struct tevent_req *req;
	struct dcerpc_eventlog_ReportEventW_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_eventlog_ReportEventW_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_eventlog,
			NDR_EVENTLOG_REPORTEVENTW, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_eventlog_ReportEventW_r_done, req);

	return req;
}

static void dcerpc_eventlog_ReportEventW_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_eventlog_ReportEventW_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_eventlog_ReportEventW_r_state *state =
		tevent_req_data(req,
		struct dcerpc_eventlog_ReportEventW_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_eventlog_ReportEventW_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct eventlog_ReportEventW *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_eventlog,
			NDR_EVENTLOG_REPORTEVENTW, mem_ctx, r);

	return status;
}

struct dcerpc_eventlog_ReportEventW_state {
	struct eventlog_ReportEventW orig;
	struct eventlog_ReportEventW tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_eventlog_ReportEventW_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_eventlog_ReportEventW_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct dcerpc_binding_handle *h,
						     struct policy_handle *_handle /* [in] [ref] */,
						     time_t _timestamp /* [in]  */,
						     enum eventlogEventTypes _event_type /* [in]  */,
						     uint16_t _event_category /* [in]  */,
						     uint32_t _event_id /* [in]  */,
						     uint16_t _num_of_strings /* [in] [range(0,256)] */,
						     uint32_t _data_size /* [in] [range(0,0x3FFFF)] */,
						     struct lsa_String *_servername /* [in] [ref] */,
						     struct dom_sid *_user_sid /* [in] [unique] */,
						     struct lsa_String **_strings /* [in] [unique,size_is(num_of_strings)] */,
						     uint8_t *_data /* [in] [unique,size_is(data_size)] */,
						     uint16_t _flags /* [in]  */,
						     uint32_t *_record_number /* [in,out] [unique] */,
						     time_t *_time_written /* [in,out] [unique] */)
{
	struct tevent_req *req;
	struct dcerpc_eventlog_ReportEventW_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_eventlog_ReportEventW_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.timestamp = _timestamp;
	state->orig.in.event_type = _event_type;
	state->orig.in.event_category = _event_category;
	state->orig.in.event_id = _event_id;
	state->orig.in.num_of_strings = _num_of_strings;
	state->orig.in.data_size = _data_size;
	state->orig.in.servername = _servername;
	state->orig.in.user_sid = _user_sid;
	state->orig.in.strings = _strings;
	state->orig.in.data = _data;
	state->orig.in.flags = _flags;
	state->orig.in.record_number = _record_number;
	state->orig.in.time_written = _time_written;

	/* Out parameters */
	state->orig.out.record_number = _record_number;
	state->orig.out.time_written = _time_written;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_eventlog_ReportEventW_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_eventlog_ReportEventW_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_eventlog_ReportEventW_done, req);
	return req;
}

static void dcerpc_eventlog_ReportEventW_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_eventlog_ReportEventW_state *state = tevent_req_data(
		req, struct dcerpc_eventlog_ReportEventW_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_eventlog_ReportEventW_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	if (state->orig.out.record_number && state->tmp.out.record_number) {
		*state->orig.out.record_number = *state->tmp.out.record_number;
	}
	if (state->orig.out.time_written && state->tmp.out.time_written) {
		*state->orig.out.time_written = *state->tmp.out.time_written;
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_eventlog_ReportEventW_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx,
					   NTSTATUS *result)
{
	struct dcerpc_eventlog_ReportEventW_state *state = tevent_req_data(
		req, struct dcerpc_eventlog_ReportEventW_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_eventlog_ReportEventW(struct dcerpc_binding_handle *h,
				      TALLOC_CTX *mem_ctx,
				      struct policy_handle *_handle /* [in] [ref] */,
				      time_t _timestamp /* [in]  */,
				      enum eventlogEventTypes _event_type /* [in]  */,
				      uint16_t _event_category /* [in]  */,
				      uint32_t _event_id /* [in]  */,
				      uint16_t _num_of_strings /* [in] [range(0,256)] */,
				      uint32_t _data_size /* [in] [range(0,0x3FFFF)] */,
				      struct lsa_String *_servername /* [in] [ref] */,
				      struct dom_sid *_user_sid /* [in] [unique] */,
				      struct lsa_String **_strings /* [in] [unique,size_is(num_of_strings)] */,
				      uint8_t *_data /* [in] [unique,size_is(data_size)] */,
				      uint16_t _flags /* [in]  */,
				      uint32_t *_record_number /* [in,out] [unique] */,
				      time_t *_time_written /* [in,out] [unique] */,
				      NTSTATUS *result)
{
	struct eventlog_ReportEventW r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.timestamp = _timestamp;
	r.in.event_type = _event_type;
	r.in.event_category = _event_category;
	r.in.event_id = _event_id;
	r.in.num_of_strings = _num_of_strings;
	r.in.data_size = _data_size;
	r.in.servername = _servername;
	r.in.user_sid = _user_sid;
	r.in.strings = _strings;
	r.in.data = _data;
	r.in.flags = _flags;
	r.in.record_number = _record_number;
	r.in.time_written = _time_written;

	status = dcerpc_eventlog_ReportEventW_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	if (_record_number && r.out.record_number) {
		*_record_number = *r.out.record_number;
	}
	if (_time_written && r.out.time_written) {
		*_time_written = *r.out.time_written;
	}

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_eventlog_GetLogInformation_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_eventlog_GetLogInformation_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_eventlog_GetLogInformation_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct eventlog_GetLogInformation *r)
{
	struct tevent_req *req;
	struct dcerpc_eventlog_GetLogInformation_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_eventlog_GetLogInformation_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_eventlog,
			NDR_EVENTLOG_GETLOGINFORMATION, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_eventlog_GetLogInformation_r_done, req);

	return req;
}

static void dcerpc_eventlog_GetLogInformation_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_eventlog_GetLogInformation_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_eventlog_GetLogInformation_r_state *state =
		tevent_req_data(req,
		struct dcerpc_eventlog_GetLogInformation_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_eventlog_GetLogInformation_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct eventlog_GetLogInformation *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_eventlog,
			NDR_EVENTLOG_GETLOGINFORMATION, mem_ctx, r);

	return status;
}

struct dcerpc_eventlog_GetLogInformation_state {
	struct eventlog_GetLogInformation orig;
	struct eventlog_GetLogInformation tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_eventlog_GetLogInformation_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_eventlog_GetLogInformation_send(TALLOC_CTX *mem_ctx,
							  struct tevent_context *ev,
							  struct dcerpc_binding_handle *h,
							  struct policy_handle *_handle /* [in] [ref] */,
							  uint32_t _level /* [in]  */,
							  uint8_t *_buffer /* [out] [ref,size_is(buf_size)] */,
							  uint32_t _buf_size /* [in] [range(0,1024)] */,
							  uint32_t *_bytes_needed /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_eventlog_GetLogInformation_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_eventlog_GetLogInformation_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.level = _level;
	state->orig.in.buf_size = _buf_size;

	/* Out parameters */
	state->orig.out.buffer = _buffer;
	state->orig.out.bytes_needed = _bytes_needed;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_eventlog_GetLogInformation_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_eventlog_GetLogInformation_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_eventlog_GetLogInformation_done, req);
	return req;
}

static void dcerpc_eventlog_GetLogInformation_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_eventlog_GetLogInformation_state *state = tevent_req_data(
		req, struct dcerpc_eventlog_GetLogInformation_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_eventlog_GetLogInformation_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	{
		size_t _copy_len_buffer;
		_copy_len_buffer = state->tmp.in.buf_size;
		memcpy(state->orig.out.buffer, state->tmp.out.buffer, _copy_len_buffer * sizeof(*state->orig.out.buffer));
	}
	*state->orig.out.bytes_needed = *state->tmp.out.bytes_needed;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_eventlog_GetLogInformation_recv(struct tevent_req *req,
						TALLOC_CTX *mem_ctx,
						NTSTATUS *result)
{
	struct dcerpc_eventlog_GetLogInformation_state *state = tevent_req_data(
		req, struct dcerpc_eventlog_GetLogInformation_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_eventlog_GetLogInformation(struct dcerpc_binding_handle *h,
					   TALLOC_CTX *mem_ctx,
					   struct policy_handle *_handle /* [in] [ref] */,
					   uint32_t _level /* [in]  */,
					   uint8_t *_buffer /* [out] [ref,size_is(buf_size)] */,
					   uint32_t _buf_size /* [in] [range(0,1024)] */,
					   uint32_t *_bytes_needed /* [out] [ref] */,
					   NTSTATUS *result)
{
	struct eventlog_GetLogInformation r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.level = _level;
	r.in.buf_size = _buf_size;

	status = dcerpc_eventlog_GetLogInformation_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	{
		size_t _copy_len_buffer;
		_copy_len_buffer = r.in.buf_size;
		memcpy(_buffer, r.out.buffer, _copy_len_buffer * sizeof(*_buffer));
	}
	*_bytes_needed = *r.out.bytes_needed;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_eventlog_FlushEventLog_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_eventlog_FlushEventLog_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_eventlog_FlushEventLog_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct eventlog_FlushEventLog *r)
{
	struct tevent_req *req;
	struct dcerpc_eventlog_FlushEventLog_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_eventlog_FlushEventLog_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_eventlog,
			NDR_EVENTLOG_FLUSHEVENTLOG, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_eventlog_FlushEventLog_r_done, req);

	return req;
}

static void dcerpc_eventlog_FlushEventLog_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_eventlog_FlushEventLog_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_eventlog_FlushEventLog_r_state *state =
		tevent_req_data(req,
		struct dcerpc_eventlog_FlushEventLog_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_eventlog_FlushEventLog_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct eventlog_FlushEventLog *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_eventlog,
			NDR_EVENTLOG_FLUSHEVENTLOG, mem_ctx, r);

	return status;
}

struct dcerpc_eventlog_FlushEventLog_state {
	struct eventlog_FlushEventLog orig;
	struct eventlog_FlushEventLog tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_eventlog_FlushEventLog_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_eventlog_FlushEventLog_send(TALLOC_CTX *mem_ctx,
						      struct tevent_context *ev,
						      struct dcerpc_binding_handle *h,
						      struct policy_handle *_handle /* [in] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_eventlog_FlushEventLog_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_eventlog_FlushEventLog_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_eventlog_FlushEventLog_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_eventlog_FlushEventLog_done, req);
	return req;
}

static void dcerpc_eventlog_FlushEventLog_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_eventlog_FlushEventLog_state *state = tevent_req_data(
		req, struct dcerpc_eventlog_FlushEventLog_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_eventlog_FlushEventLog_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_eventlog_FlushEventLog_recv(struct tevent_req *req,
					    TALLOC_CTX *mem_ctx,
					    NTSTATUS *result)
{
	struct dcerpc_eventlog_FlushEventLog_state *state = tevent_req_data(
		req, struct dcerpc_eventlog_FlushEventLog_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_eventlog_FlushEventLog(struct dcerpc_binding_handle *h,
				       TALLOC_CTX *mem_ctx,
				       struct policy_handle *_handle /* [in] [ref] */,
				       NTSTATUS *result)
{
	struct eventlog_FlushEventLog r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;

	status = dcerpc_eventlog_FlushEventLog_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_eventlog_ReportEventAndSourceW_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_eventlog_ReportEventAndSourceW_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_eventlog_ReportEventAndSourceW_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct eventlog_ReportEventAndSourceW *r)
{
	struct tevent_req *req;
	struct dcerpc_eventlog_ReportEventAndSourceW_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_eventlog_ReportEventAndSourceW_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_eventlog,
			NDR_EVENTLOG_REPORTEVENTANDSOURCEW, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_eventlog_ReportEventAndSourceW_r_done, req);

	return req;
}

static void dcerpc_eventlog_ReportEventAndSourceW_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_eventlog_ReportEventAndSourceW_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_eventlog_ReportEventAndSourceW_r_state *state =
		tevent_req_data(req,
		struct dcerpc_eventlog_ReportEventAndSourceW_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_eventlog_ReportEventAndSourceW_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct eventlog_ReportEventAndSourceW *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_eventlog,
			NDR_EVENTLOG_REPORTEVENTANDSOURCEW, mem_ctx, r);

	return status;
}

struct dcerpc_eventlog_ReportEventAndSourceW_state {
	struct eventlog_ReportEventAndSourceW orig;
	struct eventlog_ReportEventAndSourceW tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_eventlog_ReportEventAndSourceW_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_eventlog_ReportEventAndSourceW_send(TALLOC_CTX *mem_ctx,
							      struct tevent_context *ev,
							      struct dcerpc_binding_handle *h,
							      struct policy_handle *_handle /* [in] [ref] */,
							      time_t _timestamp /* [in]  */,
							      enum eventlogEventTypes _event_type /* [in]  */,
							      uint16_t _event_category /* [in]  */,
							      uint32_t _event_id /* [in]  */,
							      struct lsa_String *_sourcename /* [in] [ref] */,
							      uint16_t _num_of_strings /* [in] [range(0,256)] */,
							      uint32_t _data_size /* [in] [range(0,0x3FFFF)] */,
							      struct lsa_String *_servername /* [in] [ref] */,
							      struct dom_sid *_user_sid /* [in] [unique] */,
							      struct lsa_String **_strings /* [in] [unique,size_is(num_of_strings)] */,
							      uint8_t *_data /* [in] [unique,size_is(data_size)] */,
							      uint16_t _flags /* [in]  */,
							      uint32_t *_record_number /* [in,out] [unique] */,
							      time_t *_time_written /* [in,out] [unique] */)
{
	struct tevent_req *req;
	struct dcerpc_eventlog_ReportEventAndSourceW_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_eventlog_ReportEventAndSourceW_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.timestamp = _timestamp;
	state->orig.in.event_type = _event_type;
	state->orig.in.event_category = _event_category;
	state->orig.in.event_id = _event_id;
	state->orig.in.sourcename = _sourcename;
	state->orig.in.num_of_strings = _num_of_strings;
	state->orig.in.data_size = _data_size;
	state->orig.in.servername = _servername;
	state->orig.in.user_sid = _user_sid;
	state->orig.in.strings = _strings;
	state->orig.in.data = _data;
	state->orig.in.flags = _flags;
	state->orig.in.record_number = _record_number;
	state->orig.in.time_written = _time_written;

	/* Out parameters */
	state->orig.out.record_number = _record_number;
	state->orig.out.time_written = _time_written;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_eventlog_ReportEventAndSourceW_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_eventlog_ReportEventAndSourceW_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_eventlog_ReportEventAndSourceW_done, req);
	return req;
}

static void dcerpc_eventlog_ReportEventAndSourceW_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_eventlog_ReportEventAndSourceW_state *state = tevent_req_data(
		req, struct dcerpc_eventlog_ReportEventAndSourceW_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_eventlog_ReportEventAndSourceW_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	if (state->orig.out.record_number && state->tmp.out.record_number) {
		*state->orig.out.record_number = *state->tmp.out.record_number;
	}
	if (state->orig.out.time_written && state->tmp.out.time_written) {
		*state->orig.out.time_written = *state->tmp.out.time_written;
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_eventlog_ReportEventAndSourceW_recv(struct tevent_req *req,
						    TALLOC_CTX *mem_ctx,
						    NTSTATUS *result)
{
	struct dcerpc_eventlog_ReportEventAndSourceW_state *state = tevent_req_data(
		req, struct dcerpc_eventlog_ReportEventAndSourceW_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_eventlog_ReportEventAndSourceW(struct dcerpc_binding_handle *h,
					       TALLOC_CTX *mem_ctx,
					       struct policy_handle *_handle /* [in] [ref] */,
					       time_t _timestamp /* [in]  */,
					       enum eventlogEventTypes _event_type /* [in]  */,
					       uint16_t _event_category /* [in]  */,
					       uint32_t _event_id /* [in]  */,
					       struct lsa_String *_sourcename /* [in] [ref] */,
					       uint16_t _num_of_strings /* [in] [range(0,256)] */,
					       uint32_t _data_size /* [in] [range(0,0x3FFFF)] */,
					       struct lsa_String *_servername /* [in] [ref] */,
					       struct dom_sid *_user_sid /* [in] [unique] */,
					       struct lsa_String **_strings /* [in] [unique,size_is(num_of_strings)] */,
					       uint8_t *_data /* [in] [unique,size_is(data_size)] */,
					       uint16_t _flags /* [in]  */,
					       uint32_t *_record_number /* [in,out] [unique] */,
					       time_t *_time_written /* [in,out] [unique] */,
					       NTSTATUS *result)
{
	struct eventlog_ReportEventAndSourceW r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.timestamp = _timestamp;
	r.in.event_type = _event_type;
	r.in.event_category = _event_category;
	r.in.event_id = _event_id;
	r.in.sourcename = _sourcename;
	r.in.num_of_strings = _num_of_strings;
	r.in.data_size = _data_size;
	r.in.servername = _servername;
	r.in.user_sid = _user_sid;
	r.in.strings = _strings;
	r.in.data = _data;
	r.in.flags = _flags;
	r.in.record_number = _record_number;
	r.in.time_written = _time_written;

	status = dcerpc_eventlog_ReportEventAndSourceW_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	if (_record_number && r.out.record_number) {
		*_record_number = *r.out.record_number;
	}
	if (_time_written && r.out.time_written) {
		*_time_written = *r.out.time_written;
	}

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

