/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLDivElement.h"

#include "HTMLDivElement.h"
#include "KURL.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSHTMLDivElement);

/* Hash table */

static const HashTableValue JSHTMLDivElementTableValues[3] =
{
    { "align", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLDivElementAlign), (intptr_t)setJSHTMLDivElementAlign },
    { "constructor", DontEnum|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLDivElementConstructor), (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSHTMLDivElementTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 7, JSHTMLDivElementTableValues, 0 };
#else
    { 5, 3, JSHTMLDivElementTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSHTMLDivElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSHTMLDivElementConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSHTMLDivElementConstructorTableValues, 0 };
#else
    { 1, 0, JSHTMLDivElementConstructorTableValues, 0 };
#endif

class JSHTMLDivElementConstructor : public DOMConstructorObject {
public:
    JSHTMLDivElementConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
        : DOMConstructorObject(JSHTMLDivElementConstructor::createStructure(globalObject->objectPrototype()), globalObject)
    {
        putDirect(exec->propertyNames().prototype, JSHTMLDivElementPrototype::self(exec, globalObject), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual bool getOwnPropertyDescriptor(ExecState*, const Identifier&, PropertyDescriptor&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, StructureFlags), AnonymousSlotCount); 
    }
    
protected:
    static const unsigned StructureFlags = OverridesGetOwnPropertySlot | ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSHTMLDivElementConstructor::s_info = { "HTMLDivElementConstructor", 0, &JSHTMLDivElementConstructorTable, 0 };

bool JSHTMLDivElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLDivElementConstructor, DOMObject>(exec, &JSHTMLDivElementConstructorTable, this, propertyName, slot);
}

bool JSHTMLDivElementConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLDivElementConstructor, DOMObject>(exec, &JSHTMLDivElementConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLDivElementPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSHTMLDivElementPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSHTMLDivElementPrototypeTableValues, 0 };
#else
    { 1, 0, JSHTMLDivElementPrototypeTableValues, 0 };
#endif

const ClassInfo JSHTMLDivElementPrototype::s_info = { "HTMLDivElementPrototype", 0, &JSHTMLDivElementPrototypeTable, 0 };

JSObject* JSHTMLDivElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLDivElement>(exec, globalObject);
}

const ClassInfo JSHTMLDivElement::s_info = { "HTMLDivElement", &JSHTMLElement::s_info, &JSHTMLDivElementTable, 0 };

JSHTMLDivElement::JSHTMLDivElement(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLDivElement> impl)
    : JSHTMLElement(structure, globalObject, impl)
{
}

JSObject* JSHTMLDivElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSHTMLDivElementPrototype(JSHTMLDivElementPrototype::createStructure(JSHTMLElementPrototype::self(exec, globalObject)));
}

bool JSHTMLDivElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLDivElement, Base>(exec, &JSHTMLDivElementTable, this, propertyName, slot);
}

bool JSHTMLDivElement::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLDivElement, Base>(exec, &JSHTMLDivElementTable, this, propertyName, descriptor);
}

JSValue jsHTMLDivElementAlign(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLDivElement* castedThis = static_cast<JSHTMLDivElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLDivElement* imp = static_cast<HTMLDivElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->align());
    return result;
}

JSValue jsHTMLDivElementConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLDivElement* domObject = static_cast<JSHTMLDivElement*>(asObject(slotBase));
    return JSHTMLDivElement::getConstructor(exec, domObject->globalObject());
}
void JSHTMLDivElement::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    lookupPut<JSHTMLDivElement, Base>(exec, propertyName, value, &JSHTMLDivElementTable, this, slot);
}

void setJSHTMLDivElementAlign(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLDivElement* castedThisObj = static_cast<JSHTMLDivElement*>(thisObject);
    HTMLDivElement* imp = static_cast<HTMLDivElement*>(castedThisObj->impl());
    imp->setAlign(valueToStringWithNullCheck(exec, value));
}

JSValue JSHTMLDivElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLDivElementConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}


}
