/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSClientRectList.h"

#include "ClientRect.h"
#include "ClientRectList.h"
#include "ExceptionCode.h"
#include "JSClientRect.h"
#include <runtime/Error.h>
#include <runtime/JSNumberCell.h>
#include <runtime/PropertyNameArray.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSClientRectList);

/* Hash table */

static const HashTableValue JSClientRectListTableValues[3] =
{
    { "length", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsClientRectListLength), (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsClientRectListConstructor), (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSClientRectListTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 15, JSClientRectListTableValues, 0 };
#else
    { 5, 3, JSClientRectListTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSClientRectListConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSClientRectListConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSClientRectListConstructorTableValues, 0 };
#else
    { 1, 0, JSClientRectListConstructorTableValues, 0 };
#endif

class JSClientRectListConstructor : public DOMConstructorObject {
public:
    JSClientRectListConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
        : DOMConstructorObject(JSClientRectListConstructor::createStructure(globalObject->objectPrototype()), globalObject)
    {
        putDirect(exec->propertyNames().prototype, JSClientRectListPrototype::self(exec, globalObject), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual bool getOwnPropertyDescriptor(ExecState*, const Identifier&, PropertyDescriptor&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, StructureFlags), AnonymousSlotCount); 
    }
    
protected:
    static const unsigned StructureFlags = OverridesGetOwnPropertySlot | ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSClientRectListConstructor::s_info = { "ClientRectListConstructor", 0, &JSClientRectListConstructorTable, 0 };

bool JSClientRectListConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSClientRectListConstructor, DOMObject>(exec, &JSClientRectListConstructorTable, this, propertyName, slot);
}

bool JSClientRectListConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSClientRectListConstructor, DOMObject>(exec, &JSClientRectListConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSClientRectListPrototypeTableValues[2] =
{
    { "item", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsClientRectListPrototypeFunctionItem), (intptr_t)1 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSClientRectListPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSClientRectListPrototypeTableValues, 0 };
#else
    { 2, 1, JSClientRectListPrototypeTableValues, 0 };
#endif

const ClassInfo JSClientRectListPrototype::s_info = { "ClientRectListPrototype", 0, &JSClientRectListPrototypeTable, 0 };

JSObject* JSClientRectListPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSClientRectList>(exec, globalObject);
}

bool JSClientRectListPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSClientRectListPrototypeTable, this, propertyName, slot);
}

bool JSClientRectListPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSClientRectListPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSClientRectList::s_info = { "ClientRectList", 0, &JSClientRectListTable, 0 };

JSClientRectList::JSClientRectList(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<ClientRectList> impl)
    : DOMObjectWithGlobalPointer(structure, globalObject)
    , m_impl(impl)
{
}

JSClientRectList::~JSClientRectList()
{
    forgetDOMObject(this, impl());
}

JSObject* JSClientRectList::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSClientRectListPrototype(JSClientRectListPrototype::createStructure(globalObject->objectPrototype()));
}

bool JSClientRectList::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    const HashEntry* entry = JSClientRectListTable.entry(exec, propertyName);
    if (entry) {
        slot.setCustom(this, entry->propertyGetter());
        return true;
    }
    bool ok;
    unsigned index = propertyName.toUInt32(&ok, false);
    if (ok && index < static_cast<ClientRectList*>(impl())->length()) {
        slot.setCustomIndex(this, index, indexGetter);
        return true;
    }
    return getStaticValueSlot<JSClientRectList, Base>(exec, &JSClientRectListTable, this, propertyName, slot);
}

bool JSClientRectList::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    const HashEntry* entry = JSClientRectListTable.entry(exec, propertyName);
    if (entry) {
        PropertySlot slot;
        slot.setCustom(this, entry->propertyGetter());
        descriptor.setDescriptor(slot.getValue(exec, propertyName), entry->attributes());
        return true;
    }
    bool ok;
    unsigned index = propertyName.toUInt32(&ok, false);
    if (ok && index < static_cast<ClientRectList*>(impl())->length()) {
        PropertySlot slot;
        slot.setCustomIndex(this, index, indexGetter);
        descriptor.setDescriptor(slot.getValue(exec, propertyName), DontDelete | ReadOnly);
        return true;
    }
    return getStaticValueDescriptor<JSClientRectList, Base>(exec, &JSClientRectListTable, this, propertyName, descriptor);
}

bool JSClientRectList::getOwnPropertySlot(ExecState* exec, unsigned propertyName, PropertySlot& slot)
{
    if (propertyName < static_cast<ClientRectList*>(impl())->length()) {
        slot.setCustomIndex(this, propertyName, indexGetter);
        return true;
    }
    return getOwnPropertySlot(exec, Identifier::from(exec, propertyName), slot);
}

JSValue jsClientRectListLength(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSClientRectList* castedThis = static_cast<JSClientRectList*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    ClientRectList* imp = static_cast<ClientRectList*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->length());
    return result;
}

JSValue jsClientRectListConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSClientRectList* domObject = static_cast<JSClientRectList*>(asObject(slotBase));
    return JSClientRectList::getConstructor(exec, domObject->globalObject());
}
void JSClientRectList::getOwnPropertyNames(ExecState* exec, PropertyNameArray& propertyNames, EnumerationMode mode)
{
    for (unsigned i = 0; i < static_cast<ClientRectList*>(impl())->length(); ++i)
        propertyNames.add(Identifier::from(exec, i));
     Base::getOwnPropertyNames(exec, propertyNames, mode);
}

JSValue JSClientRectList::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSClientRectListConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

JSValue JSC_HOST_CALL jsClientRectListPrototypeFunctionItem(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSClientRectList::s_info))
        return throwError(exec, TypeError);
    JSClientRectList* castedThisObj = static_cast<JSClientRectList*>(asObject(thisValue));
    ClientRectList* imp = static_cast<ClientRectList*>(castedThisObj->impl());
    int index = args.at(0).toInt32(exec);
    if (index < 0) {
        setDOMException(exec, INDEX_SIZE_ERR);
        return jsUndefined();
    }


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), WTF::getPtr(imp->item(index)));
    return result;
}


JSValue JSClientRectList::indexGetter(ExecState* exec, JSValue slotBase, unsigned index)
{
    JSClientRectList* thisObj = static_cast<JSClientRectList*>(asObject(slotBase));
    return toJS(exec, thisObj->globalObject(), static_cast<ClientRectList*>(thisObj->impl())->item(index));
}
JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, ClientRectList* object)
{
    return getDOMObjectWrapper<JSClientRectList>(exec, globalObject, object);
}
ClientRectList* toClientRectList(JSC::JSValue value)
{
    return value.inherits(&JSClientRectList::s_info) ? static_cast<JSClientRectList*>(asObject(value))->impl() : 0;
}

}
