#
# spec file for package tidy
#
#    (c) 2006 (W3C) MIT, ERCIM, Keio University
#    See tidy.h for the copyright notice.
#
#  CVS Info :
#
#    $Author: arnaud02 $
#    $Date: 2006/02/22 14:21:12 $
#    $Revision: 1.2 $
#
#  Contributing Author(s):
#     Sierk Bornemann <bornemann@users.sourceforge.net>
#
# norootforbuild
# neededforbuild  doxygen libxslt libtool

BuildRequires: doxygen libxslt libtool 

Name:                 tidy
Version:              1.0
Release:              YYMMDD
%define docrelease    YYMMDD
Summary:              Utility to clean up and pretty print HTML/XHTML/XML
Group:                Applications/Tools
License:              W3C Software License, MIT Licence, Other License(s), see package
Autoreqprov:          on
URL:                  http://tidy.sourceforge.net/
Source0:              http://sourceforge.net/cvs/?group_id=27659
Source1:              http://tidy.sourceforge.net/src/tidy_src.tgz
Source2:              http://tidy.sourceforge.net/docs/tidy_docs.tgz
BuildRoot:            %{_tmppath}/%{name}-%{version}-%{release}-build


%description
When editing HTML it's easy to make mistakes. Wouldn't it be nice if
there was a simple way to fix these mistakes automatically and tidy up
sloppy editing into nicely layed out markup? Well now there is! Dave
Raggett's HTML TIDY is a free utility for doing just that. It also
works great on the atrociously hard to read markup generated by
specialized HTML editors and conversion tools, and can help you
identify where you need to pay further attention on making your pages
more accessible to people with disabilities.

Tidy is able to fix up a wide range of problems and to bring to your
attention things that you need to work on yourself. Each item found is
listed with the line number and column so that you can see where the
problem lies in your markup. Tidy won't generate a cleaned up version
when there are problems that it can't be sure of how to handle. These
are logged as "errors" rather than "warnings".


Authors:
--------

    Tidy was written by Dave Raggett <dsr@w3.org> and is now maintained 
    and developed by the Tidy team at http://tidy.sourceforge.net/.


%package     -n libtidy
Summary:        Shared library for tidy
Group:          Development/Libraries
Autoreqprov:    on

%description -n libtidy

This package contains the library needed to run programs dynamically
linked with tidy.


%package     -n libtidy-devel
Summary:        Development files for tidy
Group:          Development/Libraries
Requires:       libtidy = %{version}-%{release}
Autoreqprov:    on


%description -n libtidy-devel

This package contains the headers, the shared libraries and the API 
documentation which programmers will need to develop applications based on 
tidy.

%debug_package
%prep
%setup -q -n %{name} -b 1 
mv htmldoc/doxygen.cfg Doxyfile


%build
export CFLAGS="$RPM_OPT_FLAGS"
/bin/sh build/gnuauto/setup.sh

%configure --disable-dependency-tracking \
           --includedir=%{_includedir}/%{name}
make %{?_smp_mflags} all
make -C build/gmake/ doc
doxygen


%install
rm -rf $RPM_BUILD_ROOT _api
make install DESTDIR=$RPM_BUILD_ROOT
# Manpage
install -Dpm 644 htmldoc/tidy.1 $RPM_BUILD_ROOT%{_mandir}/man1/tidy.1
# Quick Reference
install -Dpm 644 htmldoc/quickref.html $RPM_BUILD_ROOT%{_defaultdocdir}/%{name}/quickref.html
# Move API directory out of the way
mv htmldoc/api _api


%clean
if ! test -f /.buildenv; then
    rm -rf $RPM_BUILD_ROOT;
fi


%post -n lib%{name} -p /sbin/ldconfig

%postun -n lib%{name} -p /sbin/ldconfig


%files
%defattr(-, root, root)
%doc htmldoc/*
%{_bindir}/tidy
%{_bindir}/tab2space
%{_mandir}/man1/tidy.1*


%files -n libtidy
%defattr(-, root, root)
%doc htmldoc/license.html
%{_libdir}/libtidy*.so.*


%files -n libtidy-devel
%defattr(-, root, root)
%doc _api/*
%{_includedir}/%{name}/*.h
%{_libdir}/libtidy.so
%{_libdir}/libtidy.a
%exclude %{_libdir}/libtidy.la


%changelog -n tidy
* Thu Feb 22 2006 - Sierk Bornemann <bornemann@sourceforge.net>
  Rewritten RPM Spec file:
  - respects filesystem layout of current FHS-compliant linux distributions.
  - respects current tidy Makefile and
    creation of tidy docs (XSL transformation from tidy's XML output).

* Mon Oct 25 2003 - Al Dev (Alavoor Vasudevan) <alavoor[at]yahoo.com>
  - Initial version of %{name} rpm
