/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(WORKERS)

#include "JSWorkerContext.h"

#include <wtf/GetPtr.h>

#include "Event.h"
#include "EventListener.h"
#include "JSEvent.h"
#include "JSEventListener.h"
#include "JSMessageEvent.h"
#include "JSWorkerLocation.h"
#include "JSWorkerNavigator.h"
#include "WorkerContext.h"
#include "WorkerLocation.h"
#include "WorkerNavigator.h"

#include <runtime/Error.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSWorkerContext)

/* Hash table */

static const HashTableValue JSWorkerContextTableValues[7] =
{
    { "self", DontDelete, (intptr_t)jsWorkerContextSelf, (intptr_t)setJSWorkerContextSelf },
    { "onmessage", DontDelete, (intptr_t)jsWorkerContextOnmessage, (intptr_t)setJSWorkerContextOnmessage },
    { "location", DontDelete, (intptr_t)jsWorkerContextLocation, (intptr_t)setJSWorkerContextLocation },
    { "navigator", DontDelete, (intptr_t)jsWorkerContextNavigator, (intptr_t)setJSWorkerContextNavigator },
    { "MessageEvent", DontDelete, (intptr_t)jsWorkerContextMessageEventConstructor, (intptr_t)setJSWorkerContextMessageEventConstructor },
    { "WorkerLocation", DontDelete, (intptr_t)jsWorkerContextWorkerLocationConstructor, (intptr_t)setJSWorkerContextWorkerLocationConstructor },
    { 0, 0, 0, 0 }
};

static const HashTable JSWorkerContextTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 127, JSWorkerContextTableValues, 0 };
#else
    { 18, 15, JSWorkerContextTableValues, 0 };
#endif

/* Hash table for prototype */

static const HashTableValue JSWorkerContextPrototypeTableValues[5] =
{
    { "postMessage", DontDelete|Function, (intptr_t)jsWorkerContextPrototypeFunctionPostMessage, (intptr_t)1 },
    { "addEventListener", DontDelete|Function, (intptr_t)jsWorkerContextPrototypeFunctionAddEventListener, (intptr_t)3 },
    { "removeEventListener", DontDelete|Function, (intptr_t)jsWorkerContextPrototypeFunctionRemoveEventListener, (intptr_t)3 },
    { "dispatchEvent", DontDelete|Function, (intptr_t)jsWorkerContextPrototypeFunctionDispatchEvent, (intptr_t)1 },
    { 0, 0, 0, 0 }
};

static const HashTable JSWorkerContextPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 7, JSWorkerContextPrototypeTableValues, 0 };
#else
    { 8, 7, JSWorkerContextPrototypeTableValues, 0 };
#endif

static const HashTable* getJSWorkerContextPrototypeTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSWorkerContextPrototypeTable);
}
const ClassInfo JSWorkerContextPrototype::s_info = { "WorkerContextPrototype", 0, 0, getJSWorkerContextPrototypeTable };

void* JSWorkerContextPrototype::operator new(size_t size, JSGlobalData* globalData)
{
    return globalData->heap.allocate(size);
}

bool JSWorkerContextPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, getJSWorkerContextPrototypeTable(exec), this, propertyName, slot);
}

static const HashTable* getJSWorkerContextTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSWorkerContextTable);
}
const ClassInfo JSWorkerContext::s_info = { "WorkerContext", &JSWorkerContextBase::s_info, 0, getJSWorkerContextTable };

JSWorkerContext::JSWorkerContext(PassRefPtr<Structure> structure, PassRefPtr<WorkerContext> impl)
    : JSWorkerContextBase(structure, impl)
{
}

bool JSWorkerContext::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    if (customGetOwnPropertySlot(exec, propertyName, slot))
        return true;
    return getStaticValueSlot<JSWorkerContext, Base>(exec, getJSWorkerContextTable(exec), this, propertyName, slot);
}

JSValuePtr jsWorkerContextSelf(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSWorkerContext*>(asObject(slot.slotBase()))->self(exec);
}

JSValuePtr jsWorkerContextOnmessage(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    WorkerContext* imp = static_cast<WorkerContext*>(static_cast<JSWorkerContext*>(asObject(slot.slotBase()))->impl());
    if (JSUnprotectedEventListener* listener = static_cast<JSUnprotectedEventListener*>(imp->onmessage())) {
        if (JSObject* listenerObj = listener->listenerObj())
            return listenerObj;
    }
    return jsNull();
}

JSValuePtr jsWorkerContextLocation(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    WorkerContext* imp = static_cast<WorkerContext*>(static_cast<JSWorkerContext*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->location()));
}

JSValuePtr jsWorkerContextNavigator(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    WorkerContext* imp = static_cast<WorkerContext*>(static_cast<JSWorkerContext*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->navigator()));
}

JSValuePtr jsWorkerContextMessageEventConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return JSMessageEvent::getConstructor(exec);
}

JSValuePtr jsWorkerContextWorkerLocationConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return JSWorkerLocation::getConstructor(exec);
}

void JSWorkerContext::put(ExecState* exec, const Identifier& propertyName, JSValuePtr value, PutPropertySlot& slot)
{
    lookupPut<JSWorkerContext, Base>(exec, propertyName, value, getJSWorkerContextTable(exec), this, slot);
}

void setJSWorkerContextSelf(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    static_cast<JSWorkerContext*>(thisObject)->setSelf(exec, value);
}

void setJSWorkerContextOnmessage(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    WorkerContext* imp = static_cast<WorkerContext*>(static_cast<JSWorkerContext*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = static_cast<JSWorkerContext*>(thisObject);
    imp->setOnmessage(globalObject->findOrCreateJSUnprotectedEventListener(exec, value, true));
}

void setJSWorkerContextLocation(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    static_cast<JSWorkerContext*>(thisObject)->putDirect(Identifier(exec, "location"), value);
}

void setJSWorkerContextNavigator(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    static_cast<JSWorkerContext*>(thisObject)->putDirect(Identifier(exec, "navigator"), value);
}

void setJSWorkerContextMessageEventConstructor(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    // Shadowing a built-in constructor
    static_cast<JSWorkerContext*>(thisObject)->putDirect(Identifier(exec, "MessageEvent"), value);
}

void setJSWorkerContextWorkerLocationConstructor(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    // Shadowing a built-in constructor
    static_cast<JSWorkerContext*>(thisObject)->putDirect(Identifier(exec, "WorkerLocation"), value);
}

JSValuePtr jsWorkerContextPrototypeFunctionPostMessage(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSWorkerContext::s_info))
        return throwError(exec, TypeError);
    JSWorkerContext* castedThisObj = static_cast<JSWorkerContext*>(asObject(thisValue));
    WorkerContext* imp = static_cast<WorkerContext*>(castedThisObj->impl());
    const UString& message = args.at(exec, 0)->toString(exec);

    imp->postMessage(message);
    return jsUndefined();
}

JSValuePtr jsWorkerContextPrototypeFunctionAddEventListener(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSWorkerContext::s_info))
        return throwError(exec, TypeError);
    JSWorkerContext* castedThisObj = static_cast<JSWorkerContext*>(asObject(thisValue));
    return castedThisObj->addEventListener(exec, args);
}

JSValuePtr jsWorkerContextPrototypeFunctionRemoveEventListener(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSWorkerContext::s_info))
        return throwError(exec, TypeError);
    JSWorkerContext* castedThisObj = static_cast<JSWorkerContext*>(asObject(thisValue));
    return castedThisObj->removeEventListener(exec, args);
}

JSValuePtr jsWorkerContextPrototypeFunctionDispatchEvent(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSWorkerContext::s_info))
        return throwError(exec, TypeError);
    JSWorkerContext* castedThisObj = static_cast<JSWorkerContext*>(asObject(thisValue));
    WorkerContext* imp = static_cast<WorkerContext*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    Event* evt = toEvent(args.at(exec, 0));


    JSC::JSValuePtr result = jsBoolean(imp->dispatchEvent(evt, ec));
    setDOMException(exec, ec);
    return result;
}


}

#endif // ENABLE(WORKERS)
