/*
    Copyright (C) 2008 Torsten Rahn <rahn@kde.org>

    This file is part of the KDE project

    This library is free software you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    aint with this library see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef GEOSCENEPALETTE_H
#define GEOSCENEPALETTE_H

#include <QtCore/QString>

#include "GeoDocument.h"

namespace Marble
{

/**
 * @short Palette of a GeoScene document.
 */

class GeoScenePalette : public GeoNode
{
 public:
    explicit GeoScenePalette( const QString& type, const QString& file );
    ~GeoScenePalette();

    QString type() const;
    void    setType( const QString& type );

    QString file() const;
    void    setFile( const QString& file );

    bool operator==( const GeoScenePalette& other );

 private:
    QString m_type;
    QString m_file;
};

}

#endif // GEOSCENELAYER_H
