/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.memory;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.netbeans.lib.profiler.results.memory.AllocMemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.JMethodIdTable;
import org.netbeans.lib.profiler.results.memory.PresoObjAllocCCTNode;
import org.netbeans.lib.profiler.results.memory.RuntimeMemoryCCTNode;

public class AllocMemoryResultsDiff
extends AllocMemoryResultsSnapshot {
    private String[] classNames;
    private int[] objectsCounts;
    private long[] objectsSizePerClass;
    private int nClasses;
    private long maxObjectsSizePerClassDiff;
    private long minObjectsSizePerClassDiff;

    public AllocMemoryResultsDiff(AllocMemoryResultsSnapshot snapshot1, AllocMemoryResultsSnapshot snapshot2) {
        this.computeDiff(snapshot1, snapshot2);
    }

    public long getBeginTime() {
        return -1L;
    }

    public String getClassName(int classId) {
        return null;
    }

    public String[] getClassNames() {
        return this.classNames;
    }

    public JMethodIdTable getJMethodIdTable() {
        return null;
    }

    public long getMaxObjectsSizePerClassDiff() {
        return this.maxObjectsSizePerClassDiff;
    }

    public long getMinObjectsSizePerClassDiff() {
        return this.minObjectsSizePerClassDiff;
    }

    public int getNProfiledClasses() {
        return this.nClasses;
    }

    public int[] getObjectsCounts() {
        return this.objectsCounts;
    }

    public long[] getObjectsSizePerClass() {
        return this.objectsSizePerClass;
    }

    public long getTimeTaken() {
        return -1L;
    }

    public boolean containsStacks() {
        return false;
    }

    public PresoObjAllocCCTNode createPresentationCCT(int classId, boolean dontShowZeroLiveObjAllocPaths) {
        return null;
    }

    public void readFromStream(DataInputStream in) throws IOException {
        throw new UnsupportedOperationException("Persistence not supported for snapshot comparison");
    }

    public void writeToStream(DataOutputStream out) throws IOException {
        throw new UnsupportedOperationException("Persistence not supported for snapshot comparison");
    }

    protected PresoObjAllocCCTNode createPresentationCCT(RuntimeMemoryCCTNode rootNode, int classId, boolean dontShowZeroLiveObjAllocPaths) {
        return null;
    }

    private void computeDiff(AllocMemoryResultsSnapshot snapshot1, AllocMemoryResultsSnapshot snapshot2) {
        int s1nClasses = Math.min(snapshot1.getNProfiledClasses(), snapshot1.getObjectsCounts().length);
        s1nClasses = Math.min(s1nClasses, snapshot1.getObjectsSizePerClass().length);
        int s2nClasses = Math.min(snapshot2.getNProfiledClasses(), snapshot2.getObjectsCounts().length);
        s2nClasses = Math.min(s2nClasses, snapshot2.getObjectsSizePerClass().length);
        HashMap<String, Integer> classNamesIdxMap = new HashMap<String, Integer>(s1nClasses);
        ArrayList<Integer> objCountsArr = new ArrayList<Integer>(s1nClasses);
        ArrayList<Long> objSizesArr = new ArrayList<Long>(s1nClasses);
        String[] s1ClassNames = snapshot1.getClassNames();
        int[] s1ObjectsCount = snapshot1.getObjectsCounts();
        long[] s1ObjectsSizes = snapshot1.getObjectsSizePerClass();
        for (int i = 0; i < s1nClasses; ++i) {
            Integer classIdx = (Integer)classNamesIdxMap.get(s1ClassNames[i]);
            if (classIdx != null) {
                int index = classIdx;
                Integer objCount = (Integer)objCountsArr.get(index);
                Long objSize = (Long)objSizesArr.get(index);
                objCountsArr.set(index, new Integer(objCount - s1ObjectsCount[i]));
                objSizesArr.set(index, new Long(objSize - s1ObjectsSizes[i]));
                continue;
            }
            classNamesIdxMap.put(s1ClassNames[i], new Integer(objCountsArr.size()));
            objCountsArr.add(new Integer(0 - s1ObjectsCount[i]));
            objSizesArr.add(new Long(0L - s1ObjectsSizes[i]));
        }
        String[] s2ClassNames = snapshot2.getClassNames();
        int[] s2ObjectsCount = snapshot2.getObjectsCounts();
        long[] s2ObjectsSizes = snapshot2.getObjectsSizePerClass();
        for (int i = 0; i < s2nClasses; ++i) {
            String className = s2ClassNames[i];
            int objectsCount = s2ObjectsCount[i];
            long objectsSize = s2ObjectsSizes[i];
            Integer classIdx = (Integer)classNamesIdxMap.get(className);
            if (classIdx != null) {
                int classIndex = classIdx;
                if (objectsCount != 0 || (Integer)objCountsArr.get(classIndex) != 0) {
                    objCountsArr.set(classIndex, new Integer((Integer)objCountsArr.get(classIndex) + objectsCount));
                    objSizesArr.set(classIndex, new Long((Long)objSizesArr.get(classIndex) + objectsSize));
                    continue;
                }
                classNamesIdxMap.remove(className);
                continue;
            }
            if (objectsCount == 0) continue;
            classNamesIdxMap.put(className, new Integer(objCountsArr.size()));
            objCountsArr.add(new Integer(objectsCount));
            objSizesArr.add(new Long(objectsSize));
        }
        this.nClasses = classNamesIdxMap.size();
        this.classNames = new String[this.nClasses];
        this.objectsCounts = new int[this.nClasses];
        this.objectsSizePerClass = new long[this.nClasses];
        this.minObjectsSizePerClassDiff = Long.MAX_VALUE;
        this.maxObjectsSizePerClassDiff = Long.MIN_VALUE;
        Iterator classNamesIter = classNamesIdxMap.entrySet().iterator();
        int index = 0;
        while (classNamesIter.hasNext()) {
            Map.Entry entry = classNamesIter.next();
            String className = (String)entry.getKey();
            int classIndex = (Integer)entry.getValue();
            this.classNames[index] = className;
            this.objectsCounts[index] = (Integer)objCountsArr.get(classIndex);
            this.objectsSizePerClass[index] = (Long)objSizesArr.get(classIndex);
            this.minObjectsSizePerClassDiff = Math.min(this.minObjectsSizePerClassDiff, this.objectsSizePerClass[index]);
            this.maxObjectsSizePerClassDiff = Math.max(this.maxObjectsSizePerClassDiff, this.objectsSizePerClass[index]);
            ++index;
        }
        if (this.minObjectsSizePerClassDiff > 0L && this.maxObjectsSizePerClassDiff > 0L) {
            this.minObjectsSizePerClassDiff = 0L;
        } else if (this.minObjectsSizePerClassDiff < 0L && this.maxObjectsSizePerClassDiff < 0L) {
            this.maxObjectsSizePerClassDiff = 0L;
        }
    }
}

