/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.client;

import org.netbeans.lib.profiler.classfile.ClassInfo;
import org.netbeans.lib.profiler.classfile.ClassRepository;

public class RuntimeProfilingPoint {
    private final String className;
    private final String methodName;
    private final String methodSignature;
    private final String serverHandlerClass;
    private final String serverInfo;
    private final int id;
    private final int line;
    private final int offset;
    private int bci;
    private int methodIdx = -1;

    public RuntimeProfilingPoint(int id, String className, int line, int offset, String serverHandlerClass, String serverInfo) {
        this(id, className, line, offset, null, null, serverHandlerClass, serverInfo);
    }

    public RuntimeProfilingPoint(int id, String className, String methodName, String methodSignature, String serverHandlerClass, String serverInfo) {
        this(id, className, -1, -1, methodName, methodSignature, serverHandlerClass, serverInfo);
    }

    private RuntimeProfilingPoint(int id, String className, int line, int offset, String methodName, String methodSignature, String serverHandlerClass, String serverInfo) {
        this.id = id;
        this.className = className;
        this.line = line;
        this.offset = offset;
        this.methodName = methodName;
        this.methodSignature = methodSignature;
        this.serverHandlerClass = serverHandlerClass;
        this.serverInfo = serverInfo;
    }

    public int getBci() {
        return this.bci;
    }

    public String getClassName() {
        return this.className;
    }

    public int getId() {
        return this.id;
    }

    public int getMethodIdx() {
        return this.methodIdx;
    }

    public String getServerHandlerClass() {
        return this.serverHandlerClass;
    }

    public String getServerInfo() {
        return this.serverInfo;
    }

    public boolean resolve(ClassInfo classInfo) {
        if (this.methodIdx != -1) {
            return true;
        }
        return this.methodName != null ? this.resolveMethodName(classInfo) : this.resolveLineNumber(classInfo);
    }

    public String toString() {
        return "RuntimeProfilingPoint [id=" + this.id + ", classname=" + this.className + ", line=" + this.line + ", offset=" + this.offset + ", server handler=" + this.serverHandlerClass + "]";
    }

    private boolean resolveLineNumber(ClassInfo classInfo) {
        try {
            ClassRepository.CodeRegionBCI crbci = ClassRepository.getMethodForSourceRegion(classInfo, this.line, this.line);
            this.methodIdx = classInfo.getMethodIndex(crbci.methodName, crbci.methodSignature);
            this.bci = this.offset == Integer.MAX_VALUE ? crbci.bci1 : crbci.bci0;
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean resolveMethodName(ClassInfo classInfo) {
        if (this.methodSignature != null) {
            this.methodIdx = classInfo.getMethodIndex(this.methodName, this.methodSignature);
        } else {
            String[] allNames = classInfo.getMethodNames();
            for (int i = 0; i < allNames.length; ++i) {
                if (!this.methodName.equals(allNames[i])) continue;
                this.methodIdx = i;
                break;
            }
        }
        if (this.methodIdx == -1) {
            return false;
        }
        this.bci = classInfo.getLineNumberTables().getStartPCs()[this.methodIdx][0];
        return true;
    }

    public static class HitEvent {
        private final int id;
        private final int threadId;
        private final long timestamp;

        public HitEvent(int id, long timestamp, int threadId) {
            this.id = id;
            this.timestamp = timestamp;
            this.threadId = threadId;
        }

        public int getId() {
            return this.id;
        }

        public int getThreadId() {
            return this.threadId;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public String toString() {
            return "HitEvent [id=" + this.getId() + ", thread id=" + this.getThreadId() + ", timestamp=" + this.getTimestamp() + "]";
        }
    }
}

