/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.wireprotocol;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Comparator;
import org.netbeans.lib.profiler.client.RuntimeProfilingPoint;
import org.netbeans.lib.profiler.wireprotocol.Command;

public class InitiateInstrumentationCommand
extends Command {
    private String[] classNames;
    private String[] profilingPointHandlers;
    private int[] profilingPointIDs;
    private String[] profilingPointInfos;
    private boolean instrSpawnedThreads;
    private boolean startProfilingPointsActive;
    private int instrType;

    public InitiateInstrumentationCommand(int instrType, String className, boolean instrSpawnedThreads, boolean startProfilingPointsActive) {
        super(13);
        this.instrType = instrType;
        if (className == null) {
            className = " ";
        }
        this.classNames = new String[1];
        this.classNames[0] = className;
        this.instrSpawnedThreads = instrSpawnedThreads;
        this.startProfilingPointsActive = startProfilingPointsActive;
    }

    public InitiateInstrumentationCommand(int instrType, String[] classNames, boolean instrSpawnedThreads, boolean startProfilingPointsActive) {
        super(13);
        if (classNames == null) {
            classNames = new String[]{" "};
        } else if (classNames[0] == null) {
            classNames[0] = " ";
        }
        this.instrType = instrType;
        this.classNames = classNames;
        this.instrSpawnedThreads = instrSpawnedThreads;
        this.startProfilingPointsActive = startProfilingPointsActive;
    }

    public InitiateInstrumentationCommand(int instrType, String className, boolean startProfilingPointsActive) {
        super(13);
        this.instrType = instrType;
        this.classNames = new String[1];
        this.classNames[0] = className;
        this.instrSpawnedThreads = false;
        this.startProfilingPointsActive = startProfilingPointsActive;
    }

    InitiateInstrumentationCommand() {
        super(13);
    }

    public boolean getInstrSpawnedThreads() {
        return this.instrSpawnedThreads;
    }

    public void setInstrType(int t) {
        this.instrType = t;
    }

    public int getInstrType() {
        return this.instrType;
    }

    public String[] getProfilingPointHandlers() {
        return this.profilingPointHandlers;
    }

    public int[] getProfilingPointIDs() {
        return this.profilingPointIDs;
    }

    public String[] getProfilingPointInfos() {
        return this.profilingPointInfos;
    }

    public void setProfilingPoints(RuntimeProfilingPoint[] points) {
        this.profilingPointHandlers = new String[points.length];
        this.profilingPointInfos = new String[points.length];
        this.profilingPointIDs = new int[points.length];
        Arrays.sort(points, new ByIdComparator());
        for (int i = 0; i < points.length; ++i) {
            RuntimeProfilingPoint point = points[i];
            this.profilingPointIDs[i] = point.getId();
            this.profilingPointHandlers[i] = point.getServerHandlerClass();
            this.profilingPointInfos[i] = point.getServerInfo();
        }
    }

    public String getRootClassName() {
        return this.classNames[0];
    }

    public String[] getRootClassNames() {
        return this.classNames;
    }

    public boolean isStartProfilingPointsActive() {
        return this.startProfilingPointsActive;
    }

    public String toString() {
        return super.toString() + ", instrType = " + this.instrType;
    }

    void readObject(ObjectInputStream in) throws IOException {
        this.instrType = in.readInt();
        int len = in.readInt();
        this.classNames = new String[len];
        for (int i = 0; i < len; ++i) {
            this.classNames[i] = in.readUTF().intern();
        }
        this.instrSpawnedThreads = in.readBoolean();
        this.startProfilingPointsActive = in.readBoolean();
        try {
            this.profilingPointIDs = (int[])in.readObject();
            this.profilingPointHandlers = (String[])in.readObject();
            this.profilingPointInfos = (String[])in.readObject();
        }
        catch (ClassNotFoundException e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
    }

    void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.instrType);
        out.writeInt(this.classNames.length);
        for (int i = 0; i < this.classNames.length; ++i) {
            out.writeUTF(this.classNames[i]);
        }
        out.writeBoolean(this.instrSpawnedThreads);
        out.writeBoolean(this.startProfilingPointsActive);
        out.writeObject(this.profilingPointIDs);
        out.writeObject(this.profilingPointHandlers);
        out.writeObject(this.profilingPointInfos);
    }

    private static final class ByIdComparator
    implements Comparator {
        private ByIdComparator() {
        }

        public int compare(Object o1, Object o2) {
            return ((RuntimeProfilingPoint)o1).getId() - ((RuntimeProfilingPoint)o2).getId();
        }
    }
}

