/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk;

import javax.swing.AbstractButton;
import javax.swing.JPanel;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.modules.profiler.heapwalk.AbstractTopLevelController;
import org.netbeans.modules.profiler.heapwalk.ClassesListController;
import org.netbeans.modules.profiler.heapwalk.FieldsBrowserController;
import org.netbeans.modules.profiler.heapwalk.HeapFragmentWalker;
import org.netbeans.modules.profiler.heapwalk.NavigationHistoryManager;
import org.netbeans.modules.profiler.heapwalk.ui.ClassesControllerUI;

public class ClassesController
extends AbstractTopLevelController
implements FieldsBrowserController.Handler,
NavigationHistoryManager.NavigationHistoryCapable {
    private ClassesListController classesListController;
    private FieldsBrowserController staticFieldsBrowserController;
    private HeapFragmentWalker heapFragmentWalker;

    public ClassesController(HeapFragmentWalker heapFragmentWalker) {
        this.heapFragmentWalker = heapFragmentWalker;
        this.classesListController = new ClassesListController(this);
        this.staticFieldsBrowserController = new FieldsBrowserController(this, 1);
    }

    public ClassesListController getClassesListController() {
        return this.classesListController;
    }

    public Configuration getCurrentConfiguration() {
        long selectedClassID = -1L;
        JavaClass selectedClass = this.getSelectedClass();
        if (selectedClass != null) {
            selectedClassID = selectedClass.getJavaClassId();
        }
        return new Configuration(selectedClassID);
    }

    public HeapFragmentWalker getHeapFragmentWalker() {
        return this.heapFragmentWalker;
    }

    public JavaClass getSelectedClass() {
        return this.classesListController.getSelectedClass();
    }

    public FieldsBrowserController getStaticFieldsBrowserController() {
        return this.staticFieldsBrowserController;
    }

    public void classSelected() {
        JavaClass selectedClass = this.getSelectedClass();
        this.staticFieldsBrowserController.setJavaClass(selectedClass);
    }

    public void configure(NavigationHistoryManager.Configuration configuration) {
        if (configuration instanceof Configuration) {
            Configuration c = (Configuration)configuration;
            this.heapFragmentWalker.switchToHistoryClassesView();
            JavaClass selectedClass = null;
            long selectedClassID = c.getJavaClassID();
            if (selectedClassID != -1L) {
                selectedClass = this.heapFragmentWalker.getHeapFragment().getJavaClassByID(selectedClassID);
            }
            if (selectedClass != null) {
                this.classesListController.selectClass(selectedClass);
            }
        } else {
            throw new IllegalArgumentException("Unsupported configuration: " + configuration);
        }
    }

    public void showClass(JavaClass javaClass) {
        this.heapFragmentWalker.switchToClassesView();
        if (!this.classesListController.getPanel().isVisible()) {
            this.classesListController.getPanel().setVisible(true);
        }
        this.classesListController.selectClass(javaClass);
    }

    public void showInstance(Instance instance) {
        this.heapFragmentWalker.getInstancesController().showInstance(instance);
    }

    protected AbstractButton[] createClientPresenters() {
        return new AbstractButton[]{this.classesListController.getPresenter(), this.staticFieldsBrowserController.getPresenter()};
    }

    protected AbstractButton createControllerPresenter() {
        return ((ClassesControllerUI)this.getPanel()).getPresenter();
    }

    protected JPanel createControllerUI() {
        return new ClassesControllerUI(this);
    }

    public static class Configuration
    extends NavigationHistoryManager.Configuration {
        private long javaClassID;

        public Configuration(long javaClassID) {
            this.javaClassID = javaClassID;
        }

        public long getJavaClassID() {
            return this.javaClassID;
        }
    }
}

