/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.TargetAppRunner;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.common.event.ProfilingStateEvent;
import org.netbeans.lib.profiler.common.event.ProfilingStateListener;
import org.netbeans.lib.profiler.results.RuntimeCCTNode;
import org.netbeans.lib.profiler.results.cpu.CPUCCTProvider;
import org.netbeans.lib.profiler.results.cpu.CPUResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.MemoryCCTProvider;
import org.netbeans.lib.profiler.ui.LiveResultsPanel;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.charts.ChartActionListener;
import org.netbeans.lib.profiler.ui.charts.SynchronousXYChart;
import org.netbeans.lib.profiler.ui.components.FlatToolBar;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.lib.profiler.ui.cpu.CPUResUserActionsHandler;
import org.netbeans.lib.profiler.ui.cpu.CodeRegionLivePanel;
import org.netbeans.lib.profiler.ui.cpu.FlatProfilePanel;
import org.netbeans.lib.profiler.ui.cpu.LiveFlatProfilePanel;
import org.netbeans.lib.profiler.ui.cpu.statistics.StatisticalModuleContainer;
import org.netbeans.lib.profiler.ui.graphs.GraphPanel;
import org.netbeans.lib.profiler.ui.memory.ActionsHandler;
import org.netbeans.lib.profiler.ui.memory.LiveAllocResultsPanel;
import org.netbeans.lib.profiler.ui.memory.LiveLivenessResultsPanel;
import org.netbeans.lib.profiler.ui.memory.MemoryResUserActionsHandler;
import org.netbeans.modules.profiler.History;
import org.netbeans.modules.profiler.HistoryListener;
import org.netbeans.modules.profiler.HistoryPanel;
import org.netbeans.modules.profiler.LoadedSnapshot;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.ResultsListener;
import org.netbeans.modules.profiler.ResultsManager;
import org.netbeans.modules.profiler.SaveViewAction;
import org.netbeans.modules.profiler.SnapshotResultsWindow;
import org.netbeans.modules.profiler.TelemetryWindow;
import org.netbeans.modules.profiler.actions.ResetResultsAction;
import org.netbeans.modules.profiler.actions.TakeSnapshotAction;
import org.netbeans.modules.profiler.ui.stp.ProfilingSettingsManager;
import org.netbeans.modules.profiler.ui.stp.Utils;
import org.netbeans.modules.profiler.utils.IDEUtils;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;

public final class LiveResultsWindow
extends TopComponent
implements ResultsListener,
ProfilingStateListener,
HistoryListener,
SaveViewAction.ViewProvider {
    private static final Logger LOGGER = Logger.getLogger("org.netbeans.modules.profiler.LiveResultsWindow");
    private static final String UPDATE_RESULTS_AUTOMATICALLY_TOOLTIP = NbBundle.getMessage(LiveResultsWindow.class, (String)"LiveResultsWindow_UpdateResultsAutomaticallyTooltip");
    private static final String UPDATE_RESULTS_NOW_TOOLTIP = NbBundle.getMessage(LiveResultsWindow.class, (String)"LiveResultsWindow_UpdateResultsNowTooltip");
    private static final String RUN_GC_TOOLTIP = NbBundle.getMessage(LiveResultsWindow.class, (String)"LiveResultsWindow_RunGCTooltip");
    private static final String NO_PROFILING_RESULTS_LABEL_TEXT = NbBundle.getMessage(LiveResultsWindow.class, (String)"LiveResultsWindow_NoProfilingResultsLabelText");
    private static final String ERROR_DISPLAYING_STACK_TRACES_MSG = NbBundle.getMessage(LiveResultsWindow.class, (String)"LiveResultsWindow_ErrorDisplayingStackTracesMsg");
    private static final String ERROR_DISPLAYING_CALL_GRAPH_MSG = NbBundle.getMessage(LiveResultsWindow.class, (String)"LiveResultsWindow_ErrorDisplayingCallGraphMsg");
    private static final String ERROR_INSTRUMENTING_ROOT_METHOD_MSG = NbBundle.getMessage(LiveResultsWindow.class, (String)"LiveResultsWindow_ErrorInstrumentingRootMethodMsg");
    private static final String LIVE_RESULTS_TAB_NAME = NbBundle.getMessage(LiveResultsWindow.class, (String)"LiveResultsWindow_LiveResultsTabName");
    private static final String HISTORY_TAB_NAME = NbBundle.getMessage(LiveResultsWindow.class, (String)"LiveResultsWindow_HistoryTabName");
    private static final String LIVE_RESULTS_ACCESS_DESCR = NbBundle.getMessage(LiveResultsWindow.class, (String)"LiveResultsWindow_LiveResultsAccessDescr");
    private static final String ZOOM_IN_TOOLTIP = NbBundle.getMessage(TelemetryWindow.class, (String)"TelemetryWindow_ZoomInTooltip");
    private static final String ZOOM_OUT_TOOLTIP = NbBundle.getMessage(TelemetryWindow.class, (String)"TelemetryWindow_ZoomOutTooltip");
    private static final String FIXED_SCALE_TOOLTIP = NbBundle.getMessage(TelemetryWindow.class, (String)"TelemetryWindow_FixedScaleTooltip");
    private static final String SCALE_TO_FIT_TOOLTIP = NbBundle.getMessage(TelemetryWindow.class, (String)"TelemetryWindow_ScaleToFitTooltip");
    private static final String HELP_CTX_KEY = "LiveResultsWindow.HelpCtx";
    private static final HelpCtx HELP_CTX = new HelpCtx("LiveResultsWindow.HelpCtx");
    private static LiveResultsWindow defaultLiveInstance;
    private static final TargetAppRunner runner;
    private static final Image liveWindowIcon;
    private static final AtomicBoolean resultsDumpForced;
    GraphTab graphTab;
    private JToolBar.Separator graphButtonsSeparator;
    private CPUResUserActionsHandler cpuActionsHandler;
    private Component lastFocusOwner;
    private EmptyLiveResultsPanel noResultsPanel;
    private JButton runGCButton;
    private JButton updateNowButton;
    private JPanel currentDisplayComponent;
    private JPanel memoryTabPanel;
    private JTabbedPane tabs;
    private JToggleButton autoToggle;
    private JToolBar toolBar;
    private LiveResultsPanel currentDisplay;
    private MemoryResUserActionsHandler memoryActionsHandler;
    private boolean autoRefresh = true;
    private boolean drillDownGroupOpened;
    private volatile boolean profilerRunning = false;
    private volatile boolean resultsAvailable = false;

    public LiveResultsWindow() {
        this.setName(NbBundle.getMessage(LiveResultsWindow.class, (String)"LAB_ResultsWindowName"));
        this.setIcon(liveWindowIcon);
        this.getAccessibleContext().setAccessibleDescription(LIVE_RESULTS_ACCESS_DESCR);
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.memoryActionsHandler = new MemoryActionsHandler();
        this.cpuActionsHandler = new CPUActionsHandler();
        this.toolBar = this.createToolBar();
        this.toolBar.setBorder(new EmptyBorder(5, 5, 0, 5));
        this.add(this.toolBar, "North");
        this.noResultsPanel = new EmptyLiveResultsPanel();
        this.noResultsPanel.setLayout(new BorderLayout());
        this.noResultsPanel.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        JLabel noResultsLabel = new JLabel(NO_PROFILING_RESULTS_LABEL_TEXT);
        noResultsLabel.setFont(noResultsLabel.getFont().deriveFont(14));
        noResultsLabel.setIcon(new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/profiler/ui/resources/monitoring.png")));
        noResultsLabel.setIconTextGap(10);
        noResultsLabel.setEnabled(false);
        noResultsLabel.setOpaque(false);
        this.noResultsPanel.add((Component)noResultsLabel, "North");
        this.noResultsPanel.setOpaque(false);
        this.currentDisplay = null;
        this.currentDisplayComponent = this.noResultsPanel;
        this.add(this.noResultsPanel, "Center");
        this.memoryTabPanel = new JPanel(new BorderLayout());
        this.memoryTabPanel.setOpaque(false);
        this.tabs = new JTabbedPane();
        this.tabs.setOpaque(true);
        this.tabs.setBackground(new HTMLTextArea().getBackground());
        this.tabs.getActionMap().getParent().remove("navigatePageUp");
        this.tabs.getActionMap().getParent().remove("navigatePageDown");
        this.memoryTabPanel.add((Component)this.tabs, "Center");
        this.tabs.setTabPlacement(3);
        this.tabs.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                LiveResultsWindow.this.updateGraphButtons();
            }
        });
        this.graphTab = new GraphTab(new HistoryPanel(History.getInstance()));
        History.getInstance().addHistoryListener(this);
        this.graphButtonsSeparator = new JToolBar.Separator();
        this.toolBar.add(this.graphButtonsSeparator);
        this.toolBar.add(this.graphTab.zoomInButton);
        this.toolBar.add(this.graphTab.zoomOutButton);
        this.toolBar.add(this.graphTab.scaleToFitButton);
        this.updateGraphButtons();
        this.setFocusable(true);
        this.setRequestFocusEnabled(true);
        Profiler.getDefault().addProfilingStateListener((ProfilingStateListener)this);
        ResultsManager.getDefault().addResultsListener(this);
    }

    public static synchronized LiveResultsWindow getDefault() {
        if (!LiveResultsWindow.hasDefault()) {
            IDEUtils.runInEventDispatchThreadAndWait(new Runnable(){

                public void run() {
                    defaultLiveInstance = new LiveResultsWindow();
                }
            });
        }
        return defaultLiveInstance;
    }

    public static void setPaused(boolean value) {
    }

    public static void closeIfOpened() {
        if (LiveResultsWindow.hasDefault()) {
            IDEUtils.runInEventDispatchThread(new Runnable(){

                public void run() {
                    if (defaultLiveInstance.isOpened()) {
                        defaultLiveInstance.close();
                    }
                }
            });
        }
    }

    public static boolean hasDefault() {
        return defaultLiveInstance != null;
    }

    public void setAutoRefresh(boolean value) {
        if (this.autoRefresh != value) {
            this.autoRefresh = value;
            this.autoToggle.setSelected(value);
        }
    }

    public boolean isAutoRefresh() {
        return this.autoRefresh;
    }

    public HelpCtx getHelpCtx() {
        return HELP_CTX;
    }

    public int getPersistenceType() {
        return 2;
    }

    public int getSortingColumn() {
        if (this.currentDisplay == null) {
            return -1;
        }
        return this.currentDisplay.getSortingColumn();
    }

    public boolean getSortingOrder() {
        if (this.currentDisplay == null) {
            return false;
        }
        return this.currentDisplay.getSortingOrder();
    }

    public BufferedImage getViewImage(boolean onlyVisibleArea) {
        if (this.currentDisplayComponent == this.memoryTabPanel && this.tabs.getSelectedComponent() == this.graphTab) {
            return UIUtils.createScreenshot((Component)this.graphTab.panel);
        }
        if (this.currentDisplay == null) {
            return null;
        }
        return this.currentDisplay.getViewImage(onlyVisibleArea);
    }

    public String getViewName() {
        if (this.currentDisplayComponent == this.memoryTabPanel && this.tabs.getSelectedComponent() == this.graphTab) {
            return "memory-history-" + History.getInstance().getClassName();
        }
        if (this.currentDisplay == null) {
            return null;
        }
        return this.currentDisplay.getViewName();
    }

    public void componentActivated() {
        super.componentActivated();
        if (this.lastFocusOwner != null) {
            this.lastFocusOwner.requestFocus();
        } else if (this.currentDisplayComponent != null) {
            this.currentDisplayComponent.requestFocus();
        }
    }

    public void componentDeactivated() {
        super.componentDeactivated();
        this.lastFocusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
    }

    public boolean fitsVisibleArea() {
        if (this.currentDisplayComponent == this.memoryTabPanel && this.tabs.getSelectedComponent() == this.graphTab) {
            return true;
        }
        return this.currentDisplay != null && this.currentDisplay.fitsVisibleArea();
    }

    public void handleShutdown() {
        this.profilerRunning = false;
        if (this.isShowing()) {
            this.hideDrillDown();
            this.requestProfilingDataUpdate(false);
        }
    }

    public void handleStartup() {
        this.profilerRunning = true;
    }

    public boolean hasView() {
        if (this.currentDisplayComponent == this.memoryTabPanel && this.tabs.getSelectedComponent() == this.graphTab) {
            return true;
        }
        return !this.noResultsPanel.isShowing() && this.currentDisplay != null && this.currentDisplay.hasView();
    }

    public void historyLogging() {
        if (this.currentDisplay instanceof LiveAllocResultsPanel || this.currentDisplay instanceof LiveLivenessResultsPanel) {
            this.tabs.setEnabledAt(1, true);
            this.tabs.setTitleAt(1, NbBundle.getMessage(LiveResultsWindow.class, (String)"LiveResultsWindow_ClassHistoryTabName", (Object[])new Object[]{History.getInstance().getClassName()}));
            this.tabs.setSelectedIndex(1);
        }
    }

    public void ideClosing() {
        this.hideDrillDown();
    }

    public void instrumentationChanged(int oldInstrType, int currentInstrType) {
        this.requestProfilingDataUpdate(false);
    }

    public void profilingStateChanged(ProfilingStateEvent e) {
        this.updateActions(e.getNewState());
        switch (e.getNewState()) {
            case 1: {
                this.handleShutdown();
                break;
            }
            case 4: {
                this.handleStartup();
            }
        }
    }

    public boolean refreshLiveResults() {
        if (this.isAutoRefresh() && this.isShowing()) {
            this.requestProfilingDataUpdate(false);
            return true;
        }
        if (NetBeansProfiler.getDefaultNB().processesProfilingPoints()) {
            LiveResultsWindow.callForceObtainedResultsDump(runner.getProfilerClient(), false);
        }
        return false;
    }

    public void resultsAvailable() {
    }

    public void resultsReset() {
        this.reset();
    }

    public void threadsMonitoringChanged() {
    }

    protected void componentClosed() {
        super.componentClosed();
    }

    protected void componentHidden() {
        super.componentHidden();
        this.hideDrillDown();
    }

    protected void componentOpened() {
        super.componentOpened();
    }

    protected void componentShowing() {
        super.componentShowing();
        this.updateResultsDisplay();
    }

    protected String preferredID() {
        return this.getClass().getName();
    }

    void reset() {
        this.resultsAvailable = false;
        if (this.currentDisplay != null) {
            this.currentDisplay.reset();
            this.resetResultsDisplay();
        }
        this.resetDrillDown();
    }

    private static boolean callForceObtainedResultsDump(ProfilerClient client) {
        return LiveResultsWindow.callForceObtainedResultsDump(client, true);
    }

    private static boolean callForceObtainedResultsDump(ProfilerClient client, boolean refreshDisplay) {
        if (refreshDisplay) {
            resultsDumpForced.set(true);
        }
        try {
            if (client.getCurrentInstrType() != 1) {
                client.forceObtainedResultsDump(true);
            }
            return true;
        }
        catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
            return false;
        }
    }

    private boolean isProfiling() {
        return runner.getProfilerClient().getCurrentInstrType() != 0;
    }

    private static boolean checkIfResultsExist(ProfilerClient client, int currentInstrType) {
        switch (currentInstrType) {
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return LiveResultsWindow.getDefault().resultsAvailable;
            }
            case 1: {
                try {
                    return client.cpuResultsExist();
                }
                catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
                    return false;
                }
            }
        }
        return false;
    }

    private JToolBar createToolBar() {
        FlatToolBar toolBar = new FlatToolBar(){

            public Component add(Component comp) {
                if (comp instanceof JButton) {
                    UIUtils.fixButtonUI((AbstractButton)((JButton)comp));
                }
                return super.add(comp);
            }
        };
        toolBar.setFloatable(false);
        toolBar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        this.autoToggle = new JToggleButton(new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/profiler/resources/autoRefresh.png")));
        this.autoToggle.setSelected(true);
        this.autoToggle.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LiveResultsWindow.this.autoRefresh = LiveResultsWindow.this.autoToggle.isSelected();
            }
        });
        this.autoToggle.setToolTipText(UPDATE_RESULTS_AUTOMATICALLY_TOOLTIP);
        this.autoToggle.getAccessibleContext().setAccessibleName(UPDATE_RESULTS_AUTOMATICALLY_TOOLTIP);
        this.updateNowButton = new JButton(new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/profiler/resources/updateNow.png")));
        this.updateNowButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LiveResultsWindow.this.requestProfilingDataUpdate(true);
            }
        });
        this.updateNowButton.setToolTipText(UPDATE_RESULTS_NOW_TOOLTIP);
        this.updateNowButton.getAccessibleContext().setAccessibleName(UPDATE_RESULTS_NOW_TOOLTIP);
        this.runGCButton = new JButton(new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/profiler/actions/resources/runGC.png")));
        this.runGCButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    runner.runGC();
                }
                catch (ClientUtils.TargetAppOrVMTerminated ex) {
                    Profiler.getDefault().displayError(ex.getMessage());
                    ProfilerLogger.log((Exception)((Object)ex));
                }
                LiveResultsWindow.this.requestProfilingDataUpdate(true);
            }
        });
        this.runGCButton.setToolTipText(RUN_GC_TOOLTIP);
        this.runGCButton.getAccessibleContext().setAccessibleName(RUN_GC_TOOLTIP);
        toolBar.add(this.autoToggle);
        toolBar.add(this.updateNowButton);
        toolBar.add(this.runGCButton);
        toolBar.add(new ResetResultsAction());
        toolBar.addSeparator();
        toolBar.add(((Presenter.Toolbar)SystemAction.get(TakeSnapshotAction.class)).getToolbarPresenter());
        toolBar.addSeparator();
        toolBar.add(new SaveViewAction(this));
        return toolBar;
    }

    private void hideDrillDown() {
    }

    private LiveResultsPanel preparePanelForInstrType(int instrumentationType) {
        CodeRegionLivePanel aPanel = null;
        switch (instrumentationType) {
            case 4: {
                LiveAllocResultsPanel allocPanel = new LiveAllocResultsPanel(runner, this.memoryActionsHandler, (ActionsHandler)History.getInstance());
                this.currentDisplayComponent = this.memoryTabPanel;
                this.currentDisplayComponent.setBorder(new EmptyBorder(5, 0, 0, 0));
                if (this.tabs.getComponentCount() > 0) {
                    this.tabs.removeAll();
                }
                this.tabs.addTab(LIVE_RESULTS_TAB_NAME, (Component)allocPanel);
                this.tabs.addTab(HISTORY_TAB_NAME, this.graphTab);
                this.tabs.setEnabledAt(1, false);
                aPanel = allocPanel;
                break;
            }
            case 5: {
                LiveLivenessResultsPanel livenessPanel = new LiveLivenessResultsPanel(runner, this.memoryActionsHandler, (ActionsHandler)History.getInstance());
                this.currentDisplayComponent = this.memoryTabPanel;
                this.currentDisplayComponent.setBorder(new EmptyBorder(5, 0, 0, 0));
                if (this.tabs.getComponentCount() > 0) {
                    this.tabs.removeAll();
                }
                this.tabs.addTab(LIVE_RESULTS_TAB_NAME, (Component)livenessPanel);
                this.tabs.addTab(HISTORY_TAB_NAME, this.graphTab);
                this.tabs.setEnabledAt(1, false);
                aPanel = livenessPanel;
                break;
            }
            case 2: 
            case 3: {
                ArrayList additionalStats = new ArrayList();
                runner.getProfilerClient().getMarkFilter().removeAllEvaluators();
                StatisticalModuleContainer container = (StatisticalModuleContainer)Lookup.getDefault().lookup(StatisticalModuleContainer.class);
                additionalStats.addAll(container.getAllModules());
                LiveFlatProfilePanel cpuPanel = new LiveFlatProfilePanel(runner, this.cpuActionsHandler, additionalStats);
                this.currentDisplayComponent = cpuPanel;
                this.currentDisplayComponent.setBorder(new EmptyBorder(5, 5, 5, 5));
                aPanel = cpuPanel;
                break;
            }
            case 1: {
                CodeRegionLivePanel regionPanel = new CodeRegionLivePanel(runner.getProfilerClient());
                this.currentDisplayComponent = regionPanel;
                this.currentDisplayComponent.setBorder(new EmptyBorder(5, 5, 5, 5));
                aPanel = regionPanel;
                break;
            }
            case 0: {
                throw new IllegalStateException();
            }
        }
        return aPanel;
    }

    private void requestProfilingDataUpdate(final boolean force) {
        IDEUtils.runInEventDispatchThread(new Runnable(){

            public void run() {
                if (!LiveResultsWindow.this.isAutoRefresh() && !force) {
                    return;
                }
                if (!LiveResultsWindow.this.isProfiling() || !LiveResultsWindow.this.isShowing()) {
                    return;
                }
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        LiveResultsWindow.callForceObtainedResultsDump(runner.getProfilerClient());
                    }
                });
            }
        });
    }

    private void resetDrillDown() {
    }

    private void resetResultsDisplay() {
        if (this.currentDisplayComponent != null && this.currentDisplayComponent != this.noResultsPanel) {
            this.remove(this.currentDisplayComponent);
            this.currentDisplay = null;
            this.currentDisplayComponent = this.noResultsPanel;
            this.add(this.noResultsPanel, "Center");
            this.graphButtonsSeparator.setVisible(false);
            this.graphTab.zoomInButton.setVisible(false);
            this.graphTab.zoomOutButton.setVisible(false);
            this.graphTab.scaleToFitButton.setVisible(false);
            this.revalidate();
            this.repaint();
            this.hideDrillDown();
        }
    }

    private void showDrillDown() {
    }

    private void updateActions(int newState) {
        this.runGCButton.setEnabled(newState == 4);
        this.updateNowButton.setEnabled(newState == 4);
    }

    private void updateDrillDown() {
    }

    private void updateGraphButtons() {
        boolean graphVisible = this.currentDisplayComponent == this.memoryTabPanel && this.tabs.getSelectedComponent() == this.graphTab;
        this.graphButtonsSeparator.setVisible(graphVisible);
        this.graphTab.zoomInButton.setVisible(graphVisible);
        this.graphTab.zoomOutButton.setVisible(graphVisible);
        this.graphTab.scaleToFitButton.setVisible(graphVisible);
    }

    private void updateResultsDisplay() {
        boolean instrSupported;
        if (!this.isShowing()) {
            return;
        }
        if (!resultsDumpForced.getAndSet(false) && !this.isAutoRefresh()) {
            return;
        }
        if (!this.resultsAvailable) {
            this.currentDisplay = null;
            this.currentDisplayComponent = this.noResultsPanel;
            return;
        }
        boolean bl = instrSupported = this.currentDisplayComponent != null && this.currentDisplay != null && this.currentDisplay.supports(runner.getProfilerClient().getCurrentInstrType());
        if (!instrSupported) {
            if (this.currentDisplayComponent != null) {
                this.remove(this.currentDisplayComponent);
            }
            if (this.currentDisplay != null) {
                this.currentDisplay.handleRemove();
            }
            this.currentDisplay = this.preparePanelForInstrType(runner.getProfilerClient().getCurrentInstrType());
            this.add(this.currentDisplayComponent, "Center");
            this.revalidate();
            this.repaint();
            this.updateGraphButtons();
            IDEUtils.runInEventDispatchThread(new Runnable(){

                public void run() {
                    LiveResultsWindow.this.currentDisplayComponent.requestFocusInWindow();
                }
            });
        }
        if (this.currentDisplay != null) {
            this.currentDisplay.updateLiveResults();
        }
        this.updateDrillDown();
    }

    static {
        runner = Profiler.getDefault().getTargetAppRunner();
        liveWindowIcon = Utilities.loadImage((String)"org/netbeans/modules/profiler/resources/liveResultsWindow.png");
        resultsDumpForced = new AtomicBoolean(false);
    }

    private final class MemoryActionsHandler
    implements MemoryResUserActionsHandler {
        private MemoryActionsHandler() {
        }

        public void showSourceForMethod(String className, String methodName, String methodSig) {
            if (className.length() == 1 && ("Z".equals(className) || "C".equals(className) || "B".equals(className) || "S".equals(className) || "I".equals(className) || "J".equals(className) || "F".equals(className) || "D".equals(className))) {
                Profiler.getDefault().displayWarning(CANNOT_SHOW_PRIMITIVE_SRC_MSG);
                return;
            }
            Profiler.getDefault().openJavaSource(className, methodName, methodSig);
        }

        public void showStacksForClass(final int selectedClassId, final int sortingColumn, final boolean sortingOrder) {
            IDEUtils.runInProfilerRequestProcessor(new Runnable(){

                public void run() {
                    final LoadedSnapshot ls = ResultsManager.getDefault().takeSnapshot();
                    if (ls != null) {
                        IDEUtils.runInEventDispatchThread(new Runnable(){

                            public void run() {
                                SnapshotResultsWindow srw = SnapshotResultsWindow.get(ls, sortingColumn, sortingOrder);
                                if (srw != null) {
                                    srw.displayStacksForClass(selectedClassId, sortingColumn, sortingOrder);
                                }
                            }
                        });
                    }
                }
            });
        }
    }

    private static final class GraphTab
    extends JPanel
    implements ActionListener,
    ChartActionListener {
        private static final ImageIcon zoomInIcon = new ImageIcon(Utilities.loadImage((String)"org/netbeans/lib/profiler/ui/resources/zoomIn.png"));
        private static final ImageIcon zoomOutIcon = new ImageIcon(Utilities.loadImage((String)"org/netbeans/lib/profiler/ui/resources/zoomOut.png"));
        private static final ImageIcon zoomIcon = new ImageIcon(Utilities.loadImage((String)"org/netbeans/lib/profiler/ui/resources/zoom.png"));
        private static final ImageIcon scaleToFitIcon = new ImageIcon(Utilities.loadImage((String)"org/netbeans/lib/profiler/ui/resources/scaleToFit.png"));
        final GraphPanel panel;
        final JButton scaleToFitButton;
        final JButton zoomInButton;
        final JButton zoomOutButton;
        private final JScrollBar scrollBar;
        private boolean lastTrackingEnd;
        private double lastScale;
        private long lastOffset;

        public GraphTab(GraphPanel panel) {
            this.panel = panel;
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            boolean scaleToFit = panel.getChart().isFitToWindow();
            this.zoomInButton = new JButton(zoomInIcon);
            this.zoomInButton.setToolTipText(ZOOM_IN_TOOLTIP);
            this.zoomInButton.getAccessibleContext().setAccessibleName(ZOOM_IN_TOOLTIP);
            this.zoomOutButton = new JButton(zoomOutIcon);
            this.zoomOutButton.setToolTipText(ZOOM_OUT_TOOLTIP);
            this.zoomOutButton.getAccessibleContext().setAccessibleName(ZOOM_OUT_TOOLTIP);
            this.scaleToFitButton = new JButton(scaleToFit ? zoomIcon : scaleToFitIcon);
            this.scaleToFitButton.setToolTipText(scaleToFit ? FIXED_SCALE_TOOLTIP : SCALE_TO_FIT_TOOLTIP);
            this.scaleToFitButton.getAccessibleContext().setAccessibleName(scaleToFit ? FIXED_SCALE_TOOLTIP : SCALE_TO_FIT_TOOLTIP);
            this.scrollBar = new JScrollBar(0);
            this.zoomInButton.setEnabled(!scaleToFit);
            this.zoomOutButton.setEnabled(!scaleToFit);
            this.scrollBar.setEnabled(!scaleToFit);
            if (!panel.getChart().containsValidData()) {
                this.scaleToFitButton.setEnabled(false);
                this.zoomInButton.setEnabled(false);
                this.zoomOutButton.setEnabled(false);
            }
            JPanel graphPanel = new JPanel();
            graphPanel.setLayout(new BorderLayout());
            graphPanel.setBorder(new CompoundBorder(new EmptyBorder(new Insets(0, 0, 0, 0)), new BevelBorder(1)));
            graphPanel.add((Component)panel, "Center");
            graphPanel.add((Component)this.scrollBar, "South");
            JPanel legendContainer = new JPanel();
            legendContainer.setOpaque(false);
            legendContainer.setLayout(new FlowLayout(4));
            if (panel.getBigLegendPanel() != null) {
                legendContainer.add(panel.getBigLegendPanel());
            }
            this.add((Component)graphPanel, "Center");
            this.add((Component)legendContainer, "South");
            this.zoomInButton.addActionListener(this);
            this.zoomOutButton.addActionListener(this);
            this.scaleToFitButton.addActionListener(this);
            panel.getChart().associateJScrollBar(this.scrollBar);
            panel.getChart().addChartActionListener((ChartActionListener)this);
        }

        public void actionPerformed(ActionEvent e) {
            SynchronousXYChart xyChart = this.panel.getChart();
            if (e.getSource() == this.scaleToFitButton) {
                if (xyChart.isFitToWindow()) {
                    if (this.lastTrackingEnd) {
                        xyChart.setTrackingEnd(this.lastScale);
                    } else {
                        xyChart.setScaleAndOffsetX(this.lastScale, this.lastOffset);
                    }
                } else {
                    this.lastScale = xyChart.getScale();
                    this.lastOffset = xyChart.getViewOffsetX();
                    this.lastTrackingEnd = xyChart.isTrackingEnd();
                    xyChart.setFitToWindow();
                }
            } else if (e.getSource() == this.zoomInButton) {
                xyChart.setScale(xyChart.getScale() * 2.0);
            } else if (e.getSource() == this.zoomOutButton) {
                xyChart.setScale(xyChart.getScale() / 2.0);
            }
        }

        public void chartDataChanged() {
            this.updateZoomButtons();
        }

        public void chartFitToWindowChanged() {
            if (this.panel.getChart().isFitToWindow()) {
                this.scaleToFitButton.setIcon(zoomIcon);
                this.scaleToFitButton.setToolTipText(FIXED_SCALE_TOOLTIP);
                this.scaleToFitButton.getAccessibleContext().setAccessibleName(FIXED_SCALE_TOOLTIP);
            } else {
                this.scaleToFitButton.setIcon(scaleToFitIcon);
                this.scaleToFitButton.setToolTipText(SCALE_TO_FIT_TOOLTIP);
                this.scaleToFitButton.getAccessibleContext().setAccessibleName(SCALE_TO_FIT_TOOLTIP);
            }
            this.updateZoomButtons();
        }

        public void chartPanned() {
        }

        public void chartTrackingEndChanged() {
        }

        public void chartZoomed() {
            this.updateZoomButtons();
        }

        private void updateZoomButtons() {
            if (!this.panel.getChart().containsValidData()) {
                this.scaleToFitButton.setEnabled(false);
                this.zoomInButton.setEnabled(false);
                this.zoomOutButton.setEnabled(false);
            } else {
                this.scaleToFitButton.setEnabled(true);
                if (this.panel.getChart().isFitToWindow()) {
                    this.zoomInButton.setEnabled(false);
                    this.zoomOutButton.setEnabled(false);
                } else {
                    if (this.panel.getChart().isMaximumZoom()) {
                        this.zoomInButton.setEnabled(false);
                    } else {
                        this.zoomInButton.setEnabled(true);
                    }
                    if (this.panel.getChart().isMinimumZoom()) {
                        this.zoomOutButton.setEnabled(false);
                    } else {
                        this.zoomOutButton.setEnabled(true);
                    }
                }
            }
        }
    }

    private final class CPUActionsHandler
    extends CPUResUserActionsHandler.Adapter {
        private CPUActionsHandler() {
        }

        public void addMethodToRoots(String className, String methodName, String methodSig) {
            ProfilingSettings settingsToModify;
            ProfilingSettings[] projectSettings = ProfilingSettingsManager.getDefault().getProfilingSettings().getProfilingSettings();
            ArrayList<ProfilingSettings> cpuSettings = new ArrayList<ProfilingSettings>();
            for (ProfilingSettings settings : projectSettings) {
                if (!Utils.isCPUSettings(settings.getProfilingType())) continue;
                cpuSettings.add(settings);
            }
            ProfilingSettings lastProfilingSettings = null;
            String lastProfilingSettingsName = Profiler.getDefault().getLastProfilingSettings().getSettingsName();
            for (ProfilingSettings settings : cpuSettings) {
                if (!settings.getSettingsName().equals(lastProfilingSettingsName)) continue;
                lastProfilingSettings = settings;
                break;
            }
            if ((settingsToModify = IDEUtils.selectSettings(16, cpuSettings.toArray(new ProfilingSettings[cpuSettings.size()]), lastProfilingSettings)) == null) {
                return;
            }
            settingsToModify.addRootMethod(className, methodName, methodSig);
            if (cpuSettings.contains(settingsToModify)) {
                ProfilingSettingsManager.getDefault().storeProfilingSettings(projectSettings, settingsToModify);
            } else {
                ProfilingSettings[] newProjectSettings = new ProfilingSettings[projectSettings.length + 1];
                System.arraycopy(projectSettings, 0, newProjectSettings, 0, projectSettings.length);
                newProjectSettings[projectSettings.length] = settingsToModify;
                ProfilingSettingsManager.getDefault().storeProfilingSettings(newProjectSettings, settingsToModify);
            }
        }

        public void showReverseCallGraph(CPUResultsSnapshot snapshot, int threadId, int methodId, int view, int sortingColumn, boolean sortingOrder) {
            throw new IllegalStateException(ERROR_DISPLAYING_CALL_GRAPH_MSG);
        }

        public void showSourceForMethod(String className, String methodName, String methodSig) {
            Profiler.getDefault().openJavaSource(className, methodName, methodSig);
        }

        public void viewChanged(int viewType) {
            if (LiveResultsWindow.this.currentDisplay != null) {
                ((FlatProfilePanel)LiveResultsWindow.this.currentDisplay).prepareResults();
            }
        }
    }

    public static class ActivateDrillDownAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            if (TopComponent.getRegistry().getActivated() == LiveResultsWindow.getDefault()) {
                // empty if block
            }
        }
    }

    public static final class ResultsMonitor
    implements CPUCCTProvider.Listener,
    MemoryCCTProvider.Listener {
        public void cctEstablished(RuntimeCCTNode runtimeCCTNode, boolean empty) {
            if (!empty) {
                LiveResultsWindow.getDefault().resultsAvailable = true;
                IDEUtils.runInEventDispatchThread(new Runnable(){

                    public void run() {
                        LiveResultsWindow.getDefault().updateResultsDisplay();
                    }
                });
            } else {
                resultsDumpForced.set(false);
            }
        }

        public void cctReset() {
            LiveResultsWindow.getDefault().resultsAvailable = false;
        }
    }

    public static final class EmptyLiveResultsPanel
    extends JPanel
    implements LiveResultsPanel {
        public int getSortingColumn() {
            return -1;
        }

        public boolean getSortingOrder() {
            return true;
        }

        public BufferedImage getViewImage(boolean b) {
            throw new UnsupportedOperationException();
        }

        public String getViewName() {
            return "Empty live results";
        }

        public boolean fitsVisibleArea() {
            return false;
        }

        public void handleRemove() {
        }

        public void handleShutdown() {
        }

        public boolean hasView() {
            return false;
        }

        public void reset() {
        }

        public boolean supports(int instrumentationType) {
            return true;
        }

        public void updateLiveResults() {
        }
    }
}

