/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.openide.awt.MouseUtils;
import org.openide.explorer.view.BeanTreeView;
import org.openide.explorer.view.NodeTableModel;
import org.openide.explorer.view.NodeTreeModel;
import org.openide.explorer.view.TreeTable;
import org.openide.explorer.view.TreeView;
import org.openide.explorer.view.Visualizer;
import org.openide.explorer.view.VisualizerNode;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class TreeTableView
extends BeanTreeView {
    private static final String COLUMNS_ICON = "/org/netbeans/modules/openide/explorer/columns.gif";
    private static final String SORT_ASC_ICON = "org/netbeans/modules/openide/explorer/columnsSortedAsc.gif";
    private static final String SORT_DESC_ICON = "org/netbeans/modules/openide/explorer/columnsSortedDesc.gif";
    protected JTable treeTable;
    private NodeTableModel tableModel;
    private JScrollBar hScrollBar;
    private JScrollPane scrollPane;
    private ScrollListener listener;
    private boolean allowHideColumns = false;
    private boolean allowSortingByColumn = false;
    private boolean hideHScrollBar = false;
    private JButton colsButton = null;
    private SortedNodeTreeModel sortedNodeTreeModel;
    private ActionListener defaultTreeActionListener;
    private TableCellRenderer defaultHeaderRenderer = null;
    private MouseUtils.PopupMouseAdapter tableMouseListener;
    private AccessibleContext accessContext;
    private TreeColumnProperty treeColumnProperty = new TreeColumnProperty();
    private int treeColumnWidth;
    private Component treeTableParent = null;

    public TreeTableView() {
        this(new NodeTableModel());
    }

    public TreeTableView(NodeTableModel nodeTableModel) {
        this.tableModel = nodeTableModel;
        this.initializeTreeTable();
        this.setPopupAllowed(true);
        this.setDefaultActionAllowed(true);
        this.initializeTreeScrollSupport();
        CompoundScrollPane compoundScrollPane = new CompoundScrollPane();
        compoundScrollPane.setLayout(new BorderLayout());
        this.scrollPane.setViewportView(this.treeTable);
        compoundScrollPane.add("Center", this.scrollPane);
        ImageIcon imageIcon = new ImageIcon(TreeTable.class.getResource(COLUMNS_ICON));
        this.colsButton = new JButton(imageIcon);
        this.colsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TreeTableView.this.selectVisibleColumns();
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0, 0, 0));
        jPanel.add(this.hScrollBar);
        compoundScrollPane.add("South", jPanel);
        super.setHorizontalScrollBarPolicy(31);
        super.setVerticalScrollBarPolicy(21);
        this.setViewportView(compoundScrollPane);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setViewportBorder(BorderFactory.createEmptyBorder());
    }

    public void setRowHeader(JViewport jViewport) {
        jViewport.setBorder(BorderFactory.createEmptyBorder());
        super.setRowHeader(jViewport);
    }

    public void setHorizontalScrollBarPolicy(int n) {
        boolean bl = this.hideHScrollBar = n == 31;
        if (this.hideHScrollBar) {
            this.hScrollBar.setVisible(false);
            ((TreeTable)this.treeTable).setTreeHScrollingEnabled(false);
        }
    }

    public void setVerticalScrollBarPolicy(int n) {
        if (this.scrollPane == null) {
            return;
        }
        boolean bl = this.allowHideColumns = n == 22;
        if (this.allowHideColumns) {
            this.scrollPane.setCorner("UPPER_RIGHT_CORNER", this.colsButton);
        }
        this.treeTable.getTableHeader().setReorderingAllowed(this.allowHideColumns);
        this.scrollPane.setVerticalScrollBarPolicy(n);
    }

    protected NodeTreeModel createModel() {
        return this.getSortedNodeTreeModel();
    }

    public void requestFocus() {
        if (this.treeTable != null) {
            this.treeTable.requestFocus();
        }
    }

    public boolean requestFocusInWindow() {
        boolean bl = super.requestFocusInWindow();
        if (null != this.treeTable) {
            this.treeTable.requestFocus();
        }
        return bl;
    }

    private void setAllowSortingByColumn(boolean bl) {
        if (bl && bl != this.allowSortingByColumn) {
            this.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    JTableHeader jTableHeader;
                    int n;
                    if (mouseEvent.getClickCount() == 0) {
                        return;
                    }
                    Component component = mouseEvent.getComponent();
                    if (component instanceof JTableHeader && (n = (jTableHeader = (JTableHeader)component).columnAtPoint(mouseEvent.getPoint())) >= 0) {
                        TreeTableView.this.clickOnColumnAction(n - 1);
                    }
                }
            });
        }
        this.allowSortingByColumn = bl;
    }

    private void clickOnColumnAction(int n) {
        if (n == -1) {
            if (this.treeColumnProperty.isComparable()) {
                if (this.treeColumnProperty.isSortingColumn()) {
                    if (!this.treeColumnProperty.isSortOrderDescending()) {
                        this.setSortingOrder(false);
                    } else {
                        this.noSorting();
                    }
                } else {
                    int n2 = this.tableModel.translateVisibleColumnIndex(n);
                    this.setSortingColumn(n);
                    this.setSortingOrder(true);
                }
            }
        } else if (this.tableModel.isComparableColumn(n)) {
            if (this.tableModel.isSortingColumnEx(this.tableModel.translateVisibleColumnIndex(n))) {
                if (!this.tableModel.isSortOrderDescending()) {
                    this.setSortingOrder(false);
                } else {
                    this.noSorting();
                }
            } else {
                int n3 = this.tableModel.translateVisibleColumnIndex(n);
                this.setSortingColumn(n3);
                this.setSortingOrder(true);
            }
        }
    }

    private void selectVisibleColumns() {
        this.setCurrentWidths();
        String string = null;
        if (this.getParent() != null) {
            string = this.getParent().getName();
        }
        if (this.tableModel.selectVisibleColumns(string, this.treeTable.getColumnName(0), this.getSortedNodeTreeModel().getRootDescription())) {
            if (this.tableModel.getSortingColumn() == -1) {
                this.getSortedNodeTreeModel().setSortedByProperty(null);
            }
            this.setTreePreferredWidth(this.treeColumnWidth);
            for (int i = 0; i < this.tableModel.getColumnCount(); ++i) {
                this.setTableColumnPreferredWidth(this.tableModel.getArrayIndex(i), this.tableModel.getVisibleColumnWidth(i));
            }
        }
    }

    private void setCurrentWidths() {
        this.treeColumnWidth = this.treeTable.getColumnModel().getColumn(0).getWidth();
        for (int i = 0; i < this.tableModel.getColumnCount(); ++i) {
            int n = this.treeTable.getColumnModel().getColumn(i + 1).getWidth();
            this.tableModel.setVisibleColumnWidth(i, n);
        }
    }

    void initializeTree() {
    }

    private void initializeTreeTable() {
        this.treeModel = this.createModel();
        this.treeTable = new TreeTable(this.treeModel, this.tableModel);
        this.tree = ((TreeTable)this.treeTable).getTree();
        this.defaultHeaderRenderer = this.treeTable.getTableHeader().getDefaultRenderer();
        this.treeTable.getTableHeader().setDefaultRenderer(new SortingHeaderRenderer());
        this.managerListener = new TreeView.TreePropertyListener(this);
        this.tree.addTreeExpansionListener(this.managerListener);
        this.tree.addTreeExpansionListener(new TreeExpansionListener(){

            public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
                TreePath treePath = treeExpansionEvent.getPath();
                if (treePath != null) {
                    Enumeration<TreePath> enumeration = TreeTableView.this.tree.getExpandedDescendants(treePath);
                    TreeTableView.this.getSortedNodeTreeModel().sortChildren((VisualizerNode)treePath.getLastPathComponent(), true);
                    while (enumeration.hasMoreElements()) {
                        TreeTableView.this.tree.expandPath(enumeration.nextElement());
                    }
                }
            }

            public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            }
        });
        this.defaultActionListener = new TreeView.PopupSupport(this);
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                SwingUtilities.invokeLater(TreeTableView.this.defaultActionListener);
            }

            public boolean isEnabled() {
                return TreeTableView.this.treeTable.isFocusOwner() || TreeTableView.this.tree.isFocusOwner();
            }
        };
        this.treeTable.getInputMap(1).put(KeyStroke.getKeyStroke(121, 64), "org.openide.actions.PopupAction");
        this.treeTable.getActionMap().put("org.openide.actions.PopupAction", abstractAction);
        this.tree.addMouseListener(this.defaultActionListener);
        this.tableMouseListener = new MouseUtils.PopupMouseAdapter(){

            public void showPopup(MouseEvent mouseEvent) {
                if (TreeTableView.this.isPopupAllowed()) {
                    if (mouseEvent.getY() > TreeTableView.this.treeTable.getHeight()) {
                        TreeTableView.this.treeTable.clearSelection();
                    } else {
                        int n = TreeTableView.this.treeTable.rowAtPoint(mouseEvent.getPoint());
                        boolean bl = false;
                        int[] nArray = TreeTableView.this.tree.getSelectionRows();
                        for (int i = 0; null != nArray && i < nArray.length; ++i) {
                            if (n != nArray[i]) continue;
                            bl = true;
                            break;
                        }
                        if (!bl) {
                            TreeTableView.this.tree.setSelectionRow(n);
                        }
                    }
                    TreeTableView.this.createPopup(mouseEvent);
                }
            }
        };
        this.treeTable.addMouseListener((MouseListener)this.tableMouseListener);
        if (UIManager.getColor("control") != null) {
            this.treeTable.setGridColor(UIManager.getColor("control"));
        }
    }

    public void setSelectionMode(int n) {
        super.setSelectionMode(n);
        if (n == 1) {
            this.treeTable.getSelectionModel().setSelectionMode(0);
        } else if (n == 2) {
            this.treeTable.getSelectionModel().setSelectionMode(1);
        } else if (n == 4) {
            this.treeTable.getSelectionModel().setSelectionMode(2);
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessContext == null) {
            this.accessContext = new AccessibleTreeTableView();
        }
        return this.accessContext;
    }

    private void initializeTreeScrollSupport() {
        this.scrollPane = new JScrollPane();
        this.scrollPane.setName("TreeTableView.scrollpane");
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.scrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
        if (UIManager.getColor("Table.background") != null) {
            this.scrollPane.getViewport().setBackground(UIManager.getColor("Table.background"));
        }
        this.hScrollBar = new JScrollBar(0);
        this.hScrollBar.putClientProperty("JScrollBar.isFreeStanding", Boolean.FALSE);
        this.hScrollBar.setVisible(false);
        this.listener = new ScrollListener();
        this.treeTable.addPropertyChangeListener(this.listener);
        this.scrollPane.getViewport().addComponentListener(this.listener);
        this.tree.addPropertyChangeListener(this.listener);
        this.hScrollBar.getModel().addChangeListener(this.listener);
    }

    public void setPopupAllowed(boolean bl) {
        if (this.tree == null) {
            return;
        }
        if (this.popupListener == null && bl) {
            this.popupListener = new TreeView.PopupAdapter(){

                protected void showPopup(MouseEvent mouseEvent) {
                    int n = TreeTableView.this.tree.getClosestRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                    if (!TreeTableView.this.tree.isRowSelected(n)) {
                        TreeTableView.this.tree.setSelectionRow(n);
                    }
                }
            };
            this.tree.addMouseListener((MouseListener)((Object)this.popupListener));
            return;
        }
        if (this.popupListener != null && !bl) {
            this.tree.removeMouseListener((MouseListener)((Object)this.popupListener));
            this.popupListener = null;
            return;
        }
    }

    public void setDefaultActionAllowed(boolean bl) {
        if (this.tree == null) {
            return;
        }
        this.defaultActionEnabled = bl;
        if (bl) {
            this.defaultTreeActionListener = new DefaultTreeAction();
            this.treeTable.registerKeyboardAction(this.defaultTreeActionListener, KeyStroke.getKeyStroke(10, 0, false), 0);
        } else {
            this.defaultTreeActionListener = null;
            this.treeTable.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0, false));
        }
    }

    public void setProperties(Node.Property[] propertyArray) {
        this.tableModel.setProperties(propertyArray);
        this.treeColumnProperty.setProperty(this.tableModel.propertyForColumn(-1));
        if (this.treeColumnProperty.isComparable() || this.tableModel.existsComparableColumn()) {
            this.setAllowSortingByColumn(true);
            if (this.treeColumnProperty.isSortingColumn()) {
                this.getSortedNodeTreeModel().setSortedByName(true, !this.treeColumnProperty.isSortOrderDescending());
            } else {
                int n = this.tableModel.getSortingColumn();
                if (n != -1) {
                    this.getSortedNodeTreeModel().setSortedByProperty(this.tableModel.propertyForColumnEx(n), !this.tableModel.isSortOrderDescending());
                }
            }
        }
    }

    public final void setTableAutoResizeMode(int n) {
        this.treeTable.setAutoResizeMode(n);
    }

    public final int getTableAutoResizeMode() {
        return this.treeTable.getAutoResizeMode();
    }

    public final void setTableColumnPreferredWidth(int n, int n2) {
        if (n == -1) {
            return;
        }
        this.tableModel.setArrayColumnWidth(n, n2);
        int n3 = this.tableModel.getVisibleIndex(n);
        if (n3 != -1) {
            this.treeTable.getColumnModel().getColumn(n3 + 1).setPreferredWidth(n2);
        }
    }

    public final int getTableColumnPreferredWidth(int n) {
        int n2 = this.tableModel.getVisibleIndex(n);
        if (n2 != -1) {
            return this.treeTable.getColumnModel().getColumn(n2 + 1).getPreferredWidth();
        }
        return this.tableModel.getArrayColumnWidth(n);
    }

    public final void setTreePreferredWidth(int n) {
        this.treeTable.getColumnModel().getColumn(((TreeTable)this.treeTable).getTreeColumnIndex()).setPreferredWidth(n);
    }

    public final int getTreePreferredWidth() {
        return this.treeTable.getColumnModel().getColumn(((TreeTable)this.treeTable).getTreeColumnIndex()).getPreferredWidth();
    }

    public void addNotify() {
        if (this.treeTable.getParent() != null) {
            this.treeTableParent = this.treeTable.getParent();
            this.treeTableParent.addMouseListener((MouseListener)this.tableMouseListener);
        }
        super.addNotify();
        if (this.tableModel.getRowCount() == 0) {
            Node[] nodeArray = new Node[this.tree.getRowCount()];
            for (int i = 0; i < this.tree.getRowCount(); ++i) {
                nodeArray[i] = Visualizer.findNode(this.tree.getPathForRow(i).getLastPathComponent());
            }
            this.tableModel.setNodes(nodeArray);
        }
        this.listener.revalidateScrollBar();
    }

    public void removeNotify() {
        super.removeNotify();
        if (this.treeTableParent != null) {
            this.treeTableParent.removeMouseListener((MouseListener)this.tableMouseListener);
        }
        this.treeTableParent = null;
        this.tableModel.setNodes(new Node[0]);
    }

    public void addMouseListener(MouseListener mouseListener) {
        super.addMouseListener(mouseListener);
        this.treeTable.getTableHeader().addMouseListener(mouseListener);
    }

    public void removeMouseListener(MouseListener mouseListener) {
        super.removeMouseListener(mouseListener);
        this.treeTable.getTableHeader().removeMouseListener(mouseListener);
    }

    public void setDragSource(boolean bl) {
    }

    public void setDropTarget(boolean bl) {
    }

    Point getPositionForPopup() {
        int n = this.treeTable.getSelectedRow();
        if (n < 0) {
            return null;
        }
        int n2 = this.treeTable.getSelectedColumn();
        if (n2 < 0) {
            n2 = 0;
        }
        Rectangle rectangle = null;
        rectangle = n2 == 0 ? this.tree.getRowBounds(n) : this.treeTable.getCellRect(n, n2, true);
        Point point = SwingUtilities.convertPoint(this.treeTable, rectangle.x, rectangle.y, this);
        return point;
    }

    private void createPopup(MouseEvent mouseEvent) {
        Point point = SwingUtilities.convertPoint(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY(), this);
        this.createPopup(point.x, point.y);
        mouseEvent.consume();
    }

    void createPopup(int n, int n2) {
        int n3 = n - ((TreeTable)this.treeTable).getPositionX();
        if (this.allowHideColumns || this.allowSortingByColumn) {
            int n4 = this.treeTable.getColumnModel().getColumnIndexAtX(n3);
            super.createExtendedPopup(n, n2, this.getListMenu(n4));
        } else {
            super.createPopup(n, n2);
        }
    }

    private JMenu getListMenu(final int n) {
        JMenuItem jMenuItem;
        JMenu jMenu = new JMenu(NbBundle.getBundle(NodeTableModel.class).getString("LBL_ListOptions"));
        if (this.allowHideColumns && n > 0) {
            JMenuItem jMenuItem2;
            jMenuItem = new JMenu(NbBundle.getBundle(NodeTableModel.class).getString("LBL_ColsMenu"));
            boolean bl = false;
            if (n > 1) {
                jMenuItem2 = new JMenuItem(NbBundle.getBundle(NodeTableModel.class).getString("LBL_MoveLeft"));
                jMenuItem2.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        TreeTableView.this.treeTable.getColumnModel().moveColumn(n, n - 1);
                    }
                });
                ((JMenu)jMenuItem).add(jMenuItem2);
                bl = true;
            }
            if (n < this.tableModel.getColumnCount()) {
                jMenuItem2 = new JMenuItem(NbBundle.getBundle(NodeTableModel.class).getString("LBL_MoveRight"));
                jMenuItem2.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        TreeTableView.this.treeTable.getColumnModel().moveColumn(n, n + 1);
                    }
                });
                ((JMenu)jMenuItem).add(jMenuItem2);
                bl = true;
            }
            if (bl) {
                jMenu.add(jMenuItem);
            }
        }
        if (this.allowSortingByColumn) {
            int n2;
            int n3;
            JRadioButtonMenuItem jRadioButtonMenuItem;
            jMenuItem = new JMenu(NbBundle.getBundle(NodeTableModel.class).getString("LBL_SortMenu"));
            JRadioButtonMenuItem jRadioButtonMenuItem2 = new JRadioButtonMenuItem(NbBundle.getBundle(NodeTableModel.class).getString("LBL_NoSort"), !this.getSortedNodeTreeModel().isSortingActive());
            jRadioButtonMenuItem2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    TreeTableView.this.noSorting();
                }
            });
            ((JMenu)jMenuItem).add(jRadioButtonMenuItem2);
            int n4 = 0;
            if (this.treeColumnProperty.isComparable()) {
                ++n4;
                jRadioButtonMenuItem = new JRadioButtonMenuItem(this.treeTable.getColumnName(0), this.treeColumnProperty.isSortingColumn());
                jRadioButtonMenuItem.setHorizontalTextPosition(2);
                jRadioButtonMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        TreeTableView.this.setSortingColumn(-1);
                    }
                });
                ((JMenu)jMenuItem).add(jRadioButtonMenuItem);
            }
            for (n3 = 0; n3 < this.tableModel.getColumnCount(); n3 += 1) {
                if (!this.tableModel.isComparableColumn(n3)) continue;
                ++n4;
                jRadioButtonMenuItem = new JRadioButtonMenuItem(this.tableModel.getColumnName(n3), this.tableModel.isSortingColumnEx(this.tableModel.translateVisibleColumnIndex(n3)));
                jRadioButtonMenuItem.setHorizontalTextPosition(2);
                n2 = this.tableModel.translateVisibleColumnIndex(n3);
                jRadioButtonMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        TreeTableView.this.setSortingColumn(n2);
                    }
                });
                ((JMenu)jMenuItem).add(jRadioButtonMenuItem);
            }
            for (n3 = 0; n3 < this.tableModel.getColumnCountEx(); n3 += 1) {
                if (!this.tableModel.isComparableColumnEx(n3) || this.tableModel.isVisibleColumnEx(n3)) continue;
                ++n4;
                jRadioButtonMenuItem = new JRadioButtonMenuItem(this.tableModel.getColumnNameEx(n3), this.tableModel.isSortingColumnEx(n3));
                jRadioButtonMenuItem.setHorizontalTextPosition(2);
                n2 = n3;
                jRadioButtonMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        TreeTableView.this.setSortingColumn(n2);
                    }
                });
                ((JMenu)jMenuItem).add(jRadioButtonMenuItem);
            }
            if (n4 > 0) {
                ((JMenu)jMenuItem).addSeparator();
                n3 = this.treeColumnProperty.isSortingColumn() ? (int)(this.treeColumnProperty.isSortOrderDescending() ? 1 : 0) : (int)(this.tableModel.isSortOrderDescending() ? 1 : 0);
                JRadioButtonMenuItem jRadioButtonMenuItem3 = new JRadioButtonMenuItem(NbBundle.getBundle(NodeTableModel.class).getString("LBL_Ascending"), n3 == 0);
                jRadioButtonMenuItem3.setHorizontalTextPosition(2);
                jRadioButtonMenuItem3.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        TreeTableView.this.setSortingOrder(true);
                    }
                });
                ((JMenu)jMenuItem).add(jRadioButtonMenuItem3);
                JRadioButtonMenuItem jRadioButtonMenuItem4 = new JRadioButtonMenuItem(NbBundle.getBundle(NodeTableModel.class).getString("LBL_Descending"), n3 != 0);
                jRadioButtonMenuItem4.setHorizontalTextPosition(2);
                jRadioButtonMenuItem4.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        TreeTableView.this.setSortingOrder(false);
                    }
                });
                ((JMenu)jMenuItem).add(jRadioButtonMenuItem4);
                if (!this.getSortedNodeTreeModel().isSortingActive()) {
                    jRadioButtonMenuItem3.setEnabled(false);
                    jRadioButtonMenuItem4.setEnabled(false);
                }
                jMenu.add(jMenuItem);
            }
        }
        if (this.allowHideColumns) {
            jMenuItem = new JMenuItem(NbBundle.getBundle(NodeTableModel.class).getString("LBL_ChangeColumns"));
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    TreeTableView.this.selectVisibleColumns();
                }
            });
            jMenu.add(jMenuItem);
        }
        return jMenu;
    }

    private void setSortingColumn(int n) {
        this.tableModel.setSortingColumnEx(n);
        if (n != -1) {
            this.getSortedNodeTreeModel().setSortedByProperty(this.tableModel.propertyForColumnEx(n), !this.tableModel.isSortOrderDescending());
            this.treeColumnProperty.setSortingColumn(false);
        } else {
            this.getSortedNodeTreeModel().setSortedByName(true, !this.treeColumnProperty.isSortOrderDescending());
            this.treeColumnProperty.setSortingColumn(true);
        }
        this.treeTable.getTableHeader().repaint();
    }

    private void noSorting() {
        this.tableModel.setSortingColumnEx(-1);
        this.getSortedNodeTreeModel().setNoSorting();
        this.treeColumnProperty.setSortingColumn(false);
        this.treeTable.getTableHeader().repaint();
    }

    private void setSortingOrder(boolean bl) {
        if (this.treeColumnProperty.isSortingColumn()) {
            this.treeColumnProperty.setSortOrderDescending(!bl);
        } else {
            this.tableModel.setSortOrderDescending(!bl);
        }
        this.getSortedNodeTreeModel().setSortOrder(bl);
        this.treeTable.getTableHeader().repaint();
    }

    private synchronized SortedNodeTreeModel getSortedNodeTreeModel() {
        if (this.sortedNodeTreeModel == null) {
            this.sortedNodeTreeModel = new SortedNodeTreeModel();
        }
        return this.sortedNodeTreeModel;
    }

    private static class TreeColumnProperty {
        private Node.Property p = null;

        TreeColumnProperty() {
        }

        void setProperty(Node.Property property) {
            this.p = property;
        }

        boolean isComparable() {
            if (this.p == null) {
                return false;
            }
            Object object = this.p.getValue("ComparableColumnTTV");
            if (object != null && object instanceof Boolean) {
                return (Boolean)object;
            }
            return false;
        }

        boolean isSortingColumn() {
            if (this.p == null) {
                return false;
            }
            Object object = this.p.getValue("SortingColumnTTV");
            if (object != null && object instanceof Boolean) {
                return (Boolean)object;
            }
            return false;
        }

        void setSortingColumn(boolean bl) {
            if (this.p == null) {
                return;
            }
            this.p.setValue("SortingColumnTTV", (Object)(bl ? Boolean.TRUE : Boolean.FALSE));
        }

        boolean isSortOrderDescending() {
            if (this.p == null) {
                return false;
            }
            Object object = this.p.getValue("DescendingOrderTTV");
            if (object != null && object instanceof Boolean) {
                return (Boolean)object;
            }
            return false;
        }

        void setSortOrderDescending(boolean bl) {
            if (this.p == null) {
                return;
            }
            this.p.setValue("DescendingOrderTTV", (Object)(bl ? Boolean.TRUE : Boolean.FALSE));
        }
    }

    private class SortingHeaderRenderer
    extends DefaultTableCellRenderer {
        SortingHeaderRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = TreeTableView.this.defaultHeaderRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (component instanceof JLabel) {
                if (n2 == 0 && TreeTableView.this.treeColumnProperty.isSortingColumn()) {
                    ((JLabel)component).setIcon(this.getProperIcon(TreeTableView.this.treeColumnProperty.isSortOrderDescending()));
                    ((JLabel)component).setHorizontalTextPosition(2);
                    component.setFont(new Font(component.getFont().getName(), 1, component.getFont().getSize()));
                } else if (n2 != 0 && TreeTableView.this.tableModel.getVisibleSortingColumn() + 1 == n2) {
                    ((JLabel)component).setIcon(this.getProperIcon(TreeTableView.this.tableModel.isSortOrderDescending()));
                    ((JLabel)component).setHorizontalTextPosition(2);
                    component.setFont(new Font(component.getFont().getName(), 1, component.getFont().getSize()));
                } else {
                    ((JLabel)component).setIcon(null);
                }
            }
            return component;
        }

        private ImageIcon getProperIcon(boolean bl) {
            if (bl) {
                return new ImageIcon(Utilities.loadImage((String)TreeTableView.SORT_DESC_ICON));
            }
            return new ImageIcon(Utilities.loadImage((String)TreeTableView.SORT_ASC_ICON));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SortedNodeTreeModel
    extends NodeTreeModel {
        private Node.Property sortedByProperty;
        private boolean sortAscending = true;
        private Comparator<VisualizerNode> rowComparator;
        private boolean sortedByName = false;
        private SortingTask sortingTask = null;

        SortedNodeTreeModel() {
        }

        void setNoSorting() {
            this.setSortedByProperty(null);
            this.setSortedByName(false);
            this.sortingChanged();
        }

        boolean isSortingActive() {
            return this.sortedByProperty != null || this.sortedByName;
        }

        void setSortedByProperty(Node.Property property) {
            if (this.sortedByProperty == property) {
                return;
            }
            this.sortedByProperty = property;
            if (property == null) {
                this.rowComparator = null;
            } else {
                this.sortedByName = false;
            }
            this.sortingChanged();
        }

        void setSortedByProperty(Node.Property property, boolean bl) {
            if (this.sortedByProperty == property && bl == this.sortAscending) {
                return;
            }
            this.sortedByProperty = property;
            this.sortAscending = bl;
            if (property == null) {
                this.rowComparator = null;
            } else {
                this.sortedByName = false;
            }
            this.sortingChanged();
        }

        void setSortedByName(boolean bl, boolean bl2) {
            if (this.sortedByName == bl && bl2 == this.sortAscending) {
                return;
            }
            this.sortedByName = bl;
            this.sortAscending = bl2;
            if (this.sortedByName) {
                this.sortedByProperty = null;
            }
            this.sortingChanged();
        }

        void setSortedByName(boolean bl) {
            this.sortedByName = bl;
            if (this.sortedByName) {
                this.sortedByProperty = null;
            }
            this.sortingChanged();
        }

        void setSortOrder(boolean bl) {
            if (bl == this.sortAscending) {
                return;
            }
            this.sortAscending = bl;
            this.sortingChanged();
        }

        private Node.Property getNodeProperty(Node node, Node.Property property) {
            Node.PropertySet[] propertySetArray = node.getPropertySets();
            int n = propertySetArray.length;
            for (int i = 0; i < n; ++i) {
                Node.Property[] propertyArray = propertySetArray[i].getProperties();
                int n2 = propertyArray.length;
                for (int j = 0; j < n2; ++j) {
                    if (!propertyArray[j].equals((Object)property)) continue;
                    return propertyArray[j];
                }
            }
            return null;
        }

        synchronized Comparator<VisualizerNode> getRowComparator() {
            if (this.rowComparator == null) {
                this.rowComparator = new Comparator<VisualizerNode>(){

                    @Override
                    public int compare(VisualizerNode visualizerNode, VisualizerNode visualizerNode2) {
                        if (visualizerNode == visualizerNode2) {
                            return 0;
                        }
                        Node node = visualizerNode.node;
                        Node node2 = visualizerNode2.node;
                        if (node == null && node2 == null) {
                            return 0;
                        }
                        if (node == null) {
                            return 1;
                        }
                        if (node2 == null) {
                            return -1;
                        }
                        if (node.getParentNode() == null || node2.getParentNode() == null) {
                            Logger.getAnonymousLogger().warning("TTV.compare: Node " + node + " or " + node2 + " has no parent!");
                            return 0;
                        }
                        if (!node.getParentNode().equals((Object)node2.getParentNode())) {
                            Logger.getAnonymousLogger().warning("TTV.compare: Nodes " + node + " and " + node2 + " has different parent!");
                            return 0;
                        }
                        int n = 0;
                        if (SortedNodeTreeModel.this.sortedByName) {
                            n = node.getDisplayName().compareTo(node2.getDisplayName());
                            return SortedNodeTreeModel.this.sortAscending ? n : -n;
                        }
                        Node.Property property = SortedNodeTreeModel.this.getNodeProperty(node, SortedNodeTreeModel.this.sortedByProperty);
                        Node.Property property2 = SortedNodeTreeModel.this.getNodeProperty(node2, SortedNodeTreeModel.this.sortedByProperty);
                        if (property == null && property2 == null) {
                            return 0;
                        }
                        try {
                            if (property == null) {
                                n = -1;
                            } else if (property2 == null) {
                                n = 1;
                            } else {
                                Object object = property.getValue();
                                Object object2 = property2.getValue();
                                if (object == null && object2 == null) {
                                    return 0;
                                }
                                if (object == null) {
                                    n = -1;
                                } else if (object2 == null) {
                                    n = 1;
                                } else {
                                    if (object.getClass() != object2.getClass() || !(object instanceof Comparable)) {
                                        object = object.toString();
                                        object2 = object2.toString();
                                    }
                                    n = ((Comparable)object).compareTo(object2);
                                }
                            }
                            return SortedNodeTreeModel.this.sortAscending ? n : -n;
                        }
                        catch (Exception exception) {
                            Logger.getLogger(TreeTableView.class.getName()).log(Level.WARNING, null, exception);
                            return 0;
                        }
                    }
                };
            }
            return this.rowComparator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void sortChildren(VisualizerNode visualizerNode, boolean bl) {
            if (bl) {
                SortedNodeTreeModel sortedNodeTreeModel = this;
                synchronized (sortedNodeTreeModel) {
                    if (this.sortingTask != null) {
                        this.sortingTask.remove(visualizerNode);
                        if (this.sortingTask.isEmpty()) {
                            this.sortingTask = null;
                        }
                    }
                }
                this.doSortChildren(visualizerNode);
            } else {
                SortedNodeTreeModel sortedNodeTreeModel = this;
                synchronized (sortedNodeTreeModel) {
                    if (this.sortingTask == null) {
                        this.sortingTask = new SortingTask();
                        SwingUtilities.invokeLater(this.sortingTask);
                    }
                }
                this.sortingTask.add(visualizerNode);
            }
        }

        void doSortChildren(VisualizerNode visualizerNode) {
            if (this.isSortingActive()) {
                Comparator<VisualizerNode> comparator = this.getRowComparator();
                if (comparator != null || visualizerNode != null) {
                    visualizerNode.reorderChildren(comparator);
                }
            } else {
                visualizerNode.naturalOrder();
            }
        }

        void sortingChanged() {
            TreeNode treeNode = (TreeNode)this.getRoot();
            ArrayList<TreePath> arrayList = new ArrayList<TreePath>();
            Enumeration<TreePath> enumeration = TreeTableView.this.tree.getExpandedDescendants(new TreePath(treeNode));
            while (enumeration != null && enumeration.hasMoreElements()) {
                TreePath treePath = enumeration.nextElement();
                this.sortChildren((VisualizerNode)treePath.getLastPathComponent(), true);
                arrayList.add(treePath);
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                TreeTableView.this.tree.expandPath((TreePath)arrayList.get(i));
            }
        }

        String getRootDescription() {
            if (this.getRoot() instanceof VisualizerNode) {
                return ((VisualizerNode)this.getRoot()).getShortDescription();
            }
            return "";
        }

        @Override
        public void nodesWereInserted(TreeNode treeNode, int[] nArray) {
            super.nodesWereInserted(treeNode, nArray);
            if (treeNode instanceof VisualizerNode && this.isSortingActive()) {
                this.sortChildren((VisualizerNode)treeNode, false);
            }
        }

        @Override
        public void nodesChanged(TreeNode treeNode, int[] nArray) {
            super.nodesChanged(treeNode, nArray);
            if (treeNode != null && nArray != null && this.isSortingActive()) {
                this.sortChildren((VisualizerNode)treeNode, false);
            }
        }

        @Override
        public void setRoot(TreeNode treeNode) {
            super.setRoot(treeNode);
            if (treeNode instanceof VisualizerNode && this.isSortingActive()) {
                this.sortChildren((VisualizerNode)treeNode, false);
            }
        }

        private class SortingTask
        implements Runnable {
            private HashSet<VisualizerNode> toSort = new HashSet();

            private SortingTask() {
            }

            public synchronized void add(VisualizerNode visualizerNode) {
                this.toSort.add(visualizerNode);
            }

            public synchronized void remove(VisualizerNode visualizerNode) {
                this.toSort.remove(visualizerNode);
            }

            public synchronized boolean isEmpty() {
                return this.toSort.isEmpty();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                SortedNodeTreeModel sortedNodeTreeModel = SortedNodeTreeModel.this;
                synchronized (sortedNodeTreeModel) {
                    SortedNodeTreeModel.this.sortingTask = null;
                }
                for (VisualizerNode visualizerNode : this.toSort) {
                    SortedNodeTreeModel.this.doSortChildren(visualizerNode);
                }
            }
        }
    }

    private class DefaultTreeAction
    implements ActionListener {
        DefaultTreeAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Action action;
            if (TreeTableView.this.treeTable.getSelectedColumn() != ((TreeTable)TreeTableView.this.treeTable).getTreeColumnIndex()) {
                return;
            }
            Node[] nodeArray = TreeTableView.this.manager.getSelectedNodes();
            if (nodeArray.length == 1 && (action = nodeArray[0].getPreferredAction()) != null) {
                if (action.isEnabled()) {
                    action.actionPerformed(new ActionEvent(nodeArray[0], 1001, ""));
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
        }
    }

    private static final class CompoundScrollPane
    extends JPanel
    implements Scrollable {
        CompoundScrollPane() {
        }

        public void setBorder(Border border) {
        }

        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
            return 10;
        }

        public boolean getScrollableTracksViewportHeight() {
            return true;
        }

        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
            return 10;
        }
    }

    private final class ScrollListener
    extends ComponentAdapter
    implements PropertyChangeListener,
    ChangeListener {
        boolean movecorrection = false;

        ScrollListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (((TreeTable)TreeTableView.this.treeTable).getTreeColumnIndex() == -1) {
                return;
            }
            if ("width".equals(propertyChangeEvent.getPropertyName())) {
                if (!TreeTableView.this.treeTable.equals(propertyChangeEvent.getSource())) {
                    Dimension dimension = TreeTableView.this.hScrollBar.getPreferredSize();
                    dimension.width = TreeTableView.this.treeTable.getColumnModel().getColumn(((TreeTable)TreeTableView.this.treeTable).getTreeColumnIndex()).getWidth();
                    TreeTableView.this.hScrollBar.setPreferredSize(dimension);
                    TreeTableView.this.hScrollBar.revalidate();
                    TreeTableView.this.hScrollBar.repaint();
                }
                this.revalidateScrollBar();
            } else if ("positionX".equals(propertyChangeEvent.getPropertyName())) {
                this.revalidateScrollBar();
            } else if ("treeColumnIndex".equals(propertyChangeEvent.getPropertyName())) {
                TreeTableView.this.treeTable.getColumnModel().getColumn(((TreeTable)TreeTableView.this.treeTable).getTreeColumnIndex()).addPropertyChangeListener(TreeTableView.this.listener);
            } else if ("column_moved".equals(propertyChangeEvent.getPropertyName())) {
                int n = (Integer)propertyChangeEvent.getOldValue();
                int n2 = (Integer)propertyChangeEvent.getNewValue();
                if (n == 0 || n2 == 0) {
                    if (this.movecorrection) {
                        this.movecorrection = false;
                    } else {
                        this.movecorrection = true;
                        TreeTableView.this.treeTable.getColumnModel().moveColumn(n2, n);
                    }
                    return;
                }
                TreeTableView.this.treeTable.getTableHeader().getColumnModel().getColumn(n).setModelIndex(n);
                TreeTableView.this.treeTable.getTableHeader().getColumnModel().getColumn(n2).setModelIndex(n2);
                TreeTableView.this.tableModel.moveColumn(n - 1, n2 - 1);
            }
        }

        public void componentResized(ComponentEvent componentEvent) {
            this.revalidateScrollBar();
        }

        public void stateChanged(ChangeEvent changeEvent) {
            int n = TreeTableView.this.hScrollBar.getModel().getValue();
            ((TreeTable)TreeTableView.this.treeTable).setPositionX(n);
        }

        private void revalidateScrollBar() {
            if (!TreeTableView.this.isDisplayable()) {
                return;
            }
            if (TreeTableView.this.treeTable.getColumnModel().getColumnCount() > 0 && ((TreeTable)TreeTableView.this.treeTable).getTreeColumnIndex() >= 0) {
                int n = TreeTableView.this.treeTable.getColumnModel().getColumn(((TreeTable)TreeTableView.this.treeTable).getTreeColumnIndex()).getWidth();
                int n2 = TreeTableView.this.tree.getPreferredSize().width;
                int n3 = ((TreeTableView)TreeTableView.this).scrollPane.getViewport().getSize().height;
                int n4 = TreeTableView.this.tree.getPreferredSize().height;
                int n5 = ((TreeTable)TreeTableView.this.treeTable).getPositionX();
                int n6 = Math.max(0, Math.min(n5, n2 - n));
                boolean bl = TreeTableView.this.hScrollBar.isVisible();
                boolean bl2 = TreeTableView.this.scrollPane.getVerticalScrollBar().isVisible();
                int n7 = bl ? TreeTableView.this.hScrollBar.getHeight() : 0;
                int n8 = TreeTableView.this.scrollPane.getVerticalScrollBar().getWidth();
                TreeTableView.this.hScrollBar.setValues(n6, n, 0, n2);
                if (TreeTableView.this.hideHScrollBar || n2 <= n || bl2 && n4 <= n3 + n7 && n2 <= n + n8) {
                    TreeTableView.this.hScrollBar.setVisible(false);
                } else {
                    TreeTableView.this.hScrollBar.setVisible(true);
                }
            }
        }
    }

    private class AccessibleTreeTableView
    extends JScrollPane.AccessibleJScrollPane {
        AccessibleTreeTableView() {
            super(TreeTableView.this);
        }

        public void setAccessibleName(String string) {
            super.setAccessibleName(string);
            if (TreeTableView.this.treeTable != null) {
                TreeTableView.this.treeTable.getAccessibleContext().setAccessibleName(string);
            }
        }

        public void setAccessibleDescription(String string) {
            super.setAccessibleDescription(string);
            if (TreeTableView.this.treeTable != null) {
                TreeTableView.this.treeTable.getAccessibleContext().setAccessibleDescription(string);
            }
        }
    }
}

