/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.cpu;

import java.awt.image.BufferedImage;
import org.netbeans.lib.profiler.results.cpu.CPUResultsSnapshot;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.FilterComponent;
import org.netbeans.lib.profiler.ui.cpu.CPUResUserActionsHandler;
import org.netbeans.lib.profiler.ui.cpu.CPUSelectionHandler;
import org.netbeans.lib.profiler.ui.cpu.FlatProfilePanel;
import org.netbeans.lib.profiler.ui.cpu.ScreenshotProvider;

public class SnapshotFlatProfilePanel
extends FlatProfilePanel
implements ScreenshotProvider {
    private CPUResultsSnapshot snapshot;

    public SnapshotFlatProfilePanel(CPUResUserActionsHandler actionsHandler) {
        this(actionsHandler, null);
    }

    public SnapshotFlatProfilePanel(CPUResUserActionsHandler actionsHandler, CPUSelectionHandler selectionHandler) {
        super(actionsHandler, selectionHandler);
    }

    public BufferedImage getCurrentViewScreenshot(boolean onlyVisibleArea) {
        if (this.resTable == null) {
            return null;
        }
        if (onlyVisibleArea) {
            return UIUtils.createScreenshot(this.jScrollPane);
        }
        return UIUtils.createScreenshot(this.resTable);
    }

    public void setDataToDisplay(CPUResultsSnapshot snapshot, int threadId, int view) {
        this.snapshot = snapshot;
        this.currentView = view;
        this.threadId = threadId;
        this.flatProfileContainer = null;
        this.collectingTwoTimeStamps = snapshot.isCollectingTwoTimeStamps();
    }

    public String getDefaultViewName() {
        return "cpu-hotspots";
    }

    public CPUResultsSnapshot getSnapshot() {
        return this.snapshot;
    }

    public boolean fitsVisibleArea() {
        return !this.jScrollPane.getVerticalScrollBar().isEnabled();
    }

    protected String[] getMethodClassNameAndSig(int methodId, int currentView) {
        return this.snapshot.getMethodClassNameAndSig(methodId, currentView);
    }

    protected void obtainResults() {
        if (this.snapshot != null) {
            this.flatProfileContainer = this.snapshot.getFlatProfile(this.threadId, this.currentView);
        }
        if (this.snapshot == null || !this.collectingTwoTimeStamps && this.sortBy == 3) {
            this.sortBy = 2;
        }
        this.flatProfileContainer.filterOriginalData(FilterComponent.getFilterStrings(this.filterString), this.filterType, this.valueFilterValue);
        this.flatProfileContainer.sortBy(this.sortBy, this.sortOrder);
        this.setResultsAvailable(true);
    }

    protected void showReverseCallGraph(int threadId, int methodId, int currentView, int sortingColumn, boolean sortingOrder) {
        this.actionsHandler.showReverseCallGraph(this.snapshot, threadId, methodId, currentView, sortingColumn, sortingOrder);
    }

    protected boolean supportsReverseCallGraph() {
        return true;
    }

    protected boolean supportsSubtreeCallGraph() {
        return false;
    }

    protected void updateResults() {
        int currentColumnCount;
        if (this.threadId < -1) {
            return;
        }
        int n = currentColumnCount = this.collectingTwoTimeStamps ? 5 : 4;
        if (this.columnCount != currentColumnCount) {
            this.initColumnsData();
        } else if (this.resTable != null) {
            this.saveColumnsData();
        }
        this.flatProfileContainer.sortBy(this.sortBy, this.sortOrder);
        this.jScrollPane.setViewportView(this.resTable);
        this.jScrollPane.getViewport().setBackground(this.resTable.getBackground());
    }
}

