/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.opengl;

import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.java2d.loops.CompositeType;
import sun.java2d.opengl.OGLGraphicsConfig;
import sun.java2d.opengl.OGLSurfaceData;

abstract class OGLPaints {
    private static Map<Integer, OGLPaints> impls = new HashMap<Integer, OGLPaints>(4, 1.0f);

    OGLPaints() {
    }

    static boolean isValid(SunGraphics2D sunGraphics2D) {
        OGLPaints oGLPaints = impls.get(sunGraphics2D.paintState);
        return oGLPaints != null && oGLPaints.isPaintValid(sunGraphics2D);
    }

    abstract boolean isPaintValid(SunGraphics2D var1);

    static {
        impls.put(2, new Gradient());
        impls.put(3, new LinearGradient());
        impls.put(4, new RadialGradient());
        impls.put(5, new Texture());
    }

    private static class Gradient
    extends OGLPaints {
        private Gradient() {
        }

        boolean isPaintValid(SunGraphics2D sunGraphics2D) {
            return true;
        }
    }

    private static class LinearGradient
    extends MultiGradient {
        private LinearGradient() {
        }

        boolean isPaintValid(SunGraphics2D sunGraphics2D) {
            LinearGradientPaint linearGradientPaint = (LinearGradientPaint)sunGraphics2D.paint;
            if (linearGradientPaint.getFractions().length == 2 && linearGradientPaint.getCycleMethod() != MultipleGradientPaint.CycleMethod.REPEAT && linearGradientPaint.getColorSpace() != MultipleGradientPaint.ColorSpaceType.LINEAR_RGB) {
                return true;
            }
            return super.isPaintValid(sunGraphics2D);
        }
    }

    private static abstract class MultiGradient
    extends OGLPaints {
        protected MultiGradient() {
        }

        boolean isPaintValid(SunGraphics2D sunGraphics2D) {
            MultipleGradientPaint multipleGradientPaint = (MultipleGradientPaint)sunGraphics2D.paint;
            if (multipleGradientPaint.getFractions().length > 12) {
                return false;
            }
            OGLSurfaceData oGLSurfaceData = (OGLSurfaceData)sunGraphics2D.surfaceData;
            OGLGraphicsConfig oGLGraphicsConfig = oGLSurfaceData.getOGLGraphicsConfig();
            return oGLGraphicsConfig.isCapPresent(256);
        }
    }

    private static class RadialGradient
    extends MultiGradient {
        private RadialGradient() {
        }
    }

    private static class Texture
    extends OGLPaints {
        private Texture() {
        }

        boolean isPaintValid(SunGraphics2D sunGraphics2D) {
            SurfaceData surfaceData;
            TexturePaint texturePaint = (TexturePaint)sunGraphics2D.paint;
            OGLSurfaceData oGLSurfaceData = (OGLSurfaceData)sunGraphics2D.surfaceData;
            BufferedImage bufferedImage = texturePaint.getImage();
            if (!oGLSurfaceData.isTexNonPow2Available()) {
                int n = bufferedImage.getWidth();
                int n2 = bufferedImage.getHeight();
                if ((n & n - 1) != 0 || (n2 & n2 - 1) != 0) {
                    return false;
                }
            }
            if (!((surfaceData = SurfaceData.getSourceSurfaceData(bufferedImage, oGLSurfaceData, CompositeType.SrcOver, null, false)) instanceof OGLSurfaceData) && !((surfaceData = SurfaceData.getSourceSurfaceData(bufferedImage, oGLSurfaceData, CompositeType.SrcOver, null, false)) instanceof OGLSurfaceData)) {
                return false;
            }
            OGLSurfaceData oGLSurfaceData2 = (OGLSurfaceData)surfaceData;
            return oGLSurfaceData2.getType() == 3;
        }
    }
}

