/*
 * Decompiled with CFR 0.152.
 */
package java2d.demos.Arcs_Curves;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java2d.AnimatingSurface;

public class Arcs
extends AnimatingSurface {
    private static String[] types = new String[]{"Arc2D.OPEN", "Arc2D.CHORD", "Arc2D.PIE"};
    private static final int CLOSE = 0;
    private static final int OPEN = 1;
    private static final int FORWARD = 0;
    private static final int BACKWARD = 1;
    private static final int DOWN = 2;
    private static final int UP = 3;
    private int aw;
    private int ah;
    private int x;
    private int y;
    private int angleStart = 45;
    private int angleExtent = 270;
    private int mouth = 0;
    private int direction = 0;

    public Arcs() {
        this.setBackground(Color.WHITE);
    }

    public void reset(int n, int n2) {
        this.x = 0;
        this.y = 0;
        this.aw = n / 12;
        this.ah = n2 / 12;
    }

    public void step(int n, int n2) {
        if (this.x + this.aw >= n - 5 && this.direction == 0) {
            this.direction = 2;
        }
        if (this.y + this.ah >= n2 - 5 && this.direction == 2) {
            this.direction = 1;
        }
        if (this.x - this.aw <= 5 && this.direction == 1) {
            this.direction = 3;
        }
        if (this.y - this.ah <= 5 && this.direction == 3) {
            this.direction = 0;
        }
        if (this.mouth == 0) {
            this.angleStart -= 5;
            this.angleExtent += 10;
        }
        if (this.mouth == 1) {
            this.angleStart += 5;
            this.angleExtent -= 10;
        }
        if (this.direction == 0) {
            this.x += 5;
            this.y = 0;
        }
        if (this.direction == 2) {
            this.x = n;
            this.y += 5;
        }
        if (this.direction == 1) {
            this.x -= 5;
            this.y = n2;
        }
        if (this.direction == 3) {
            this.x = 0;
            this.y -= 5;
        }
        if (this.angleStart == 0) {
            this.mouth = 1;
        }
        if (this.angleStart > 45) {
            this.mouth = 0;
        }
    }

    public void render(int n, int n2, Graphics2D graphics2D) {
        Cloneable cloneable;
        graphics2D.setStroke(new BasicStroke(5.0f));
        for (int i = 0; i < types.length; ++i) {
            cloneable = new Arc2D.Float(i);
            ((Arc2D)cloneable).setFrame((double)((i + 1) * n) * 0.2, (double)((i + 1) * n2) * 0.2, (double)n * 0.17, (double)n2 * 0.17);
            ((Arc2D)cloneable).setAngleStart(45.0);
            ((Arc2D)cloneable).setAngleExtent(270.0);
            graphics2D.setColor(Color.BLUE);
            graphics2D.draw((Shape)((Object)cloneable));
            graphics2D.setColor(Color.GRAY);
            graphics2D.fill((Shape)((Object)cloneable));
            graphics2D.setColor(Color.BLACK);
            graphics2D.drawString(types[i], (int)((double)((i + 1) * n) * 0.2), (int)((double)((i + 1) * n2) * 0.2 - 3.0));
        }
        Arc2D.Float float_ = new Arc2D.Float(2);
        float_.setFrame(0.0, 0.0, this.aw, this.ah);
        ((Arc2D)float_).setAngleStart(this.angleStart);
        ((Arc2D)float_).setAngleExtent(this.angleExtent);
        cloneable = AffineTransform.getTranslateInstance(this.x, this.y);
        switch (this.direction) {
            case 2: {
                ((AffineTransform)cloneable).rotate(Math.toRadians(90.0));
                break;
            }
            case 1: {
                ((AffineTransform)cloneable).rotate(Math.toRadians(180.0));
                break;
            }
            case 3: {
                ((AffineTransform)cloneable).rotate(Math.toRadians(270.0));
            }
        }
        graphics2D.setColor(Color.BLUE);
        graphics2D.fill(((AffineTransform)cloneable).createTransformedShape(float_));
    }

    public static void main(String[] stringArray) {
        Arcs.createDemoFrame(new Arcs());
    }
}

